/* [bvideo.c wk 26.5.91] Access to Video Primitives via PC BIOS
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 * History:
 * 29.05.92 wk	Fixed silly Bug in ..GetCursorForm (used || instead of |)
 *		so the retrieved cursorform wasn't okay
 * 30.11.92 wk	DOS386 failed due to casting to (byte*) instead of (byte _far*)
 * 29.12.92 wk	EMX Support added (to be enhanced later ...)
 * 26.11.93 wk	Moved into Wrapper-DLL for OS/2 2.0
 * 22.07.94 wk	added watcom dos 386 support
 */

#include <wk/tailor.h>
RCSID("$Id: bvideo.c,v 1.13 1997/10/06 12:54:47 wk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <wk/bios.h>
#include <wk/environ.h>

#if defined( OS20 ) && !defined(MAKE_WK16WRAP)
    #define INCL_DOSMODULEMGR	  /* Module Manager values */
    #include <os2.h>
#elif defined( OS2 ) /* or make WK16WRAP */
    #define INCL_SUB 1
    #include <os2.h>
#elif WINNT
#elif UNIX
    /* termios.h? */
#else
    #include <dos.h>
#endif
#if DOS16RM
    #include <zpmapi.h>
#endif

#ifdef MAKE_WK16WRAP
  #ifndef __IBMC__
     #error Must use IBM CSet/2 to build the Wrapper-DLL
  #endif
  #define FName(a) _System WK16Wrap_##a
#else
  #define FName(a) WK##a
#endif

#ifdef OS20 /* DLL stuff */
  #ifdef MAKE_WK16WRAP
     #if __IBMC__
       int _exeentry = 1;
       extern int _dllentry;
     #endif
  #else
    static int dllAvailable = 0;
    static int	    (* _dllapi GetVideoMode)( int *cols, int *page );
    static void     (* _dllapi SetVideoMode)( int modi );
    static void     (* _dllapi GetCursorPos)( int p, int *y , int *x );
    static void     (* _dllapi SetCursorPos)( int p, int y , int x );
    static unsigned (* _dllapi GetCursorForm)(void);
    static void     (* _dllapi SetCursorForm)(unsigned);
    static void LoadDll(void);
  #endif
#endif



#ifdef DOCUMENTATION
@Summary WKBiosGetVideoMode  Get Current Videomode
 #include <wk/bios.h>

 int WKBiosGetVideoMode( c, r );
 int	*c ;		Returns: Anzahl Bildschirmspalten
 int	*r ;		Returns: Anzahl Bildschirmzeilen

@Description
 Die Funktion fhrt INT 10h Funktion 0Fh aus (get video mode)
 See BIOS-Documentation.  Previous releases of this function
 returned the active page in the second parameter; I never used this,
 so I could change it. The number of rows for MSDOS is determined
 by directly analysing some BIOS-Memory locations, so it may not result
 in correct values in all cases - but I hope so.
@Return Value
 Videomode
@See Also
WKBiosSetVideoMode
@Notes
 Definierte Videomodi:
  0 - text, 40 * 25, b/w,     CGA
  1 - text, 40 * 25, 16,      CGA
  2 - text, 80 * 25, b/w,     CGA
  3 - text, 80 * 25, 16,      CGA
  4 - graf, 320*200, 4,       CGA
  5 - graf, 320*200, 4 (grau),CGA
  6 - graf, 640*200, b/w,     CGA
  7 - text, 80 * 25, b/w,     MDA
 10 - graf, 640*200, 4,       EGA
 13 - graf, 320*200, 16,      EGA
 14 - graf, 640*200, 16,      EGA
 15 - graf, 640*350, 16,      EGA
#endif

int FName(BiosGetVideoMode) ( int *cols, int *rows )
{
#if defined(OS20) && !defined(MAKE_WK16WRAP)
    if( !dllAvailable )
	LoadDll();
    return GetVideoMode( cols, rows );
#elif defined(EMX) && !OS20
    int vmode;
    int dst[2];

    if( _osmode == DOS_MODE ) {
	asm("movb $0x0f,%%ah;int $0x10;movzb %%al,%%eax;mov %%eax,%0" :
		"=g"(vmode) : : "eax");
    }
    else
	vmode = 3;

    _scrsize ( dst);
    *cols = dst[0];
    *rows = dst[1];

    return vmode;

#elif defined(OS2)
    VIOMODEINFO viomi ;

    viomi.cb = sizeof( viomi ) ;
    VioGetMode( &viomi, 0 ) ;
    *rows = viomi.row ;
    *cols = viomi.col ;
    if( viomi.fbType & VGMT_OTHER ) {
	if( viomi.fbType & VGMT_GRAPHICS ) {
	    if( viomi.color == 2 && viomi.hres == 640 )
		return 6 ;
	    else if( viomi.color == 4 )
		return viomi.hres == 640 ? 10 : 4 ;
	    else if( viomi.hres == 320 )
		return 13 ;
	    else if( viomi.vres == 200 )
		return 14 ;
	    else
		return 15 ;
	}
	else {	/* text mode */
	    if( viomi.color == 4 )
		return viomi.col == 40 ? 1:3 ;
	    else
		return viomi.col == 40 ? 0:2 ;
	}
    }
    else
	return 7 ; /* MDA 80*25*/
#elif WINNT
    return 0;  /* FIXME */
#elif defined(UNIX)
    if( rows ) *rows = 25;
    if( cols ) *cols = 80;
    return 7;
#else
    union REGS inregs, outregs ;
    int mcga;
  #if DOS386 && __ZTC__
    char _far *fp;
  #endif

    inregs.h.ah = 0x0f ; /* get video modus */
  #if __WATCOMC__ && defined(__386__)
    int386( 0x10, &inregs, &outregs ) ;
  #else
    int86( 0x10, &inregs, &outregs ) ;
  #endif
    *cols  = outregs.h.ah ;
    switch( outregs.h.al ) {
      case 0x07:    /* ega und VGA geben im Textmode immer 7 oder 3 zurueck */
      case 0x03:
      case 0x02:    /* OS/2 scheint aber 2 zurueckzugeben be mode bw80... */
      #if DOS386 && __ZTC__
	fp = _x386_mk_protected_ptr( 0x00487 );
	mcga = !*fp ;
	_x386_free_protected_ptr( fp );
      #elif DOS386 && __WATCOMC__
	mcga = !*(char*)0x0487;
      #else
	mcga = !*(char*)MK_FP(0x40,0x87);
      #endif
	if( mcga )
	    *rows = 25;
	else {
	  #if DOS386 && __ZTC__
	    fp = _x386_mk_protected_ptr( 0x00484 );
	    *rows = *(byte _far *)fp + 1 ;
	    _x386_free_protected_ptr( fp );
	  #elif DOS386 && __WATCOMC__
	    *rows = *(byte*)0x0484 + 1;
	  #else
	    *rows = *(byte*)MK_FP(0x40,0x84) + 1;
	  #endif
	    if( *rows < 20 || *rows > 120 )
		*rows = 25; /* kann ja wohl nicht sein */
	}
	break;

      case 0x23:
      case 0x4D:
      case 0x17:
      case 0x4F:
      case 0x57:
      case 0x19: *rows = 25; break;

      case 0x1A:
      case 0x24:
      case 0x45: *rows = 28; break;

      case 0x32: *rows = 34; break;

      case 0x2A: *rows = 40; break;

      case 0x4E:
      case 0x40: *rows = 43; break;

      case 0x18:
      case 0x33:
      case 0x22: *rows = 44; break;

      case 0x44:
      case 0x43:
      case 0x26:
      case 0x5A: *rows = 60; break;

      case 0x34: *rows = 66; break;

      default:	 *rows = 25; break;
    }

    return outregs.h.al ; /* modi */
#endif
}


#ifdef DOCUMENTATION
@Summary WKBiosSetVideoMode  Set Videomode
 #include <wk/bios.h>

 void WKBiosSetVideoMode( m );
 int	m ;		Neuer Videomode
@Description
 Die Funktion fhrt INT 10h Funktion 0 aus (set video mode)
@See Also
WKBiosGetVideoMode
#endif

void FName(BiosSetVideoMode)( int modi )
{
#if defined(OS20) && !defined(MAKE_WK16WRAP)
    if( !dllAvailable )
	LoadDll();
    SetVideoMode( modi );
    return;
#elif defined(EMX) && !OS20
    return; /* no way yet found to do this */
#elif defined(OS2)
    VIOMODEINFO viomi ;

    switch(modi) {
      case 0:	viomi.cb     = 8 ;
		viomi.fbType = VGMT_OTHER ;
		viomi.color  = 1 ;
		viomi.col    = 40 ;
		viomi.row    = 25 ;
		break ;
      case 1:	viomi.cb     = 8 ;
		viomi.fbType = VGMT_OTHER ;
		viomi.color  = 4 ;
		viomi.col    = 40 ;
		viomi.row    = 25 ;
		break ;
      case 2:	viomi.cb     = 8 ;
		viomi.fbType = VGMT_OTHER ;
		viomi.color  = 1 ;
		viomi.col    = 80 ;
		viomi.row    = 25 ;
		break ;
      case 3:	viomi.cb     = 8 ;
		viomi.fbType = VGMT_OTHER ;
		viomi.color  = 4 ;
		viomi.col    = 80 ;
		viomi.row    = 25 ;
		break ;
      case 4:	viomi.cb     = 12 ;
		viomi.fbType = VGMT_OTHER | VGMT_GRAPHICS ;
		viomi.color  = 2 ;
		viomi.col    = 40 ;
		viomi.row    = 25 ;
		viomi.hres   = 320 ;
		viomi.vres   = 200 ;
		break ;
      case 6:	viomi.cb     = 12 ;
		viomi.fbType = VGMT_OTHER | VGMT_GRAPHICS ;
		viomi.color  = 1 ;
		viomi.col    = 80 ;
		viomi.row    = 25 ;
		viomi.hres   = 640 ;
		viomi.vres   = 200 ;
		break ;
      case 7:	viomi.cb     = 8 ;
		viomi.fbType = 0 ;
		viomi.color  = 1 ;
		viomi.col    = 80 ;
		viomi.row    = 25 ;
		break ;
      case 10:	viomi.cb     = 12 ;
		viomi.fbType = VGMT_OTHER | VGMT_GRAPHICS ;
		viomi.color  = 2 ;
		viomi.col    = 80 ;
		viomi.row    = 25 ;
		viomi.hres   = 640 ;
		viomi.vres   = 200 ;
		break ;
      case 13:	viomi.cb     = 12 ;
		viomi.fbType = VGMT_OTHER | VGMT_GRAPHICS ;
		viomi.color  = 4 ;
		viomi.col    = 40 ;
		viomi.row    = 25 ;
		viomi.hres   = 320 ;
		viomi.vres   = 200 ;
		break ;
      case 14:	viomi.cb     = 12 ;
		viomi.fbType = VGMT_OTHER | VGMT_GRAPHICS ;
		viomi.color  = 4 ;
		viomi.col    = 80 ;
		viomi.row    = 25 ;
		viomi.hres   = 640 ;
		viomi.vres   = 200 ;
		break ;
      case 15:	viomi.cb     = 12 ;
		viomi.fbType = VGMT_OTHER | VGMT_GRAPHICS ;
		viomi.color  = 4 ;
		viomi.col    = 80 ;
		viomi.row    = 25 ;
		viomi.hres   = 640 ;
		viomi.vres   = 350 ;
		break ;
      default:	return; /* can't use BUG here */
    }
    VioSetMode( &viomi, 0 ) ;
#elif WINNT
	       /* FIXME */
#elif defined(UNIX)
	/* not implemented */
#else
    union REGS inregs, outregs ;

    inregs.h.ah = 0x00 ; /* set video modus */
    inregs.h.al = (unsigned char) modi ;
  #if __WATCOMC__ && defined(__386__)
    int386( 0x10, &inregs, &outregs ) ;
  #else
    int86( 0x10, &inregs, &outregs ) ;
  #endif
#endif
}



#ifdef DOCUMENTATION
@Summary WKBiosGetCursorPos   Get Current Cursorposition
 #include <wk/bios.h>

 void WKBiosGetCursorPos( p, y, x );
 int	p ;		Page
 int	*y, *x ;	Returns: Current position of cursor on page
@Description
 Die Funktion ermittelt die Cursorposition auf der in Page angegebenen
 Bildschirmseite.
@See Also
 WkBiosSetCursorPos
#endif

void FName(BiosGetCursorPos)( int p, int *y , int *x )
{
#if defined(OS20) && !defined(MAKE_WK16WRAP)
    if( !dllAvailable )
	LoadDll();
    GetCursorPos( p, y, x );
    return;
#elif defined(EMX) && !OS20
    return; /* no way yet found to do this */
#elif defined(OS2)
    USHORT row, col ;

    p = p ; /* not used */
    VioGetCurPos( &row, &col, 0 ) ;
    *y = row ;
    *x = col ;
#elif WINNT
    CONSOLE_SCREEN_BUFFER_INFO info;

    if( !GetConsoleScreenBufferInfo( (HANDLE)p, &info ) )
	*y = *x = 0;
    else {
	*x = info.dwCursorPosition.X;
	*y = info.dwCursorPosition.Y;
    }
#elif defined(UNIX)
    /*we should use tc... functions ansd curses or terminfo*/
    *y = 0;
    *x = 0;
#else
    union REGS inregs, outregs ;

    inregs.h.ah = 0x03 ; /* get cursor position */
    inregs.h.bh = (unsigned char)p ;
  #if __WATCOMC__ && defined(__386__)
    int386( 0x10, &inregs, &outregs ) ;
  #else
    int86( 0x10, &inregs, &outregs ) ;
  #endif
    *y = (int)outregs.h.dh ;
    *x = (int)outregs.h.dl ;
#endif
}



#ifdef DOCUMENTATION
@Summary WKBiosSetCursorPos   Set New Cursorposition
 #include <wk/bios.h>

 void WKBiosSetCursorPos( p, y, x );
 int	p ;		Page or console handle for Win32.
 int	y, x ;		New cursorposition
@Description
 Die Funktion setzt den Cursor auf die angegebene Position

@See Also
 WKBiosGetCursorPos
#endif

void FName(BiosSetCursorPos)( int p, int y , int x )
{
#if defined(OS20) && !defined(MAKE_WK16WRAP)
    if( !dllAvailable )
	LoadDll();
    SetCursorPos( p, y, x );
    return;
#elif defined(EMX) && !OS20
    return; /* no way yet found to do this */
#elif defined(OS2)
    VioSetCurPos( y, x , 0 ) ;
    p = p ; /* not used */
#elif WINNT
    COORD coord;

    coord.X = x;
    coord.Y = y;
    SetConsoleCursorPosition((HANDLE)p,coord);
#elif defined(UNIX)
    /* to be implmented */
#else
    union REGS inregs, outregs ;

    inregs.h.ah = 0x02 ; /* set cursor position */
    inregs.h.bh = (unsigned char)p ;
    inregs.h.dh = (unsigned char)y ;
    inregs.h.dl = (unsigned char)x ;
  #if __WATCOMC__ && defined(__386__)
    int386( 0x10, &inregs, &outregs ) ;
  #else
    int86( 0x10, &inregs, &outregs ) ;
  #endif
#endif
}


#ifdef DOCUMENTATION
@Summary WKBiosGetCursorForm Get Form of Cursor
 #include <wk/bios.h>

 unsigned WKBiosGetCursorForm();
@Description
 Die Funktion gibt die aktuelle Form des Cursor wieder.
@Return Value
 Form des Cursors
@See Also
 WKBiosSetCursorForm
#endif


unsigned FName(BiosGetCursorForm)()
{
#if defined(OS20) && !defined(MAKE_WK16WRAP)
    if( !dllAvailable )
	LoadDll();
    return GetCursorForm();
#elif defined(EMX) && !OS20
    return 0; /* no way yet found to do this */
#elif defined(OS2)
    VIOCURSORINFO vioci ;
    unsigned f ;

    VioGetCurType( &vioci, 0 ) ;
    f = ((vioci.yStart & 0x1f) << 8 ) | (vioci.cEnd & 0x1f) ;
    if( vioci.attr == -1 )  /* PROBLEM: compares alwas results in false */
	f |= 0x2000 ;	/* cursor is hidden */
    return f ;
#elif WINNT
    return 0;  /* FIXME */
#elif defined(UNIX)
    return 0;
#else
  #ifdef __MSC__
    ushort _far *fp ;
    FP_SEG(fp) = 0 ;
    FP_OFF(fp) = 0x0460 ;
    return *fp ;
  #elif MSDOS
    ushort _far *fp ;
    fp = MK_FP( 0, 0x0460 ) ;
    return *fp ;
  #elif DOS16RM
    static ushort _far *fp ;
    unsigned val;
    if( !fp )	/* cause there is no way to free the newly generated selector*/
	fp = ZPMProtectedPtr( MK_FP( 0x0400, 0x0060 ), sizeof(ushort) );
    val = *fp;
    return val;
  #elif DOS386 && __ZTC__
    ushort _far *fp ;
    unsigned val;
    fp = _x386_mk_protected_ptr( 0x00460 );
    val = *fp;
    _x386_free_protected_ptr( fp );
    return val;
  #elif DOS386 && __WATCOMC__  /* DOS4G maps the first meg shared */
    ushort *p ;
    unsigned val;
    p = (ushort *)0x460;
    val = *p;
    return val;
  #else
    #error unknown OS
  #endif
#endif
}


#ifdef DOCUMENTATION
@Summary WKBiosSetCursorForm  Set Form of Cursor
 #include <wk/bios.h>

 void WKBiosSetCursorForm( f );
 unsigned   f;		Neue Cursorform
@Description
 Die Funktion gibt dem Cursor eine neue Form
@See Also
 WKBiosGetCursorForm
#endif

void FName(BiosSetCursorForm)( unsigned f )
{
#if defined(OS20) && !defined(MAKE_WK16WRAP)
    if( !dllAvailable )
	LoadDll();
    SetCursorForm(f);
    return;
#elif defined(EMX) && !OS20
    return; /* no way yet found to do this */
#elif defined(OS2)
    VIOCURSORINFO vioci ;

    vioci.yStart = (f >> 8) & 0x1f ;
    vioci.cEnd	 = f & 0x1f ;
    vioci.cx	 = 0 ;
    vioci.attr	 = (f & 0x2000)? -1:0 ;
    VioSetCurType( &vioci, 0 ) ;
#elif WINNT
	       /* FIXME */
#elif defined(UNIX)
    /* ... WORK ... */
#else
    union REGS inregs, outregs ;

    inregs.h.ah = 0x01 ; /* set cursor form */
  #if __WATCOMC__ && defined(__386__)
    inregs.x.ecx = f ;
    int386( 0x10, &inregs, &outregs ) ;
  #else
    inregs.x.cx = f ;
    int86( 0x10, &inregs, &outregs ) ;
  #endif
#endif
}




#ifdef DOCUMENTATION
@Summary WKBiosPutCell	Write character and Attribute at cur Pos
 #include <wk/bios.h>

 void WKBiosPutCell( int page, int c, int a );
@Description
 Nur fr MSDOS, DOS386 and DOS16RM
 Write the character c with attribute a at the current Cursorposition
 via a BIOS Call
#endif

#if MSDOS || DOS386 || DOS16RM
void WKBiosPutCell( int page, int c, int a )
{
    union REGS inregs, outregs ;

    inregs.h.ah = 9;	/* write att/char at current cursor position */
    inregs.h.al = c;	/* this character */
    inregs.h.bh = page; /* at this page  */
    inregs.h.bl = a;	/* with this attribute */
  #if __WATCOMC__ && defined(__386__)
    inregs.x.ecx = 1;	 /* Write 1 character */
    int386( 0x10, &inregs, &outregs ) ;
  #else
    inregs.x.cx = 1;	/* Write 1 character */
    int86( 0x10, &inregs, &outregs ) ;
  #endif
}
#endif


#if defined(OS20) && !defined(MAKE_WK16WRAP)
/****************
 * Load the DLL on Demand
 * (The stuff with the list and the switch is due an CSet/2 restriction)
 */

static void LoadDll(void)
{
    static char name[] = "WK16WRAP";
    int rc;
  #ifndef __IBMC__
    int i;
    struct { void **proc; char *name; } tbl[] = {
	{  &GetVideoMode	,"WK16Wrap_BiosGetVideoMode"  },
	{  &SetVideoMode	,"WK16Wrap_BiosSetVideoMode"  },
	{  &GetCursorPos	,"WK16Wrap_BiosGetCursorPos"  },
	{  &SetCursorPos	,"WK16Wrap_BiosSetCursorPos"  },
	{  &GetCursorForm	,"WK16Wrap_BiosGetCursorForm" },
	{  &SetCursorForm	,"WK16Wrap_BiosSetCursorForm" },
	{ NULL }
    };

    for(i=0; tbl[i].proc; i++ )
	if( !(*tbl[i].proc = WKLoadModule(name,tbl[i].name,&rc)) )
	    goto failure;

  #else
    if( !(GetVideoMode	= (int	    (* _dllapi)(int *cols, int *page )	)
			  WKLoadModule(name,"WK16Wrap_BiosGetVideoMode" ,&rc)))
	goto failure;
    if( !(SetVideoMode	= (void     (* _dllapi)(int modi )		)
			  WKLoadModule(name,"WK16Wrap_BiosSetVideoMode" ,&rc)))
	goto failure;
    if( !(GetCursorPos	= (void     (* _dllapi)(int p, int *y , int *x ))
			  WKLoadModule(name,"WK16Wrap_BiosGetCursorPos" ,&rc)))
	goto failure;
    if( !(SetCursorPos	= (void     (* _dllapi)(int p, int y , int x )	)
			  WKLoadModule(name,"WK16Wrap_BiosSetCursorPos" ,&rc)))
	goto failure;
    if( !(GetCursorForm = (unsigned (* _dllapi)(void)			)
			  WKLoadModule(name,"WK16Wrap_BiosGetCursorForm",&rc)))
	goto failure;
    if( !(SetCursorForm = (void     (* _dllapi)(unsigned)		)
			  WKLoadModule(name,"WK16Wrap_BiosSetCursorForm",&rc)))
	goto failure;
  #endif
    dllAvailable = 1;
    return;
  failure:
    Error(4,"error loading module '%s': rc=%d", name, rc);
}
#endif

/*** bottom of file ***/
