/* [argexpd.c wk 19.12.90] Expand an argument list
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 * 26.01.93 wk	C Set/2 Support
 */

#include <wk/tailor.h>
RCSID("$Id: argexpd.c,v 1.9 1996/01/10 19:05:53 wernerk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <wk/lib.h>
#include <wk/file.h>
#include <wk/string.h>
#include <wk/direc.h>

/****** constants ******/
#if F_MAX_PATH > 256
    #define LINEBUFFER_SIZE 256  /* max. length of line in a reponsefile*/
#else
    #define LINEBUFFER_SIZE F_MAX_PATH
#endif

#ifdef MALLOC_CHUNK_LIMIT
    #define MAX_ALLOCSIZE MALLOC_CHUNK_LIMIT
#else
    #define MAX_ALLOCSIZE (0x1ffff- 100)
#endif
#define COREINCREMENT 1000	/* increment core in n byte steps */
				/* this is also the max. Size of one element */

/****** types ********/
typedef struct t_node {
	size_t nameOff;     /* Offset to memory Area in core */
	struct t_node *next;
    } node_t;

typedef struct {
	char *start;	    /* Start of memory for Strings */
	size_t size;	    /* allocated Size */
	size_t used;	    /* Size in use */
    } core_t;

/***** globals ********/
/***** prototypes *****/
static int ProcEntry( core_t*, char *,char *,unsigned,node_t **,node_t **);
static int Add( core_t *, node_t **, node_t **, const char *);
static char *CopyStr( core_t *, const char *);
#if __ZTC__ || __MSC__
static int Comp( const char **, const char ** );
#else
static int Comp( const void *, const void * );
#endif
static int scan_path( const char *path );

/***** functions ******/


#ifdef DOCUMENTATION
@Summary ArgExpand
 #include <wk/lib.h>

 int ArgExpand( int *org_argc, char ***org_argv, unsigned flag )

@Description
 FlagBits:
 0   : Mode (lowerBit)	  0 = No WildCard Expand
 1   : Mode (higher Bit)  1 = WildCard Expand, 2 = WildCardExpand for all
			  3 = like 2 but change cases
 2   : include response files
 3   : Sort array
 4   : Include Directory Names in Wildcard search
 5   : Include Hidden Files in Wildcard search
 7   : Return errorcode 1 when no files found

 If the Function is called with:
    WildExpand( NULL, &argv, 0 );
 where argv must be a Pointer array created by WildExpand;
 The function will free up all the memory ( Pointers an Strings )
@Return Value
@See Also
@Notes
 Technical Information: ( may be changed anytime )
 This can be done for the Pointer array contains some more elements:
 At the end is a NULL-Pointer to indicate the end of the List
 Behind the NULL-Pointer is a List of Pointers to the Memory Area
 containing the Strings.
@Example
#endif /*DOCUMENTATION*/



int ArgExpand( int *org_argc, char ***org_argv, unsigned flag )
{
    int argc;	    /* new # of arguments */
    char **argv;    /* temp. and new array of Strings */
    int n , err, found;
    node_t *listHead, *listAct, *nodePtr;
    char *fullPath;  /* used by findfile */
    char * lineBuffer;	/* for Responsefiles */
    FILE *st;		/* for Responsefiles */
    char *s;
    core_t core;	/* descriptor for memory area */


    /*** Special Feature: free up all used memory */
    if( !org_argc ) {
	argv=*org_argv;
	while(	*(argv++) )
	    ;
	free( *argv );	    /* Memory Area with Strings */
	free( *org_argv );  /* Pointer Array */
	return 0;
    }

    flag &= ~64;    /* Reset Recursing SubDirs; not implementet */
    /*** this is the function ***/
    fullPath = NULL ;
    listHead = NULL ;
    lineBuffer = NULL;
    err = 0;
    core.start = NULL; /* nothing yet allocated */
    core.size = 0;
    core.used = 0;

  #if 0
    if( flag & 64 )	     /* recurse subdirs ? */
	flag |= 1 | 2 | 16;  /* so we need this flags to be set */
  #endif


    if( flag & (3|4|64) )
	if( !(fullPath = malloc( F_MAX_PATH+1)) )
	    err = -1;
	else if( !(lineBuffer = malloc( LINEBUFFER_SIZE )) )
	    err = -1;
    /* perform a loop over all original entries in the array */
    for( n=0, argv=*org_argv; n < *org_argc && !err ; argv++, n++ )
	err = ProcEntry( &core, *argv, fullPath, flag, &listHead, &listAct );

  #if 0
    found = flag & 64 ; /* assume Directories were encountered */
    while( !err && found ) { /* now go and recurse subdiretories */
	/* Scan through List, recurse Directory and rescan List
	 * until no more Directories in List
	 */
	for( nodePtr=listHead; nodePtr ; nodePtr=nodePtr->next) {
	    s = core.start+nodePtr->nameOff;
	    for( n=0; s[n] ; n++ )
		if( isupper( s[n]&0xff ) )
		    break;
	    if( s[n] ) {
		/* Copy but leave 4 bytes for "/" "*.*" */
		mem2str( lineBuffer, s, LINEBUFFER_SIZE-4-1 );
		*s = '\0'; /* clear String, so it will be skipped*/
		break;
	    }
	}
	if( !nodePtr )
	    found = 0;
	else {	/* directory found */
	    strcat( lineBuffer, "/" "*.*" ); /* add pattern */
	    err = ProcEntry( &core, lineBuffer , fullPath,
				    flag, &listHead, &nodePtr );
	}
    } /* end recurse subdirs */
  #endif

    found = flag & 4 ; /* assume Respondfile were encountered */
    while( !err && found ) { /* now go and expand responseFiles */
	/* Scan Through List, expand File and rescan List
	 * until no more Resond Files in List
	 */
	for( nodePtr=listHead; nodePtr ; nodePtr=nodePtr->next)
	    if( *(s = core.start+nodePtr->nameOff) == '@' ) {
		mem2str( fullPath, s+1, F_MAX_PATH );
		*s = '\0'; /* clear String, so it will be skipped*/
		break;
	    }
	if( !nodePtr )
	    found = 0;
      #if __ZTC__ && __ZTC <= 0x0212 /* fsopen funktioniert da nicht richtig */
	else if( st = fopen( fullPath, "r" ) ) {
      #else
	else if( (st = fsopen( fullPath, "r" )) ) {
      #endif
	    while( fgets( lineBuffer, LINEBUFFER_SIZE-1 , st ) ) {
		char *ep;

		for( s = lineBuffer; *s && !err; ) {
		    if( isspace(*(byte*)s) )  /* eat white spaces */
			s++;
		    else {
			if( *s == '\"' || *s == '\'' ) {
			    for( ep = s+1 ; *ep ; ep++ )
				if( *ep == *s ) {
				    *(ep++) = '\0' ;    /* terminate string */
				    break;
				}
			    s++; /* remove '\"' */
			}
			else {
			    for( ep = s; *ep ; ep++ )
				if( isspace(*(byte*)ep) ) {
				    *(ep++) = '\0' ;    /* terminate string */
				    break;
				}
			}

			err = ProcEntry( &core, s, fullPath,
					 flag, &listHead, &nodePtr );
			s = ep;
		    }
		}
	    }
	    fclose(st);
	}
	else
	    err = -1 ;	/* error opening response file */
    } /* end Responsefile Expand-Loop */

    if( !err ) /* shrink memory */
	if( !(core.start = realloc( core.start, core.used )) )
	    err = -1 ;

    if( !err ) {
	/* Count arguments */
	for(argc=0, nodePtr=listHead; nodePtr ; nodePtr=nodePtr->next)
	    if( *(core.start + nodePtr->nameOff) )
		argc++;
	if( (flag & 128) &&  *org_argc > argc )
	    err = 1;
	else if( argv = malloc( (argc + 2 ) * sizeof *argv ) ) {
	    /* setup Pointers to new allocated Array */
	    *org_argc = argc ;
	    *org_argv = argv ;
	    for( nodePtr=listHead; nodePtr ; nodePtr=nodePtr->next)
		if( *(s = core.start + nodePtr->nameOff) )
		    *(argv++) = s ;
	    *argv = NULL ;
	    argv[1] = core.start ;
	    core.start = NULL ; /* don't free */
	    if( flag & 8 ) /* sort the Array */
		qsort( *org_argv, *org_argc, sizeof **org_argv, Comp );
	}
	else
	    err = -1 ;
    }

    /* cleanup local Structures */
    while( listHead ) {
	nodePtr = listHead->next ;
	free(listHead);
	listHead = nodePtr;
    }
    free( fullPath );
    free(lineBuffer);
    free( core.start );

    return err;
}



/*
 * Funktion um einen FEntry zu bearbeiten
 * Returns Err ;
 */

static int ProcEntry( core_t *core,
		      char *name,	/* name of entry */
		      char *fullPath,	/* Buffer of F_MAX_PATH size */
		      unsigned flag,	/* WildExpand() Parameter */
		      node_t **listHead,
		      node_t **listAct )
{
    int err;
    unsigned attrib; /* used by findfile */
    int handle;      /* used by findfile */
    int rspOff;

    err = 0;
    if( !*name )
	;   /* empty String: skip */
    else if( (flag&3) == 0 ? 0 :
	     *name == '-' ? 0  :
	     (flag&3) == 1 ?
		    (strpbrk( name + scan_path(name), "*?") ? 1:0) :
			 1   ) {
	rspOff = ( (flag & 4) && *name == '@' )? 1 : 0;
	mem2str( fullPath, name, F_MAX_PATH );
	attrib	= flag & 16 ? 1 : 0 ;
	if( flag & 32 )
	    attrib |= 2;
	if( !FindFile(0,fullPath+rspOff, F_MAX_PATH-rspOff, &attrib, &handle)){
	    do {
		if( (flag&3) == 3 )
		    if( attrib & 1 )  /* Directory */
			strupr( fullPath );
		    else	      /* File */
			strlwr( fullPath );
		if( err = Add( core, listHead, listAct, fullPath ) )
		    break;
	    } while( !FindFile( 1, fullPath+rspOff, F_MAX_PATH-rspOff,
				      &attrib, &handle ) );
	    if( err )
		FindFile( 2, NULL, 0, &attrib, &handle ); /*close*/
	}
    }
    else   /* take string as it is */
	err = Add( core, listHead, listAct, name );
    return err ;
}



/*
 * Function to adds an string to a singly chained list.
 * (Node willbe inserted at listAct
 * listHead is a Pointer to the Head of the List,
 *	    if it points to NULL, the Head will be allocated
 *	    and returned in listHead.
 * listAct  is Pointer to the Actual Node of the List.
 * name     is the string to be append ( a copy is generated )
 * Returns: 0 = Okay
 *	    else not enough memory
 */

static int Add( core_t *core,
		node_t **listHead, node_t **listAct, const char *name)
{
    node_t *ptr, *help;
    char *p;

    if( p = CopyStr( core, name ) ) {
	if( ptr = malloc( sizeof *ptr ) ) {
	    ptr->nameOff = p - core->start;
	    if( *listHead ) {  /* Insert Element */
		help = (*listAct)->next ;
		(*listAct)->next = ptr;
		ptr->next = help;
	    }
	    else {  /* Create first Element */
		*listHead = ptr;
		ptr->next = NULL;   /* mark last node */
	    }
	    *listAct = ptr;
	    return 0;
	}
    }

    return -1;
}



/*
 *
 */

static char *CopyStr( core_t *core, const char *string )
{
    size_t len ;
    char *p;

    p = NULL;
    len = strlen(string)+1;
    if( len < COREINCREMENT ) {
	if( core->used+len > core->size ) {
	    if( core->size < MAX_ALLOCSIZE - COREINCREMENT )
		core->start = realloc( core->start,
				       core->size += COREINCREMENT );
	    else
		FREE( core->start );
	}
	if( core->start ) {
	    p = core->start + core->used;
	    core->used += len;
	    strcpy( p, string );
	}
    }
    return p;
}


#if __ZTC__ || __MSC__	/* dunno what's wrong */
static int Comp( const char **a, const char **b )
{
    return strcmpl( *a, *b );
}
#else
static int Comp( const void *a, const void *b )
{
    return strcmpl( *(char**)a, *(char**)b );
}
#endif

/*
 * Diese Funktion ermittelt die den Offset des Dateinamnes
 * in einer Pfadangabe.
 */

static int scan_path( const char *path )
{
    int i;

    for(i=strlen(path)-1; i >= 0 ; i-- )
	if( path[i] == '/' || path[i] == '\\' || path[i] == ':' )
	    break;
    return i+1;
}



/*****	test suite for this module  *****/
#ifdef TEST

void main( int argc, char **argv )
{
    int n ;

    for( n = 0; n < argc; n++ )
	printf("%3d `%s'\n", n, argv[n] );

    if( ArgExpand( &argc, &argv, 4 | 1 ) )
	puts("error: in argexpand");

    puts("Expanded:");
    for( n = 0; n < argc; n++ )
	printf("%3d `%s'\n", n, argv[n] );
    puts( "Ready" );
    if( getenv("WK_DEBUG") )
	ArgExpand(NULL, &argv, 0 ); /* Free up memory */
    exit(0);
}

#endif /* TEST */
/**** bottom of file ****/
