/* [wscrdrv.h wk 31.10.91] Defs for Simple Screen Handler
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 * This file is part of WkLib. See wk/lib.h for details.
 * $Id: wscrdrv.h,v 1.7 1995/10/10 22:14:13 wernerk Exp $
 * History:
 * 02.01.93 wk	moved to library
 * 06.04.95 wk	added ScrDrvRegNotifyHandler()
 */

#ifndef HDR_WK_WSCRDRV
#define HDR_WK_WSCRDRV 1
#if __cplusplus
extern "C" {
#endif

int  ScrDrvOpen(void);	  /* Init Driver */
void ScrDrvRegBreakFlag( volatile int *flag );
void ScrDrvRegNotifyHandler( void (*f)(int) );

void ScrDrvCodeTrans( int mode );
void ScrDrvClose(void);   /* Deinit Driver */
void ScrDrvQrySize( int *x, int *y );

void ScrDrvSetCrs( int x, int y );
void ScrDrvHideCrs(void);
void ScrDrvShowCrs(int form);
void ScrDrvMouseOn(void);
void ScrDrvMouseOff(void);
void ScrDrvSaveScreen(void);
void ScrDrvRestScreen(void);
void ScrDrvShow(void);
void ScrDrvRepaint(void);
int  ScrDrvQryMouse( int *btn, int *px, int *py );
void ScrDrvPauseCrt( int mode );
void ScrDrvReadCell( int x, int y, int *c, int *a );
void ScrDrvWriteCell( int x, int y, int c, int a );
void ScrDrvWriteStr( int x, int y, const char *buf, size_t len, int a );
void ScrDrvWriteAttrStr( int x, int y, const char *buf,
			 size_t len, const byte *a );
void ScrDrvWriteNChar( int x, int y, int c, int a, size_t n );
void ScrDrvWriteStrFill( int x, int y, const char *buf,
			 size_t len, size_t maxlen );
void ScrDrvWriteNAttr( int x, int y, int a, size_t n );

void ScrDrvPoll(void);
unsigned ScrDrvGetToggleKeys(void);
int   ScrDrvBasicInkey( ushort *rVal, ushort *rScan, unsigned *rFlags );

#if INCL_WK_WSCRDRV_GUI
HAB ScrDrvGetActiveHAB(void);
#endif


#if __cplusplus
}
#endif
#endif /* HDR_WK_WSCRDRV */
