/* [wk/swn.c wk 12.07.93] WkSWN: Simple Window System
 *	Copyright (c) 1991-93 by Werner Koch (dd9jn)
 * $Id: swn.h,v 1.8 1997/01/07 14:46:29 wk Exp $
 */

#ifndef HDR_WK_SWN
#define HDR_WK_SWN 1
#ifndef HDR_WK_SCR
    #include <wk/scr.h>
#endif
#ifndef HDR_WK_EVENT
    #include <wk/event.h>
#endif
#if __cplusplus
extern "C" {
#endif

/****** constants *******/
#define DLG_WINDOW 1	    /* Window Parameters */
#define DLG_TEXT   2	    /* Plain Text */
#define DLG_FIELD  3	    /* Standard Input/Output field of size sx * sy */
#define DLG_BUTTON 4	    /* Standard Check Button */
#define DLG_LSTBOX 5	    /* ListBox */

#define DLG_FIELD_ALFA	0   /* Value for field.flag Bit 3..0: fieldType */
#define DLG_FIELD_FIX	1
#define DLG_FIELD_FLOAT 2

#define DLGE_NOITEM  5	/* item not found */
#define DLGE_INVTYP  6	/* invalid data type for item */
#define DLGE_NOEDIT  7	/* Edit not allowed */
#define DLGE_INVVAL  8	/* Invalid value */
#define DLGE_NOMEM   9	/* not enough memory */
#define DLGE_NODBS  10	/* no data base */
#define DLGE_KEYNF  11	/* Key not Found */
#define DLGE_SCR    12	/* Screen error */
#define DLGE_VER    13	/* Invalid Version */
#define DLGE_READ   14	/* Read Error */
#define DLGE_INV    15	/* Invalid entry */
#define DLGE_2LRG   16	/* Too Large */
#define DLGE_INVHD  17	/* Invalid Handle */
#define DLGE_NOHDS  18	/* no more Handles */
#define DLGE_TRUNC  19	/* field was truncated */

/***** prototypes *******/
    /*-- pdmenu.c --*/
int MenuOpen( const char *name );
int MenuClose( int handle );
int MenuGet( int handle, ushort *retId );
int MenuSet( int handle, ushort id );
int MenuHide( int handle );
int MenuShow( int handle );
int MenuBack( int handle );
int MenuToggle( int handle, ushort id, int mode );
int MenuMsAtTop( int handle );
    /*-- dlgwin1.c --*/
int DialogOpen( const char *name );
int DialogClose( int handle );
int DialogShow( int handle );
int DialogHide( int handle );
int DialogHasFocus( int handle );
int DialogEdit( int handle, ushort itemId );
int DialogPutStr( int handle, ushort itemId, const char *string );
int DialogPutNStr( int handle, ushort itemId, const char *string, size_t n );
int DialogGetStr( int handle, ushort itemId, char *buffer, size_t bufSize);
int DialogPutInt( int handle, ushort itemId, int value );
int DialogGetInt( int handle, ushort itemId, int *value );
int DialogPutStrAry( int hd, ushort id, char **text, int ntext,int pos);
ushort DialogMs2Id( int hd );
int    DialogCurDlg(void);
ushort DialogCurItem(int);
void   DialogSetFocus( int handle, ushort itemId );
ushort DialogItemType( int handle, ushort itemId );
int DialogEnDsItem( int handle, ushort itemId, int mode );
ushort DialogWalkItem( int handle, ushort itemId, int mode );
int DialogSeqEdit( int handle, ushort *itemId );
const char *DialogHelpKey( int handle, ushort itemId );
    /*-- dlgsig.c --*/
void DialogSigInit(void);
    /*-- dlgwin2.c --*/
int DialogPasteString( int handle, ushort itemId, const char *string );



#if __cplusplus
}
#endif
#endif /* HDR_WK_SWN */
