/* [wk/md5.h wk 26.05.94] RSA Data Security, Inc. MD5 Message-Digest Algorithm
 *	Copyright (c) 1994 by Werner Koch (dd9jn)
 * This file is part of WkLib. See wk/lib.h for details.
 ***********************************************************************
 ** Copyright (C) 1990, RSA Data Security, Inc. All rights reserved.  **
 **								      **
 ** License to copy and use this software is granted provided that    **
 ** it is identified as the "RSA Data Security, Inc. MD5 Message-     **
 ** Digest Algorithm" in all material mentioning or referencing this  **
 ** software or this function.					      **
 **								      **
 ** License is also granted to make and use derivative works	      **
 ** provided that such works are identified as "derived from the RSA  **
 ** Data Security, Inc. MD5 Message-Digest Algorithm" in all          **
 ** material mentioning or referencing the derived work.	      **
 **								      **
 ** RSA Data Security, Inc. makes no representations concerning       **
 ** either the merchantability of this software or the suitability    **
 ** of this software for any particular purpose.  It is provided "as  **
 ** is" without express or implied warranty of any kind.              **
 **								      **
 ** These notices must be retained in any copies of any part of this  **
 ** documentation and/or software.				      **
 ***********************************************************************
 *
 * $Id: md5.h,v 1.3 1995/03/08 16:51:20 wk Exp $
 */

#ifndef HDR_WK_MD5
#define HDR_WK_MD5 1
#ifndef HDR_WK_LIB
  #include <wk/lib.h>
#endif

#if __cplusplus
extern "C" {
#endif


#ifndef HAVE_MD5HANDLE_TYPE
typedef struct {
    char hidden[1];
} *t_md5handle;
#endif


t_md5handle MD5Open(int mode);
void MD5Write(t_md5handle hd, byte *inBuf, size_t inLen);
void MD5Putchar(t_md5handle hd, int c );
byte *MD5Read(t_md5handle hd);
char *MD5ToString( byte *digest );
void MD5Close(t_md5handle hd);


#if __cplusplus
}
#endif
#endif /*** end header file ***/
