/* [keys.h wk 29.5.91] Definition of KeyCodes, Protos
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 * This file is part of WkLib. See wk/lib.h for details.
 *
 * Definition of Keycodes used by all Library functions
 * To increase performance  Alternate and Control Letter-Codes
 * will only be defined on request.
 *   define INCL_ALT_KEYCODES  to include there definitions
 *   define INCL_CTRL_KEYCODES to include there definitions
 * Prototypes to retrieve the Keycodes are also inluded here.
 * $Id: keys.h,v 1.7 2000/01/04 08:34:55 wk Exp $
 * History:
 * 28.02.95 wk	added some constants (K_PRINT etc.)
 */

#ifndef HDR_WK_KEYS
#define HDR_WK_KEYS 1

#if __cplusplus
extern "C" {
#endif

/**** constants *****/
#define K_RETURN  (13)	     /* see also K_VK_RETURN */
#define K_CRETURN (10)	     /* see also K_VK_RETURN */
#define K_ESCAPE  (27)	     /* see also K_VK_ESCAPE */
#define K_RUBOUT  (8)	     /* see also K_VK_RUBOUT */
#define K_CRUBOUT (127)      /* see also K_VK_RUBOUT */
#define K_ARUBOUT (256+ 14)  /* see also K_VK_RUBOUT */
#define K_TAB	  (9)	     /* see also K_VK_TAB    */
#define K_BACKTAB (256+15)
#define K_LEFT	  (256+75)
#define K_CLEFT   (256+115)
#define K_ALEFT   (256+155)	/* only at cursor block */
#define K_RIGHT   (256+77)
#define K_CRIGHT  (256+116)
#define K_ARIGHT  (256+157)	/* only at cursor block */
#define K_UP	  (256+72)
#define K_CUP	  (256+141)	/* only at cursor block */
#define K_AUP	  (256+152)	/* only at cursor block */
#define K_DOWN	  (256+80)
#define K_CDOWN   (256+145)	/* only at cursor block */
#define K_ADOWN   (256+160)	/* only at cursor block */
#define K_PGUP	  (256+73 )
#define K_CPGUP   (256+132)
#define K_APGUP   (256+153)	/* only at cursor block */
#define K_PGDN	  (256+81 )
#define K_CPGDN   (256+118)
#define K_APGDN   (256+161)	/* only at cursor block */
#define K_HOME	  (256+71 )
#define K_CHOME   (256+119)
#define K_AHOME   (256+151)	/* only at cursor block */
#define K_END	  (256+79 )
#define K_CEND	  (256+117)
#define K_AEND	  (256+159)	/* only at cursor block */
#define K_DEL	  (256+83 )
#define K_CDEL	  (256+147)	/* only at cursor block */
#define K_ADEL	  (256+163)	/* only at cursor block */
#define K_INS	  (256+82 )
#define K_CINS	  (256+146)	/* only at cursor block */
#define K_AINS	  (256+162)	/* only at cursor block */
#define K_F1	  (256+59 )
#define K_F2	  (256+60 )
#define K_F3	  (256+61 )
#define K_F4	  (256+62 )
#define K_F5	  (256+63 )
#define K_F6	  (256+64 )
#define K_F7	  (256+65 )
#define K_F8	  (256+66 )
#define K_F9	  (256+67 )
#define K_F10	  (256+68 )
#define K_SF1	  (256+84 )
#define K_SF2	  (256+85 )
#define K_SF3	  (256+86 )
#define K_SF4	  (256+87 )
#define K_SF5	  (256+88 )
#define K_SF6	  (256+89 )
#define K_SF7	  (256+90 )
#define K_SF8	  (256+91 )
#define K_SF9	  (256+92 )
#define K_SF10	  (256+93 )
#define K_CF1	  (256+94 )
#define K_CF2	  (256+95 )
#define K_CF3	  (256+96 )
#define K_CF4	  (256+97 )
#define K_CF5	  (256+98 )
#define K_CF6	  (256+99 )
#define K_CF7	  (256+100)
#define K_CF8	  (256+101)
#define K_CF9	  (256+102)
#define K_CF10	  (256+103)
#define K_AF1	  (256+104)
#define K_AF2	  (256+105)
#define K_AF3	  (256+106)
#define K_AF4	  (256+107)
#define K_AF5	  (256+108)
#define K_AF6	  (256+109)
#define K_AF7	  (256+110)
#define K_AF8	  (256+111)
#define K_AF9	  (256+112)
#define K_AF10	  (256+113)

#define K_F11	  (256+133)
#define K_F12	  (256+134)
#define K_SF11	  (256+135)
#define K_SF12	  (256+136)
#define K_CF11	  (256+137)
#define K_CF12	  (256+138)
#define K_AF11	  (256+139)
#define K_AF12	  (256+140)


#ifdef INCL_CTRL_KEYCODES
    /* Ctrl-KeyCodes */
    #define K_CA    (  1)
    #define K_CB    (  2)
    #define K_CC    (  3)
    #define K_CD    (  4)
    #define K_CE    (  5)
    #define K_CF    (  6)
    #define K_CG    (  7)
    #define K_CH    (  8) /* do not use, use other keys  */
    #define K_CI    (  9) /* do not use, use other keys  */
    #define K_CJ    ( 10) /* do not use, use other keys  */
    #define K_CK    ( 11)
    #define K_CL    ( 12)
    #define K_CM    ( 13) /* do not use, use other keys  */
    #define K_CN    ( 14)
    #define K_CO    ( 15)
    #define K_CP    ( 16)
    #define K_CQ    ( 17)
    #define K_CR    ( 18)
    #define K_CS    ( 19) /* should better not be used (freezes output)*/
    #define K_CT    ( 20)
    #define K_CU    ( 21)
    #define K_CV    ( 22)
    #define K_CW    ( 23)
    #define K_CX    ( 24)
    #define K_CY    ( 25)
    #define K_CZ    ( 26)
#endif

#ifdef INCL_ALT_KEYCODES
    /* alternate keys */
    #define K_AA    (256+ 30)
    #define K_AB    (256+ 48)
    #define K_AC    (256+ 46)
    #define K_AD    (256+ 32)
    #define K_AE    (256+ 18)
    #define K_AF    (256+ 33)
    #define K_AG    (256+ 34)
    #define K_AH    (256+ 35)
    #define K_AI    (256+ 23)
    #define K_AJ    (256+ 36)
    #define K_AK    (256+ 37)
    #define K_AL    (256+ 38)
    #define K_AM    (256+ 50)
    #define K_AN    (256+ 49)
    #define K_AO    (256+ 24)
    #define K_AP    (256+ 25)
    #define K_AQ    (256+ 16)
    #define K_AR    (256+ 19)
    #define K_AS    (256+ 31)
    #define K_AT    (256+ 20)
    #define K_AU    (256+ 22)
    #define K_AV    (256+ 47)
    #define K_AW    (256+ 17)
    #define K_AX    (256+ 45)
    #define K_AY    (256+ 21)
    #define K_AZ    (256+ 44)
    #define K_A0    (256+129)
    #define K_A1    (256+120)
    #define K_A2    (256+121)
    #define K_A3    (256+122)
    #define K_A4    (256+123)
    #define K_A5    (256+124)
    #define K_A6    (256+125)
    #define K_A7    (256+126)
    #define K_A8    (256+127)
    #define K_A9    (256+128)
#endif


#define K_PAD_INS     (512+  0)
#define K_PAD_1       (512+  1)
#define K_PAD_2       (512+  2)
#define K_PAD_3       (512+  3)
#define K_PAD_4       (512+  4)
#define K_PAD_5       (256+ 76)     /* only at keypad */
#define K_PAD_6       (512+  6)
#define K_PAD_7       (512+  7)
#define K_PAD_8       (512+  8)
#define K_PAD_9       (512+  9)
#define K_PAD_SINS    (512+ 10)
#define K_PAD_S1      (512+ 11)
#define K_PAD_S2      (512+ 12)
#define K_PAD_S3      (512+ 13)
#define K_PAD_S4      (512+ 14)
#define K_PAD_S5      (512+ 15)
#define K_PAD_S6      (512+ 16)
#define K_PAD_S7      (512+ 17)
#define K_PAD_S8      (512+ 18)
#define K_PAD_S9      (512+ 19)
#define K_PAD_CINS    (512+ 20)
#define K_PAD_C1      (512+ 21)
#define K_PAD_C2      (512+ 22)
#define K_PAD_C3      (512+ 23)
#define K_PAD_C4      (512+ 24)
#define K_PAD_C5      (256+143)     /* only at keypad */
#define K_PAD_C6      (512+ 26)
#define K_PAD_C7      (512+ 27)
#define K_PAD_C8      (512+ 28)
#define K_PAD_C9      (512+ 29)
#define K_PAD_AINS    (512+ 30)   /* cannot be accessed */
#define K_PAD_A1      (512+ 31)   /* cannot be accessed */
#define K_PAD_A2      (512+ 32)   /* cannot be accessed */
#define K_PAD_A3      (512+ 33)   /* cannot be accessed */
#define K_PAD_A4      (512+ 34)   /* cannot be accessed */
#define K_PAD_A5      (512+ 35)   /* cannot be accessed */
#define K_PAD_A6      (512+ 36)   /* cannot be accessed */
#define K_PAD_A7      (512+ 37)   /* cannot be accessed */
#define K_PAD_A8      (512+ 38)   /* cannot be accessed */
#define K_PAD_A9      (512+ 39)   /* cannot be accessed */
#define K_PAD_DEL     (512+ 40)
#define K_PAD_PLUS    (512+ 41)
#define K_PAD_MINUS   (512+ 42)
#define K_PAD_RETURN  (512+ 43)
#define K_PAD_MUL     (512+ 44)
#define K_PAD_DIV     (512+ 45)
#define K_PAD_SDEL    (512+ 46)
#define K_PAD_SPLUS   (512+ 47)
#define K_PAD_SMINUS  (512+ 48)
#define K_PAD_SRETURN (512+ 49)
#define K_PAD_SMUL    (512+ 50)
#define K_PAD_SDIV    (512+ 51)
#define K_PAD_CDEL    (512+ 52)
#define K_PAD_CPLUS   (256+144)
#define K_PAD_CMINUS  (256+142)
#define K_PAD_CRETURN (512+ 55)
#define K_PAD_CMUL    (256+150)
#define K_PAD_CDIV    (256+149)
#define K_PAD_ADEL    (512+ 58)
#define K_PAD_APLUS   (256+ 78)
#define K_PAD_AMINUS  (256+ 74)
#define K_PAD_ARETURN (256+166)
#define K_PAD_AMUL    (256+ 55)
#define K_PAD_ADIV    (256+164)
#define K_VK_RETURN   (512+ 64) /* da die normalen Codes auch Controlcodes */
#define K_VK_ESCAPE   (512+ 65) /* darstellen, gibt es extra VK Codes hierzu */
#define K_VK_RUBOUT   (512+ 66)
#define K_VK_TAB      (512+ 67)
#define K_VK_COMPOSED (512+ 68) /* value is composed by alt and 3 digits */


#define K_PRINT       (512+101)
#define K_SCROLL      (512+102)
#define K_PAUSE       (512+103)
#define K_NUMLCK      (512+104)
#define K_CAPLCK      (512+105)
#define K_SUPER_L     (512+106)
#define K_SUPER_R     (512+107)
#define K_HYPER_R     (512+108)

#define K_BREAK        (640+0)
#define K_EXIT	       (640+1)
#define K_BTN_LEFT     (640+2)
#define K_BTN_RIGHT    (640+3)
#define K_BTN_LEFTDBL  (640+4)
#define K_BTN_RIGHTDBL (640+5)
#define K_BTN_MIDDLE	(640+6)
#define K_BTN_MIDDLEDBL (640+7)

#define K_USER_FNC0    (640+10)
#define K_USER_FNC1    (640+11)
#define K_USER_FNC2    (640+12)
#define K_USER_FNC3    (640+13)
#define K_USER_FNC4    (640+14)
#define K_USER_FNC5    (640+15)
#define K_USER_FNC6    (640+16)
#define K_USER_FNC7    (640+17)

#define K_CMD_MENUSEL	(768+0)
#define K_CMD_MENUESC	(768+1)
#define K_CMD_EDITSTART (768+2)
#define K_CMD_EDITEND	(768+3)
#define K_CMD_EDITUPD	(768+4)
#define K_CMD_DUMMY_0	(768+5)
#define K_CMD_DUMMY_1	(768+6)
#define K_CMD_DUMMY_2	(768+7)
#define K_CMD_DUMMY_3	(768+8)
#define K_CMD_DUMMY_4	(768+9)
#define K_CMD_USER_0	(768+10)
#define K_CMD_USER_1	(768+11)
#define K_CMD_USER_2	(768+12)
#define K_CMD_USER_3	(768+13)
#define K_CMD_USER_4	(768+14)



#define K_USER_BASE    2048


/* some definitions for key flags */
#define K_FLAG_CHAR	1   /* is a valid character code */
#define K_FLAG_VIRT	2   /* is a valid virtual key code */
#define K_FLAG_SCAN	4   /* is a valid hardware scan code */
#define K_FLAG_SHIFT	8   /* shift key is down */
#define K_FLAG_CTRL    16   /* control key is down */
#define K_FLAG_ALT     32   /* alt key is down */
#define K_FLAG_MOUSE   64   /* It is a mouse button */
#define K_FLAG_COMPOSE 128  /* compose key is down */

#define K_FLAG_ANY   (1|2|4)/* any key is pressed */


/***** prototypes *****/
int Inkey(void);

const char *WklibKeyCode2String( int code );
int WklibString2KeyCode( const char *string );

#if __cplusplus
}
#endif
#endif /* HDR_WK_KEYS */
