/* [wk/direc.h wk 17.2.91] Defs for Directory functions
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 * This file is part of WkLib. See wk/lib.h for details.
 * $Id: direc.h,v 1.7 1995/03/08 16:50:02 wk Exp $
 * History:
 * 12.08.92 wk	Aenderunge wg. MSC
 */

#ifndef HDR_WK_DIREC
#define HDR_WK_DIREC 1
#ifndef HDR_WK_FILE
    #include <wk/file.h>
#endif
#if defined(HPUX) || defined(GNU_C_LIB)
  #include <unistd.h>
#endif
#if !__ZTC__
#include <sys/types.h>
#endif
#include <sys/stat.h>

#if __cplusplus
extern "C" {
#endif


#if __STDC__ && _MSC_VER
/* Microsoft hat auch der struct stat eine '_' vorgesetzt */
typedef struct _stat findFileStat_t;
#else
typedef struct stat  findFileStat_t;
#endif


    /*-- direc1.c --*/
int CreateDirectory( const char* path , int mode );
    /*-- direc2.c --*/
int FindFile( int, char *, size_t, unsigned *, int *);
const char *FindFileStat( int *, findFileStat_t * );
const char *FindFileName( int *handle );
    /*-- direc3.c --*/
int ChangeDirectory( const char *dir );
    /*-- direc4.c --*/
char *GetFileName( char *buffer, size_t bufSize, const char *path );
    /*-- direc5.c --*/
char *cwdname(void);
char *basename( const char *path );
char *dirname( const char *path );

#if __cplusplus
}
#endif

#endif /* HDR_WK_DIREC */
