/* [crypt.h wk 12.11.96] DES encryption subsystem
 *	Copyright (c) 1996 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * $Id: crypt.h,v 1.4 1997/10/06 12:55:07 wk Exp $
 */

/*
 * This subsystem is based on the "DES Implementation 1.0"
 * by Stig Ostholm, Sweden. This notice appears in the original files:
 *-----------------------------------------------------------------------------
 * This software may be freely distributed an modified without any restrictions
 * from the author.
 * Additional restrictions due to national laws governing the use, import or
 * export of cryptographic software is the responsibility of the software user,
 * importer or exporter to follow.
 *
 *					     _
 *					Stig Ostholm
 *					Department of Computer Engineering
 *					Chalmers University of Technology
 *-----------------------------------------------------------------------------
 * As far as I know, the original code does not contain any part written
 * in the U.S. or by U.S. citizens. The new code code was written in
 * Germany by Werner Koch (dd9jn)
 * Due to export restrictions, the WkCrypt library is distributed
 * separately from the WkLib. This here is only the header file with some
 * definions, but WITHOUT any of the actual code. If you have the WkCrypt
 * sources, you can install them together with WkLib. The Makefile of
 * WkLib contains code to detect the presence of WkCrypt and will compile
 * it into the library.
 */

#ifndef HDR_WK_CRYPT
#define HDR_WK_CRYPT
#include <wk/lib.h>

typedef struct wkcrypt_handle_struct *WKCRYPT;
#ifndef DEFINES_wkcrypt_handle_struct
struct wkcrypt_handle_struct { char guess_what[1]; };
#endif

#define EWKCRYPT_GENERAL	1
#define EWKCRYPT_OUT_OF_CORE	2
#define EWKCRYPT_INV_VALUE	3
#define EWKCRYPT_INV_HANDLE	4
#define EWKCRYPT_OUT_OF_HANDLES 5
#define EWKCRYPT_INV_OPMODE	6
#define EWKCRYPT_OUTFNC 	7
#define EWKCRYPT_INFNC		8
#define EWKCRYPT_NO_FNC 	9
#define EWKCRYPT_KEYPARITY	10
#define EWKCRYPT_WEAKKEY	11
#define EWKCRYPT_SWEAKKEY	12
#define EWKCRYPT_CORRUPT	13
#define EWKCRYPT_PENDING	14



   /*-- from wkcrypt/crypt1.c --*/
int WkCryptOpen( WKCRYPT *handle, const char *cryptmode, int encrypt );
int WkCryptClose( WKCRYPT handle );
int WkCryptBurn( WKCRYPT handle );
int WkCryptSetKeyStr( WKCRYPT handle, const char *string );
size_t WkCryptGetBlockSize( WKCRYPT handle );
size_t WkCryptGetKey( WKCRYPT handle, int level, void *buffer, size_t bufsize );
int WkCryptSetOutFnc( WKCRYPT handle,
		      int (*outfnc)(void *cookie, void *buffer, size_t nbytes));
int WkCryptWrite( WKCRYPT handle, void *buffer, size_t nbytes, void *cookie );
int WkCryptFlush( WKCRYPT handle, void *cookie );
const char *WkCryptStrError( int rc );

#endif /* HDR_WK_CRYPT */
