/* [wk/bios.h wk 26.5.91] Bios Access
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 * This file is part of WkLib. See wk/lib.h for details.
 * $Id: bios.h,v 1.7 1995/10/29 18:27:09 wernerk Exp $
 */

#ifndef HDR_WK_BIOS
#define HDR_WK_BIOS 1
#ifndef HDR_WK_LIB
    #include <wk/lib.h>
#endif

#if __cplusplus
extern "C" {
#endif

/***** protos ******/
    /*-- bvideo.c --*/
int WKBiosGetVideoMode( int *cols, int *page );
void WKBiosSetVideoMode( int modi );
void WKBiosGetCursorPos( int p, int *y , int *x );
void WKBiosSetCursorPos( int p, int y , int x );
unsigned WKBiosGetCursorForm(void);
void WKBiosSetCursorForm(unsigned);
void WKBiosPutCell( int, int, int);

    /*-- video16.c --*/
volatile ushort *WKVideoGetBuffer( ulong *bufferSize );
void WKVideoShowBuffer( ulong bufferSize );
void WKVideoWriteCellString( ushort *c, ulong len, ulong x, ulong y);
void WKVideoWriteNCell( ushort c, ulong len, ulong x, ulong y);
short WKVideoSetBlinking( short on_off );

    /*-- kbd16.c --*/
unsigned WKKeyboardGetToggle(void);
int WKKeyboardGetChar(int mode, ushort *chr, ushort *scan, unsigned *state);


#if __cplusplus
}
#endif
#endif /* HDR_WK_BIOS */
