/* [xinterface.h wk 02.03.95] Defs for the X 11 Interface for W
 *	Copyright (c) 1995 by Werner Koch (dd9jn)
 * This file is part of the W-Editor.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: xinterface.h,v 1.1 1996/05/19 16:42:15 wernerk Exp $
 */

#ifndef HDR_XINTERFACE
#define HDR_XINTERFACE 1
#include "jnx.h"


struct xinterface_globals {
    Display *display; /* connected display */
    GC	    gc;       /* graphic context */
    XEvent  event;    /* current event */
    XFontStruct *fontStruct; /* default font */
    unsigned fontWidth, fontHeight;
    unsigned screenWidth, screenHeight;
    ulong bgPix,fgPix;	/* background and foreground pixel values */
    Window  mainWin;	/* the main window */
    XWindowAttributes mainWinAttr;
    struct {
	int pressed;
	int reported;
	struct {
	    unsigned state;
	    int x,y;
	    Time t;
	} last;
    } btn[3];
    int any_button_down;/* any button is down */
    int pointer_x;	/* last registered pointer position */
    int pointer_y;
    unsigned pointer_state;  /* and the state */
};



void JnxActivateEvent( Window xid, long mask );
void JnxIgnoreEvent( Window xid, long mask );

#endif /* HDR_XINTERFACE */
