/* [wmove.h wk 16.10.91] Prototypes for Move-Functions
 *	Copyright (c) 1991 by Werner Koch (dd9jn)
 * This file is part of the W-Editor.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Header: /vol1/src/master/apps/w/src/wmove.h,v 1.3 1995/10/26 20:58:49 wernerk Exp $
 */

#ifndef HDR_WMOVE
#define HDR_WMOVE 1
#if __cplusplus
extern "C" {
#endif



void MoveDown( int fhd, ulong count );
void MoveUp( int fhd, ulong count );
void MoveDownScrl( int fhd, ulong count );
void MoveUpScrl( int fhd, ulong count );
void MoveLeft( int fhd, ushort count );
void MoveRight( int fhd, ushort count );
void MoveLeftScrl( int fhd, ushort count );
void MoveRightScrl( int fhd, ushort count );
void Move2Line( int fhd, ulong lnr );
void Move2Column( int fhd, ushort nr );
void Move2Edge( int fhd, int mode );
void Move2Pos( int fhd, ulong lnr, ushort cnr );

void MoveCmdLeft( int fhd, ushort count )      ;
void MoveCmdLeftScrl( int fhd, ushort count )  ;
void MoveCmdRight( int fhd, ushort count )     ;
void MoveCmdRightScrl( int fhd, ushort count ) ;
void MoveCmd2Pos( int fhd, ushort new ) ;
void MoveCmd2Edge( int fhd, int where ) ;

int GetLastEofState(void);



#if __cplusplus
}
#endif
#endif /* HDR_WMOVE */
