/* [wedit1.c wk 3.10.91] W-Editor Operations 1
 *	Copyright (c) 1991 by Werner Koch (dd9jn)
 * This file is part of the W-Editor.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 * 03.01.93 wk	Removed unused vars
 */

#include "wtailor.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <wk/lib.h>
#include <wk/string.h>

#include "w.h"
#include "wcmdpr.h"
#include "wscreen.h"
#include "wfile.h"

/****** constants *********/
/******* typedefs ********/
/******* globals **********/
/******* prototypes *******/
/******* functions ********/


int Cmd_DeleteLine()
{
    int fileHd, err ;
    ulong lineNr;
    ushort pos;

    err = 0;
    fileHd = QryScreenFile();
    lineNr = GetFilePos( fileHd, &pos );
    FlushEditBuf( fileHd );
    if( GetFileTotLines( fileHd ) > 1 ) {
	/* nur falls mehr als eine Zeile vorhanden ist */
	err = DeleteLine( fileHd );
	Move2Pos( fileHd, lineNr, pos );
    }
    return err;
}


int Cmd_DeleteChar()
{
    int fHd, err;
    unsigned flags;
    ushort pos, nbytes;
    char *p, *s;

    err = 0;
    fHd = QryScreenFile();
    GetFileInfo( fHd, &flags );
    if( flags & WFILE_INCMD ) {
	p = GetPtr2CmdLine( fHd, &pos );
	nbytes = strlen(p);
	if( nbytes > pos )
	    StrNShift( p+pos, -1, MAX_LINELEN-1-pos );
	MoveCmd2Pos( fHd, pos );
    }
    else {  /* in Text */
	p = GetEditBuf( fHd, &nbytes );
	GetFilePos( fHd, &pos );
	if( nbytes > pos ) {
	    for( s = p+pos; pos < nbytes; s++, pos++ )
		*s = s[1] ;
	    if( nbytes )
		SetEditBuf( fHd, nbytes-1 );
	}
    }

    return err;
}





int Cmd_EraseEndLine()
{
    int err=0, fhd;
    unsigned flags;
    ushort pos, nbytes;
    char *p;

    fhd = QryScreenFile();
    GetFileInfo( fhd, &flags );
    if( flags & WFILE_INCMD ) {
	p = GetPtr2CmdLine( fhd, &pos );
	if( pos < MAX_LINELEN-1 )
            p[pos] = '\0';
    }
    else {
	p = GetEditBuf( fhd, &nbytes );
	GetFilePos( fhd, &pos );
	if( pos < nbytes )
	    SetEditBuf( fhd, pos );
	else {/* Fillup with blanks */
	    while( nbytes < pos )
                p[nbytes++] = ' ';
	    SetEditBuf( fhd, nbytes );
	}
    }

    return err;
}


int Cmd_EraseBeginLine()
{
    int err=0, fhd;
    unsigned flags;
    ushort pos, nbytes;
    char *p;

    fhd = QryScreenFile();
    GetFileInfo( fhd, &flags );
    if( flags & WFILE_INCMD ) {
	p = GetPtr2CmdLine( fhd, &pos );
	StrNShift( p, -(pos+1), MAX_LINELEN-1 );
    }
    else {  /* in Text */
	p = GetEditBuf( fhd, &nbytes );
	GetFilePos( fhd, &pos );
	pos++;
	memmove( p, p+pos, pos );
	if( nbytes >= pos )
	    nbytes -= pos;
	else
	    nbytes = 0;
	SetEditBuf( fhd, nbytes );
    }

    return err;
}

/*** bottom of file ***/
