/* [wbug.c wk 12.09.97] W-Editor BugDB support
 *	Copyright (c) 1997 by Werner Koch (dd9jn)
 * This file is part of the W-Editor.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "wtailor.h"
RCSID("$Id: wbug.c,v 1.2 1998/12/08 18:03:03 wk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <limits.h>
#include <wk/lib.h>
#include <wk/string.h>

#include "w.h"
#include "wcmdpr.h"
#include "wscreen.h"
#include "wfile.h"


static char *GetBugDir(void);
static int CreateBugReport(char *);
static int EditBugReport(char*,int);


/****************
 * Edit a BugDB file, the Command takes a number which is the number of
 * the bug. To locate the directory with the bugdb we use a the
 * file ".bugdb_path" which contains a single line with the path
 * to the directory.
 * To create a new bug report, use the argument "new".
 */

int
Cmd_Bug( cmd_t *cmd )
{
    char *varValue, *bugdir;
    const char *argstr;
    int err = 0;

    varValue = NULL;
    if( cmd->type == ARGTYPE_STRING )
	argstr = cmd->arg.string;
    else {
	varValue = VarValue( cmd );
	argstr = varValue;
    }
    if( !(bugdir = GetBugDir()) )
	err = ERR_BUGDB;
    else if( stricmp(argstr,"new") )
	err = CreateBugReport( bugdir );
    else
	err = EditBugReport(bugdir, atoi(argstr));

    free(bugdir);
    if( varValue )
	FreeVarValue( varValue );
    return err;
}

/****************
 * Allocate a string with the directory for BugDB files.
 * The strings will be terminated with a slash and conatin additional room
 * for the bug report filename.
 * Returns: NULL on errror
 */
static char *
GetBugDir()
{
    return NULL;
}

static int
CreateBugReport(char *bugdir)
{
    return ERR_BUGDB;
}

static int
EditBugReport(char *bugdir, int bugno)
{
    return ERR_BUGDB;
}

/*** bottom of file ***/
