.* [w3.ipf wk 24.8.92] Documentation for W - System
.*      Copyright (c) 1992 by Werner Koch (dd9jn)
.* History:
.*
.*********************************************************************

.*********************************
:h3 id='beep'.BEEP
:p.Warnton ausgeben.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
beep
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Gibt eine kurzen Ton aus.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='play mark'.PLAY MARK:elink.
:esl.


.*****************************************
:h3 id='chdir'.CHDIR  (cd)
:p.Das aktuelle Directory wechseln.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
chdir :ehp4.[:hp1.path:ehp1.]
:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Wechseln des aktuellen Directories. Falls :hp1.path:ehp1.
eine Laufwerksbezeichnung
enthlt, so wird auch das aktuelle Laufwerk gewechselt.
.br
 Wenn :hp1.path:ehp1. nicht angegeben wird, so wird das aktuelle
Directory angezeigt.

.****************************************
:h3 id='define'.DEFINE  (def,d)
:p.Macro definieren.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
def <name> = [<definition>]
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Definiert oder lscht ein Macro; wenn <definition> nicht angegeben ist,
so wird das Macro <name> gelscht. <name> kann ein frei vergebener Name
sein oder die Bezeichnung einer Taste.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='Macros'.Macro-Programmierung:elink.
:li.&sqbul. :link reftype=hd refid='keydefs'.KEYDEFS:elink.
:li.&sqbul. :link reftype=hd refid='key'.KEY:elink.
:esl.

.****************************************
:h3 id='defkey'.DEFKEY
:p.Tastaturtabelle ndern.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
defkey scan <scancode> <std>|- <shift>|- <meta>|-

defkey compose <mod> <fst> <mod> <sec> <val> [<mod> <scan>]

  mod &colon.= [shift|ctrl|alt]
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Dieses Kommando dient der Umdefintion der Tastaturtabelle und hat bei einigen
Versionen keine Wirkung.
Die erste Form (z.Z. nur bei Linux aktiv) verndert die voreingestellte
(deutsche) Tastaturtabelle entsprechend. Wird der Bindestrich angegeben,
so wird der ursprngliche Wert beibehalten. Die Werte knnen in normaler
C-Noation gegeben werden und <std>,<shift>,<meta> auch als in einfache
Anfhrungszeichen gesetztes Zeichen. meta bezeichnet die rechte ALT-Taste.

Die zweite Form ist grundstzlich aktiv und erlaubt die Definiton von
"deadkeys" die z.B. fr Akzente benutzt werden. Auch ist es mgliche
Kombinationen wie Ctrl-K-Q zu definieren - Beispiel:

  defkey compose ctrl 37 16 0 alt 62

legt auf die Kombination Control-Taste und K gedrckt, gefolgt von einem
Druck auf die Taste Q, den Zeichenwert 0 (nichts) und den scancode fr
die Taste Alt-F4. (37 ist der scancode von 'K', 16 der von 'Q' und 62 der
von 'F4'). Eine Kombination wird gelscht indem nur der Zeichenwert 0
angegeben wird.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='demo keys'.Tastencodes anzeiegen:elink.
:li.&sqbul. :link reftype=hd refid='keydefs'.KEYDEFS:elink.
:li.&sqbul. :link reftype=hd refid='key'.KEY:elink.
:esl.


.*****************************************
.*   COMMAND: "demo keys"
.*
:h3 id='demo keys'.DEMO KEYS
:p.Anzeigen von Tastendefintionen
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
demo keys
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Schalten in einen speziellen Demo-Modus, der durch Ctrl-C wieder
beendet wird. In der Meldungszeile werden interne Informationen ber
die aktuell bettigte Taste ausgegeben. Eine mit Doppelkreuz eingeleitete
Zahl kennzeichnet eine Taste, die mit einer Funktion belegt ist.


.*****************************************
:h3 id='detach'.DETACH
:p.Programm im Hintergrund ausfhren  (Nur OS2-Version).
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
detach ["]<cmdline>["]
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Dieses Kommando fhrt ein externes Programm im Hintergrund aus;
d.h. whrend dieses Programm luft kann man mit :hp2.W:ehp2. normal
weiterarbeiten. blich ist es z.B. einen Compiler oder ein
Formatierprogramm im Hintergrund laufen zu lassen.
:p.
Die Ausgaben dieses Programms werden in eine temporre Datei umgeleitet
und knnen nach Beendigung des Programms mit dem Kommando
:link reftype=hd refid='show process'.SHOW PROCESS:elink.
angezeigt werden. Es werden sowohl :hp4.stdout:ehp4., als auch
:hp4.stderr:ehp4. umgeleitet. Verlangt ein Programm nach Eingaben von
:hp4.stdin:ehp4., so wird ihm dort EOF mitgeteilt.
:note. Aufgrund von internen Buffern im externen Programm, kann
es vorkommen, da die Ausgabe von stdout und stderr nicht chronologisch
richtig erfolgt.
:p.
Wenn ein Programm gestartet wird, so zeigt :hp2.W:ehp2. in der Statuszeile
eine Meldung der Form&colon.
.br
:hp4.Process <n> detached (pid=<x>):ehp4.
.br
an. Hierbei ist :hp4.n:ehp4. eine interne ProcessId und
:hp4.x:ehp4. die ProcessId des Betriebsystems.
Nachdem das externe Programm beendet ist, zeigt :hp2.W:ehp2. in der
Statuszeile eine Meldung der Form&colon.
.br
:hp4.Job <n> complete (pid=<x>) cc=<a>-<b>:ehp4. an;
.br
an. :hp4.a:ehp4. ist hierbei der TerminationCode und
:hp4.b:ehp4. gibt den ReturnCode (Errorlevel) an.
:p.
An die :hp4.cmdline:ehp4. kann ein Macro angebunden werden, welches
direkt nach Beendigung des externen Programms ausgefhrt wird. Dieses
Macro wird durch ein Semikolon von der Kommandozeile getrennt.
Sollte das externe Programm selbt ein Semikolon bentigen, so kann diese
Macro-Option ausgeschaltet werden, indem ein Semikolon an der ersten
Stelle des Kommandos plaziert wird. Die grundstzlich optionalen
Anfhrungszeichen men bei der Benutzung der Macro-Option natrlich
angegeben werden, da das Semikolon ja auch als Kommadotrennzeichen agiert.
.br
Beispiele&colon.
:xmp.
detach "make DEBUG=1;beep;sp"

:exmp.
Hier wird das Programm "make" mit dem Argument "DEBUG=1" im Hintergrund
ausgefhrt. Nach dessen Beendigung ertnt ein Signalton (beep) und es
wird die Ausgabe des letzten DETACH-Kommandos (eben: "make DEBUG=1")
angezeigt (sp ist die Abrzung fr show process).
:xmp.
detach ";make DEBUG=1;beep;sp"

:exmp.
Obwohl sehr hnlich wie das vorige Beispiel, wird hier kein Macro
ausgefhrt, sondern der der String: "make DEBUG=1;beep;sp" im
Hintergrund ausgefhrt (Was wohl wenig Sinn macht).


:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='show process'.SHOW PROCESS:elink.
:li.&sqbul. :link reftype=hd refid='kill process'.KILL PROCESS:elink.
:li.&sqbul. :link reftype=hd refid='dos'  .DOS:elink.
:li.&sqbul. :link reftype=hd refid='varlist' .VARLIST:elink.
:esl.



.*****************************************
.*   COMMAND: "dir"
.*
.*   Syntax: dir [path][wildcards]
.*
.*     Opens internal file ".dir" and lists all files and directories
.*   in it.  Same as operating system command (this may be called
.*   "dir", "cat" or "ls").  If the internal file ".dir" already
.*   exists, it is deleted and replaced by the new listing.  "W" knows
.*   about the directory in the ".dir" file and you can optain it from
.*   the Variable "%ZDir".
:h3 id='dir'.DIR
:p.Directorylisting anzeigen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
dir :ehp4.[:hp1.path:ehp1.][:hp1.wildcards:ehp1.]
:exmp.
:p.:hp2.Beschreibung:ehp2.:p.

Zeigt ein Directorylisting im internen File :hp4..dir:ehp4. an.
Das Kommando verhlt sich wie das entsprechende OS-Kommando
("cat", "dir", "ls").
Standardmig werden zuerst die Subdirectories und dann die Files angezeigt;
eine weitere Sortierung wird nicht vorgenommen. Die Variable
:link reftype=hd refid='ROVars'.ZDir:elink. hat hier angewandt eine etwas
andere Bedeutung: Sie beinhaltet hier das Directory, dessen Listing
angezeigt wird; damit ist es leicht mglich, eine Zeile auszuwhlen
und die entsprechende Datei anzuzeigen.

:p.
Je nach verwendetem OS kann die Anzeige ein wenig unterschiedlich sein.
Falls es sich um MSDOS oder OS/2 handelt und ein Listing von einem
FAT-Filesystem erstellt wird, so werden Subdirectories in Grobuchstaben
und Datein in Kleinbuchstaben angezeigt.


:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='chdir'.CHDIR:elink.
:li.&sqbul. :link reftype=hd refid='sort'.SORT:elink.
:esl.



.*****************************************
.*   COMMAND: "dos"
.*
.*   Syntax: dos ["<operating system commands>"]
.*
.*     Calls the commandinterpreter of the operating system and passes
.*   the arguments to it. The exact function depends on the OS. There
.*   is a special option for the OS/2 version: If you use the command
.*   "ShutDown!", "W" will shutdown the machine after a verification
.*   question (With the API DosShutdown).
:h3 id='dos'.DOS
:p.OS Shell aufrufen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
dos :ehp4.[:hp1.OS-Kommandos:ehp1.]
:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Ruft den Kommandointerpreter des OS auf. Werden Kommandos mit angegeben,
so werden diese ausgefhrt und :hp2.W:ehp2. wartet dann auf Bettigung
einer Taste um seinen Bildschirm wieder aufzubauen. Werden keine Kommandos
angegeben, so wird die Shell gestartet und wartet auf Kommandos; zum
Beenden der Shell ist dann das jeweilige Kommando zu geben (z.B. "exit" bei
MSDOS oder OS/2).
:note. Die Besttigungsabfrage kann unterdrckt werden, wenn als erstes
Zeichen des Befehls ein :hp4.&atsign.:ehp4. benutzt wird.
:p.
Unter MSDOS ist :hp2.W:ehp2. in der Lage seinen Speicher fast
vollstndig freizugeben; dies kann mittels der Option
:link reftype=hd refid='set memswap'.SET MEMSWAP:elink. eingestellt
werden.
:p.
Unter OS/2 gibt es ein besonderes Feature: Wenn als Kommando
:hp4."ShutDown!":ehp4. angegeben wird, so wird nach einer Sicherheitsabfrage
das OS heruntergefahren. (Hierzu wird die API-Funktion DosShutdown() benutzt).

:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='detach'  .DETACH:elink.
:li.&sqbul. :link reftype=hd refid='set memswap'  .SET MEMSWAP:elink.
:esl.


.*****************************************
.*   COMMAND: "erase"
.*
.*   Syntax: erase <filename|varname>
.*
.*     Removes the file from the disk.
:h3 id='erase'.ERASE
:p.Lschen einer Datei.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
erase :ehp4.:hp1.file | varname:ehp1.
:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Es wird die angegebene Datei gelscht. Dies hat jedoch keine Auswirkung
auf eine Datei, die bereits in :hp2.W:ehp2. geladen ist; diese
bleibt innerhalb von :hp2.W:ehp2. unverndert.


.**********************************************************
:h3 id='help'.HELP
:p.Hilfe anzeigen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
help :ehp4.:hp1.kommando:ehp1.
:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Es wird die Hilfe zu dem angegebenen Kommando angezeigt.
das Kommando kann das kurze Kommando oder ein Teil des langen
Kommandos sein; desweiteren knnen auch andere Stichworte angezeigt
werden. Wird kein Kommando angegeben, so wird die normale Hilfedatei
angezeigt.
:p.Die Hilfesystem besteht aus 3 Dateien, die in dem Directory
gesucht werden, indem auch die ausfhrbare Datei von :hp2.W:ehp2.
sich befindet. Die Namen dieser 3 Dateien sind:
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. "w.hlp" fr die normale Hilfe,
:li.&sqbul. "w.ref" fr die vollstndige Hilfedatei.
:li.&sqbul. "w.rfi" fr eine Indexdatei
:esl.
:note.Je nach Version von :hp2.W:ehp2. knnen auch noch weitere Dateien
mit der Hilfe in einem anderen Format vorhanden sein.



.*****************************************
:h3 id='kill process'.KILL PROCESS
:p.Hintergrundprogramms abbrechen (Nur OS2-Version).
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
kill process <n>
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.

Ein externes Programms, welches mittels des Kommandos
:link reftype=hd refid='detach'.DETACH:elink. zur Ausfhrung im
Hintergrund gelangte, wird abgebrochen.
.br
:hp4.n:ehp4. ist hierbei die interne ProcessId, welche beim
Starten des externen Programms angezeigt wurde, bzw. der
:link reftype=hd refid='varlist'.Variablenliste:elink. entnommen
werden kann.
:note. Der Abbruch von Programmen die nicht von :hp2.W:ehp2. gestartet
wurden ist nicht mglich; hierzu sind die bekannten externen Programme
zu benutzen.

:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='detach'.DETACH:elink.
:li.&sqbul. :link reftype=hd refid='show process'.SHOW PROCESS:elink.
:li.&sqbul. :link reftype=hd refid='varlist'.VARLIST:elink.
:esl.


.*****************************************
.*   COMMAND: "lock"
.*
.*     Creates a semaphore file for the current file, to tell other
.*   users, that this file is in use.  If a semaphore file already
.*   exists, the file will be set to readonly and the message
.*   "(inUse)" is displayed at the infoline - if the locking was
.*   successful, the message "(locked) is displayed.  The name of the
.*   semaphore file is the name of the file with the last character of
.*   the extension set to "&"; the extension will be filled up with
.*   underscores if necessary.  See also:  "set autolock", "set
.*   lockcheck", "unlock".
:h3 id='lock'.LOCK
:p.LOCK Semaphore erzeugen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
lock
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Erzeugt ein Semaphore fr den aktuellen File, um anderen Benutzern
mitzuteilen, da dieer File zur Zeit in Bearbeitung ist.
Existiert bereits ein Semaphore fr den File, oder kann das Semaphore nicht
gesetzt werden, so wird dies dadurch
angezeigt, da der File auf ReadOnly gesetzt wird und in der Statuszeile
hinter dem Namen :hp4.(inUse):ehp4. erscheint. Falls das Semaphore
erfolgreich gesetzt werden konnte, so wird :hp4.(locked):ehp4. angezeigt.
:p.
Das Semaphore ist als File implementiert, der im selben Directory
wie der aktuelle File erzeugt wird, und als letztes Zeichen der
Extension ein :hp4."&amp.":ehp4. hat; falls die Extension nicht 3-stellig ist,
so wird eine entsprechende erzeugt, wobei die fehlenden Stellen aus
Unterstrichen gebildet werden.
:note. Sollte durch Systemabstrze ein entsprechender Semaphorefile noch
vorhanden sein, so ist dieser zu lschen um das Erzeugen des Semaphores
zu ermglichen.
:p.
Diese Verfahren zeichnet sich durch uerste Flexibilitt aus und ist deswegen
besser geeignet als z.B. den File durch das OS sperren zu lassen.
Desweiteren sind diese Semaphorefiles kompatibel zu :hp2.SAGE:ehp2.s
:hp2.PVCS:ehp2. und :hp2.SPE:ehp2..
.br
Eine Verwendung dieser Semaphore ist
bei der Programmierung im Team (Netzwerk oder Multiusersystem) sehr anzuraten,
um versehentliches doppeltes Update zu vermeiden. Der Overhead durch das
erzeugen eines Files ist minimal und hat sich im praktischen Betrieb seit
Jahren bewhrt.

:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='unlock'.UNLOCK:elink.
:li.&sqbul. :link reftype=hd refid='set autolock'.SET AUTOLOCK:elink.
:li.&sqbul. :link reftype=hd refid='set lockcheck'.SET LOCKCHECK:elink.
:esl.


.*****************************************
.*   COMMAND: "putenv" "pe"
.*
.*   Syntax: putenv 'string'
.*
.*     This command sets or changes an environment variable.  The
.*   string must have this format:  <key>=<value> if you ommit value,
.*   the environment variable will be deleted.  You can see a list of
.*   all environment varibales with the command:  "varlist" or
.*   retrieve one by surrounding it with percent-signs.  The changed
.*   environment variables will be used when you issue the "dos"
.*   command.
:h3 id='putenv'.PUTENV  (pe)
:p.Environment Variable setzen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
putenv <key>=<value>
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Diese Kommando ndert oder setzt Environment Variablen.
Diese knnen von Makros benutzt werden und werden an alle von
:hp2.W:ehp2. gestarteten Prozesse vererbt; d.h. sie sind
auch nach einem Shell-Aufruf von dieser ansprechbar.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='varlist'.VARLIST:elink.
:esl.


.*****************************************
.*   COMMAND: "redraw" "rd"
.*
.*     This command repaints the screen; useful if the OS destroyed
.*   your screen by painting obscure messages onto the screen.
:h3 id='redraw'.REDRAW  (rd)
:p.Bildschirm neu aufbauen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
redraw
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Falls durch irgendwelche Ereignisse der Bildschirm von :hp2.W:ehp2.
zerstrt wurde, so kann er durch dieses Kommando wieder hergestellt
werden. :note. :hp2.W:ehp2. arbeitet mit einem internen virtuellen
Bildschirm, der mit optimierten Methoden auf dem Bildschirm des Rechners
oder des Terminals dargestellt wird.

.*****************************************
.*   COMMAND: "rehash"
.*
:h3 id='rehash'.REHASH
:p.Interne Tabellen aktualisieren
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
rehash
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Kann jederzeit aufgerufen werden um die interne Hash-Tabellen zu
aktualisieren. Dieses Kommando hat nur Auswirkungen auf die Performance.

z.Z. sollte es immer aufgerufen werden nach einem "define" aufgerufen werden,
da durch neudefinitionen das hashing der Kommandos ausgeschaltet wird und
erst nach einem "rehash" wieder aktiv ist.




.*****************************************
.*   COMMAND: "set autolock"
.*
.*   Syntax: set autolock <on>|<off>
.*
.*     If autolock is on and you load a file into the editor or rename
.*   it, the editor will issue the command "lock" for this file.  See
.*   also:  "lock" and "set lockcheck".  The default setting is:  OFF.
:h3 id='set autolock'.SET AUTOLOCK
:p.Automatisch Semaphore generieren.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
set autolock on|off
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Wenn diese Option eingeschaltet ist, so wird nach jedem Laden eines
Files das Kommando
:link reftype=hd refid='lock'.LOCK:elink.
intern ausgefhrt.
:p.
Falls ein Team an einem Softwareprojekt arbeitet, so ist
diese Option sehr sinnvoll, damit gleichzeitiges ndern
an Sourcefiles generell verhindert wird.
:note.
Es ist aber auch mglich, mittels
:link reftype=hd refid='SysVar_ZEditPrc'.EditProzeduren:elink.
nur individuelle Files zu sperren.

:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='lock'.LOCK:elink.
:li.&sqbul. :link reftype=hd refid='unlock'.UNLOCK:elink.
:li.&sqbul. :link reftype=hd refid='set lockcheck'.SET LOCKCHECK:elink.
:esl.


.*****************************************
.*   COMMAND: "set lockcheck"
.*
.*   Syntax: set lockcheck <on>|<off>
.*
.*     If lockcheck is on and you load a file into the editor or
.*   rename it, the editor will look for the semaphore file and set
.*   the inUse flag if found.  See also:  "lock".  The default setting
.*   is:  ON.
:h3 id='set lockcheck'.SET LOCKCHECK
:p.Semaphore einschalten
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
set lockcheck on|off
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Nur wenn diese Option eingeschaltet ist, wird :hp2.W:ehp2.
prfen, ob ein Semaphore fr die zu ladene Datei gesetzt ist und in diesem
Fall das InUse-Flag setzen.

:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='lock'.LOCK:elink.
:li.&sqbul. :link reftype=hd refid='unlock'.UNLOCK:elink.
:li.&sqbul. :link reftype=hd refid='set autolock'.SET AUTOLOCK:elink.
:esl.


.*****************************************
.*   COMMAND: "set memswap"
.*
.*   Syntax: set memswap <on>|<off>
.*
.*     This option affects only the MSDOS Version of "W". If memswap
.*   is set to on and you shell out to DOS by issuing the command:
.*   "dos", "W" will first swap most of its code and data out to a
.*   disk file, and reload this areas when returning from DOS. This
.*   diskfile will be stored in a directory specified by the
.*   environment variable "TMP" or in the current working directory if
.*   this variable is not set - Do not delete this file !. "W" will
.*   swap out most of it's memory, leaving only about 10K in the
.*   memory. The default setting is: OFF.
:h3 id='set memswap'.SET MEMSWAP
:p.:hp2.W:ehp2. auf Platte auslagern.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
set memswap on|off
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Wenn diese Option eingeschaltet ist und ein externes Programm
via :link reftype=hd refid='dos'.DOS:elink. aufgerufen wird,
wird :hp2.W:ehp2. den von ihm beanspruchten Speicher auf Platte auslagern,
um so mehr Hauptspeicher fr das externe Programm zur Verfgung stellen
zu knnen. Diese Swapfile darf nicht gelscht werden, da :hp2.W:ehp2.
sich andernfalls nicht wieder in den Hauptspeicher laden kann.
Der im Hauptspeicher verbleibende Teil beansprucht lediglich 13K.

:note. Diese Option hat nur bei bestimmten MSDOS Versionen
von :hp2.W:ehp2. einen Effekt;
andere Versionen ignorieren diese Option.

:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='dos'.DOS:elink.
:esl.


.*****************************************
:h3 id='show copying'.SHOW COPYING
:p.Anzeigen des Copyright.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
show copying
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
:hp2.W:ehp2. ist freie Software. Die genauen Bedingungen werden
hier angezeigt; sie koennen aber auch der beiliegenden Datei
:hp4.COPYING:ehp4. entnommen werden.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='show warranty'.SHOW WARRANTY:elink.
:esl.


.*****************************************
:h3 id='show process'.SHOW PROCESS  (sp)
:p.Ausgaben eines Hintergrundprogramms anzeigen  (Nur OS2-Version).
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
show process [<n>]
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Die Ausgabe eines externen Programms, welches mittels des Kommandos
:link reftype=hd refid='detach'.DETACH:elink. zur Ausfhrung im
Hintergrund gelangte, anzeigen.
.br
:hp4.n:ehp4. ist hierbei die interne ProcessId, welche beim
Starten des externen Programms angezeigt wurde, bzw. der
:link reftype=hd refid='varlist'.Variablenliste:elink. entnommen
werden kann. Wird :hp4.n:ehp4. nicht angegeben, so wird die
Ausgabe des als letztes beendeten Programms angezeigt.
:note. Aufgrund von internen Buffern im externen Programm selbst, kann
es vorkommen, da die Ausgabe von stdout und stderr nicht chronologisch
richtig erfolgt.

:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='kill process'.KILL PROCESS:elink.
:li.&sqbul. :link reftype=hd refid='detach'.DETACH:elink.
:li.&sqbul. :link reftype=hd refid='varlist'.VARLIST:elink.
:esl.

.*****************************************
:h3 id='show warranty'.SHOW WARRANTY
:p.Anzeigen der Garantiebedingungen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
show warranty
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Zeigt die Garantiebedingungen als internen file .info an.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='show copying'.SHOW COPYING:elink.
:esl.


.*****************************************
.*   COMMAND: "tree"
.*
.*     Displays the directory structure. This structure is taken from
.*   a file in the root directory, named "treeinfo.ncd". You may have
.*   created this file with the Norton Commander. At this time there
.*   is no possibility to build this file with "W". May be I will
.*   write a scanner which will then support OS/2s HPFS.
:h3 id='tree'.TREE
:p.Directory-Baum anzeigen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
tree
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Zeigt die Struktur des Directories an. Dieses wird der Datei
:hp4.\treeinfo.ncd:ehp4. entnommen. Zur Zeit besteht noch keine
Mglichkeit diese Datei zu erzeugen; auf vielen Systemen ist eine
solche Datei aber vorhanden.
:p.
Aufgrund der lngeren Dateinamen unter :hp2.HPFS:ehp2. ist dieses
Verfahren dort nicht geeignet. Zu gegebener Zeit werde ich einmal
ein neues Format entwerfen, und diesem Kommando eine sinnvolle
Funktionalitt geben.

:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='dir'.DIR:elink.
:esl.


.*****************************************
.*   COMMAND: "unlock"
.*
.*     Removes the lock from the current file; this is done by
.*   deleting the corresponding semaphore file.  Notice:  You can
.*   reset the lock for a file which was created by another user - Use
.*   this command with care.  See also:  "lock".
:h3 id='unlock'.UNLOCK
:p.LOCK Semaphore lschen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
unlock
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Lscht das Semaphore des aktuellen Files; dies wird durch lschen
des zugehrigen Semaphorefiles erreicht. Hiermit ist es mglich,
sowohl eigene Semaphore ((locked) wird angezeigt), als auch durch
andere Benutzer gesetzte Semaphore ((inUse) wird angezeigt) zu lschen.
Sicherheitshalber wird der File nach erfolgreichem Unlock auf Read-Only
gesetzt.
:p.
:hp8.
Dieses Kommado ist mit Vorsicht zu benutzen, da es hiermit mglich
ist, den LOCK-Mechanismus zu umgehen. Unter bestimmten Umstnden ist
die Benutzung dieses Kommandos aber unumgnglich.
:ehp8.


:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='lock'.LOCK:elink.
:li.&sqbul. :link reftype=hd refid='set autolock'.SET AUTOLOCK:elink.
:li.&sqbul. :link reftype=hd refid='set lockcheck'.SET LOCKCHECK:elink.
:esl.


.****** end of file *********
