.* [w2.ipf wk 24.8.92] Documentation for W - Markierungen
.*      Copyright (c) 1992 by Werner Koch (dd9jn)
.* History:
.*
.*********************************************************************



.************************+****************
:h3 id='automark'.AUTOMARK
:p.Block-Markierung erweitern
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
automark
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Beginnt eine Blockmarkierung an der aktuellen Position und wartet solange
bis eine Maustaste losgelassen wird. Mit dem Bewegen der Maus verndert
sich entsprechend die Gre der Markierung.



.************************+****************
:h3 id='begin mark'.BEGIN MARK  (bm)
:p.Cursor auf den Anfang der Markierung setzen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
begin mark
:ehp4.oder:hp4.
bm
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Setzt den Cursor auf den Anfang der Markierung. Falls die Markierung in
einem anderen File ist, so schaltet :hp2.W:ehp2. auf diesen File um; wenn
keine Markierung aktiv ist, so wird eine Fehlermeldung ausgegeben.

:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='end mark'.END MARK:elink.
:esl.


.************************+****************
:h3 id='center in margins'.CENTER IN MARGINS  (ci)
:p.Die Zeilen innerhalb der Markierung zentrieren.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
center in margins
:ehp4.oder:hp4.
ci
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Alle Zeilen innerhalb der Zeilenmarkierung zentrieren. Falls keine
Zeilenmarkierung aktiv ist, so wird eine Fehlermeldung ausgegeben.
Als Grenzen werden die, mit
:link reftype=hd refid='set margins'.SET MARGINS.:elink. gesetzten
Werte benutzt.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='reflow'.REFLOW:elink.
:esl.


.************************+****************
:h3 id='clear marks'.CLEAR MARKS  (ck)
:p.Alle Markierungen lschen
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
clear marks
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Alle vorhandenen Markierungen werden gelscht; dies betrifft auch
die im Stack gesicherten Markierungen. Der Stack fr die Markierungen
wird zurckgesetzt.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='unmark'   .UNMARK:elink.
:li.&sqbul. :link reftype=hd refid='push mark'.PUSH MARK:elink.
:li.&sqbul. :link reftype=hd refid='pop mark' .POP MARK:elink.
:esl.


.************************+****************
:h3 id='copy'.COPY
:p.Markierung in die Zwischenablage kopieren.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
copy
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Kopiert den Inhalt einer Markierung in die Zwischenablage.
Die Markierung bleibt erhalten.
:p.
Einige Versionen von :hp2.W:ehp2. knnen die Zwischenablage
des Betriebssystems verwenden; dies kann mit dem Kommando
:link reftype=hd refid='set intclip'  .SET INTCLIP:elink.
eingestellt werden.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='cut'          .CUT:elink.
:li.&sqbul. :link reftype=hd refid='paste'        .PASTE:elink.
:esl.


.************************+****************
:h3 id='copy mark'.COPY MARK  (cm)
:p.Markierung kopieren.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
copy mark
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Kopiert den Inhalt einer Markierung an die aktuelle Cursorposition.
Falls es sich um eine Zeilenmarkierung handelt, so werden diese Zeilen
nach der aktuellen Zeile eingefgt. Falls es sich um eine Blockmarkierung
handelt, so wird der Block an der aktuellen Position eingeschoben, wobei
falls notwendig die Datei um eine entsprechende Anzahl Zeilen verlngert
wird.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='move mark'    .MOVE MARK:elink.
:li.&sqbul. :link reftype=hd refid='delete mark'  .DELETE MARK:elink.
:li.&sqbul. :link reftype=hd refid='overlay block'.OVERLAY BLOCK:elink.
:esl.


.************************+****************
:h3 id='cut'.CUT
:p.Markierung in die Zwischenablage schieben.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
cut
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Kopiert den Inhalt einer Markierung in die Zwischenablage und lscht
die Markierung.
:p.
Einige Versionen von :hp2.W:ehp2. knnen die Zwischenablage
des Betriebssystems verwenden; dies kann mit dem Kommando
:link reftype=hd refid='set intclip'  .SET INTCLIP:elink.
eingestellt werden.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='copy'         .COPY:elink.
:li.&sqbul. :link reftype=hd refid='paste'        .PASTE:elink.
:esl.


.************************+****************
:h3 id='delete mark'.DELETE MARK  (dm)
:p.Lschen einer Markierung
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
delete mark
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Die Markierung wird entfernt und damit auch der in der Markierung
vorhandene Text. Die durch den gelschten Text entstandene Lcke
wird, entsprechend dem Markierungstyp, durch aufschieben wieder
geschlossen.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='copy mark'    .COPY MARK:elink.
:li.&sqbul. :link reftype=hd refid='move mark'    .MOVE MARK:elink.
:li.&sqbul. :link reftype=hd refid='overlay block'.OVERLAY BLOCK:elink.
:esl.


.************************+****************
:h3 id='end mark'.END MARK  (em)
:p.Cursor auf das Ende der Markierung setzen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
end mark
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Setzt den Cursor auf das Ende der Markierung. Falls die Markierung in
einem anderen File ist, so schaltet :hp2.W:ehp2. auf diesen File um; wenn
keine Markierung aktiv ist, so wird eine Fehlermeldung ausgegeben.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='begin mark'.BEGIN MARK:elink.
:esl.


.************************+****************
:h3 id='fill mark'.FILL MARK  (fm)
:p.Die Markierung mit einem Zeichen fllen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
fill mark
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Diese Kommando gibt
eine entsprechende Meldung aus und wartet auf die Eingabe eines Zeichens vom
Benutzer. Die Markierung (normalerweise eine Blockmarkierung) wird dann
vollstndig mit diesem Zeichen aufgefllt, wobei die vorhandenen Zeichen
berschrieben werden.


.************************+****************
:h3 id='lowercase'.LOWERCASE  (lc)
:p.Umwandeln in Kleinbuchstaben.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
lowercase
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Alle Grobuchstaben innerhalb der Markierung werden in die
entsprechenden Kleinbuchstaben umgewandelt. Falls keine Markierung aktiv ist,
so wird eine Fehlermeldung ausgegeben.
:note.Es werden nur die normalen
Buchstaben konvertiert. Umlaute werden nicht gendert.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='uppercase'.UPPERCASE:elink.
:esl.


.************************+****************
:h3 id='mark block'.MARK BLOCK  (mb)
:p.Eine Blockmarkierung setzen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
mark block
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Falls noch keine Blockmarkierung gesetzt ist, so wird der Anfang einer
Blockmarkierung gesetzt; andernfalls wird das Ende gesetzt bzw.
neu gesetzt.
.br
Es kann immer nur eine Markierung im Editor
aktiv sein. Sollte bereits eine Markierung eines anderen Typs
aktiv sein oder eine Markierung in einem der nicht aktiven Files
vorhanden sein, so wird eine Fehlermeldung ausgegeben.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='mark line'.MARK LINE:elink.
:li.&sqbul. :link reftype=hd refid='unmark'.UNMARK:elink.
:li.&sqbul. :link reftype=hd refid='copy mark'.COPY MARK:elink.
:li.&sqbul. :link reftype=hd refid='overlay block'.OVERLAY BLOCK:elink.
:li.&sqbul. :link reftype=hd refid='push mark'.PUSH MARK:elink.
:esl.


.************************+****************
:h3 id='mark line'.MARK LINE  (ml)
:p.Eine Zeilenmarkierung setzen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
mark line
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Falls noch keine Zeilenmarkierung gesetzt ist, so wird der Anfang einer
Zeilenmarkierung gesetzt; andernfalls wird das Ende gesetzt bzw.
neu gesetzt.
.br
Es kann immer nur eine Markierung im Editor
aktiv sein. Sollte bereits eine Markierung eines anderen Typs
aktiv sein oder eine Markierung in einem der nicht aktiven Files
vorhanden sein, so wird eine Fehlermeldung ausgegeben.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='mark block'.MARK BLOCK:elink.
:li.&sqbul. :link reftype=hd refid='unmark'.UNMARK:elink.
:li.&sqbul. :link reftype=hd refid='copy mark'.COPY MARK:elink.
:li.&sqbul. :link reftype=hd refid='push mark'.PUSH MARK:elink.
:esl.



.************************+****************
:h3 id='move mark'.MOVE MARK  (mm)
:p.Markierten Text verschieben.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
move mark
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Den markierten Text lschen und an der aktuellen Position
neu einfgen.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='copy mark'  .COPY MARK:elink.
:li.&sqbul. :link reftype=hd refid='delete mark'.DELETE MARK:elink.
:esl.




.************************+****************
:h3 id='overlay block'.OVERLAY BLOCK  (ob)
:p.Text durch markierten text ersetzen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
overlay block
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Dies ist eine besondere Form des Kommandos COPY MARK, welches nur auf eine
Blockmarkierung angewendet werden kann.
.br
Der Text an der aktuellen Stelle wird in der Gre des
markierten Textes gelscht und durch den diesen ersetzt.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='copy mark'  .COPY MARK:elink.
:li.&sqbul. :link reftype=hd refid='move mark'  .COPY MARK:elink.
:li.&sqbul. :link reftype=hd refid='delete mark'.DELETE MARK:elink.
:esl.


.************************+****************
:h3 id='paste'.PASTE
:p.Inhalt der Zwischenablage einfgen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
paste
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Kopiert den Inhalt der Zwischenablage an die aktuelle Position.
Der Inhalt der Zwischenablage bleibt erhalten.
:p.
Einige Versionen von :hp2.W:ehp2. knnen die Zwischenablage
des Betriebssystems verwenden; dies kann mit dem Kommando
:link reftype=hd refid='set intclip'  .SET INTCLIP:elink.
eingestellt werden.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='copy'         .COPY:elink.
:li.&sqbul. :link reftype=hd refid='cut'          .CUT:elink.
:esl.


.************************+****************
:h3 id='play mark'.PLAY MARK
:p.Ein nettes Kinkerlitzchen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
play mark
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Es wird eine Melodie gespielt; welche durch eine Reihe von Zahlen, in dem
markierten Bereich, definiert ist. Es ist jeweils die Frequenz in Hertz
und die Dauer des Tons in Millisekunden anzugeben.
:p.:hp2.Beispiel:ehp2.:cgraphic.
  388 235  388 235  388 235  520 441  520 441  584 441  584 441
  776 441  656 235  520 235  520 235  656 235  520 235  436 441
  688 441  584 235  488 235  520 441   97 235   65 235  520 235
  584 235  656 441  656 441  656 441  688 235  656 132  656 441
  584 441  584 235  656 235  688 441  688 441  688 441  776 235
  688 132  656 441  776 235  776 132  776 441  656 235  520 132
  776 441  656 235  520 132  388 853  244 55   260 55   276 55
  292 441  260 646
:ecgraphic.


.************************+****************
:h3 id='pop mark'.POP MARK  (po)
:p.Eine Markierung zurckholen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
pop mark
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Eine eventuell vorhandene Markierung lschen und dann vom Markierungsstapel
die letzte gesicherte Markierung holen; bzw. falls dort keine
Markierung gespeichert ist, nur den Spapelzeiger entsprechend korrigieren.
:note. Mit Markierung sind die Position und Gre der Markierung
gemeint und nicht etwa der darin markierte Text.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='push mark'  .PUSH MARK:elink.
:li.&sqbul. :link reftype=hd refid='clear marks'.CLEAR MARKS:elink.
:esl.


.************************+****************
:h3 id='print mark'.PRINT MARK  (pm)
:p.Den markierten Text drucken.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
print mark
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Der markierte Text wird auf dem Standarddrucker ausgegeben.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='print'.PRINT:elink.
:esl.


.************************+****************
x    COMMAND: "push mark" "ps"
x
x      Saves the current mark on the mark stack.  You can save up to
x    10 marks until an errormessage is displayed.  You can also use
x    this command if there is no mark active.  Use "pop mark" to
x    restore a saved mark.
.************************+****************
:h3 id='push mark'.PUSH MARK  (ps)
:p.Eine Markierung speichern.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
push mark
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Falls eine Markierung vorhanden ist, dann diese, ansonsten ein Kennzeichen
da keine vorhanden ist, auf dem Markierungsstapel ablegen und dann die
Markierung lschen.
.br
Auf dem Stapel knnen bis zu 10 Markierungen abgelegt werden. Bei dem Versuch
mehr abzulegen, wird eine Fehlermeldung ausgegeben.
:note. Mit Markierung sind die Position und Gre der Markierung
gemeint und nicht etwa der darin markierte Text.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='pop mark'  .POP MARK:elink.
:li.&sqbul. :link reftype=hd refid='clear marks'.CLEAR MARKS:elink.
:esl.


.************************+****************
:h3 id='reflow'.REFLOW  (rf)
:p.Den markierten Text formatieren.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
reflow
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Dieses Kommando kann nur auf eine Zeilenmarkierung angewendet werden !
:p.Der Text innerhalb der Markierung wird anhand, der mit "set margins"
gesetzten Grenzen, formatiert (umgebrochen). Die verwendeten Regeln sind
so gewhlt, da ein gur lesbarer Text entsteht.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='set margins'.SET MARGINS:elink.
:esl.


.************************+****************
:h3 id='set intclip'.SET INTCLIP
:p.Zwischenablage konfigurieren.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
set intclip on|off
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
:hp2.W:ehp2. benutzt normalerweise die Zwischenablage des
Betriebsystems; durch Einschalten dieser Option wird :hp2.W:ehp2. immer
eine interne Zwischenablage benutzen. Diese Option kann beliebig ein- und
ausgeschaltet werden.
:p.
Falls das verwendete Betriebsystem eine Zwischenablage nicht
untersttzt oder auf diese nicht zugegriffen werden kann, so wird
:hp2.W:ehp2. unabhngig von diese Option die interne Zwischenablage
benutzen.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='copy'         .COPY:elink.
:li.&sqbul. :link reftype=hd refid='cut'          .CUT:elink.
:li.&sqbul. :link reftype=hd refid='paste'        .PASTE:elink.
:li.&sqbul. :link reftype=hd refid='varlist'      .VARLIST:elink.
:esl.



.************************+****************
:h3 id='shift left'.SHIFT LEFT  (sl)
:p.Den markierten Text nach links schieben.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
shift left
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Das erste Zeichen jeder Zeile innnerhalb der Markierung wird
gelscht und der Rest der Zeile entsprechend nach links geschoben
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='shift right'.SHIFT RIGHT:elink.
:esl.


.************************+****************
:h3 id='shift right'.SHIFT RIGHT  (sr)
:p.Den markierten Text nach rechts schieben.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
shift right
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Vor das erste Zeichen jeder Zeile innnerhalb der Markierung wird
ein Blank eingefgt.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='shift left'.SHIFT LEFT:elink.
:esl.


.************************+****************
:h3 id='stripblanks'.STRIPBLANKS
:p.Blanks am Zeilenedne entfernen
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
stripblanks
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Dieses Kommando entfernt alle Blanks am Zeilenende innerhalb einer
Zeilenmarkierung.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='set blankstrip'.SET BLANKSTRIP:elink.
:esl.


.************************+****************
:h3 id='unmark'.UNMARK  (um)
:p.Markierung lschen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
unmark
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Falls eine Markierung vorhanden ist, so wird diese gelscht.
Auf dem Markierungsstapel gesicherte Markierungen sind von
diesem Kommando nicht betroffen.
:note. Mit Markierung sind die Position und Gre der Markierung
gemeint und nicht etwa der darin markierte Text.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='clear marks'.CLEAR MARKS:elink.
:esl.



.************************+****************
:h3 id='uppercase'.UPPERCASE  (uc)
:p.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
uppercase
:ehp4.oder:hp4.
lc
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Alle Kleinbuchstaben innerhalb der Markierung werden in die
entsprechenden Grobuchstaben umgewandelt. Falls keine Markierung aktiv ist,
so wird eine Fehlermeldung ausgegeben.
:note.Es werden nur die normalen
Buchstaben konvertiert. Umlaute werden nicht gendert.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='lowercase'.LOWERCASE:elink.
:esl.


.************************+****************
:h3 id='sort'.SORT
:p.Sortieren einer Markierung oder des .dir Files
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
sort [optionen]
:ehp4.:exmp.
:p.:hp2.Optionen:ehp2.
:parml compact break=fit.
:pt.-r
:pd.Sortiert in absteigender Reihenfolge (reverse).
:pt.-c
:pd.Klein-/Groschreibung wird nicht unterschieden (caseinsensitive).
:pt.-n
:pd.Numerische Sortierung&colon. Um den Sortierbegriff zu erhalten wird die
C-Funktion atol() angewendet; dies kann dann benutzt werden, wenn Zahlen
linksbndig dargestellt sind.
:pt.-d
:pd.Directory Sort&colon. Die Auswahl des Sortierkriteriums richtet sich nach dem
Format des internen Files ".dir". Hier wird nach dem Namen sortiert, wobei
die anfnglich vorhandene Sortierung (erst Directories, dann Files) nicht
beibehalten wird.
:pt.-dn
:pd.Sortierbegriff ist der Name; identisch zu obiger Option
:pt.-de
:pd.Sortierbegriff ist die Extension, dann der Name.
:pt.-ds
:pd.Sortierbegriff ist die Dateigre, dann der Name.
:pt.-dd
:pd.Sortierbegriff ist das Dateidatum, dann der Name.
:pt.-R
:pd.Unterdrckt die Sortierung aber dreht die Reihenfolge der Zeilen um.
:eparml.

:p.:hp2.Beschreibung:ehp2.:p.
Sortiert die Zeilen innerhalb der Markierung. Handelt es sich um eine
Zeilenmarkierung, so wird als Sortierkriterium die gesamte Zeile benutzt.
Wird eine Blockmarkierung benutzt, so wird als Sortierkriterium der markierte
Bereich innerhalb der Zeile benutzt; es wird aber die gesamte Zeile
vertauscht. Fr den internen File ".dir"  braucht keine Markierung
angegeben zu werden, hier werden bei fehlender Markierung alle Zeilen
sortiert. :note.Interne Files die als ReadOnly gekennzeichnet sind, knnen auch
sortiert werden.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='dir'.DIR:elink.
:esl.

.****** end of file *********
