/* [tinyw.c wk 14.08.93] Call Tiny W-Editor
 *	Copyright (c) 93 by Werner Koch (dd9jn)
 * This file is part of the W-Editor.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: tinyw.c,v $
 * Revision 1.3  1996/09/10 12:20:02  wk
 * Release 1.13.0
 *
 * Revision 1.2  1995/03/24  11:59:09  wernerk
 * Moved files to UNIX machine
 *
 * Revision 1.1  1993/08/14  20:18:05  wk
 * W-Editor Version 1.10.01; First checkin into CVS
 * CVS:
 * CVS:
 * CVS:	8bit build.doc g.pro ipf.pro keys.pro keysa.pro license.doc
 * CVS:	makefile makereg.c news.doc order.doc p.pro readme.doc
 * CVS:	register.c tinyw.c tinyw.pro w.c w.def w.doc w.h w.hlp w.ico
 * CVS:	w.ipf w.pro w.sda w0.ipf w1.ipf w2.ipf w3.ipf w4.ipf w5.ipf
 * CVS:	w6.ipf w7.ipf wcmd.c wcmd.h wcmdpr.h wcmdtbl.h wdos.c wedit1.c
 * CVS:	wedit2.c wedit3.c wedit4.c wedit5.c wedit6.c wedit7.c wedit8.c
 * CVS:	werr.h wfile.c wfile.h whack.c whatsnew.doc wids.h wio.c
 * CVS:	wkbddrv.c wkbddrv.h wmark.c wmini.def wmini.hlp wmove.c
 * CVS:	wmove.h wpack.c wpack.h wpatch.c wpatch.h wpmdrv.c wproc.c
 * CVS:	ws.hlp ws.pro wscrdrv.c wscrdrvi.h wscreen.c wscreen.h wsrch.c
 * CVS:	wswk.pro wtailor.h wvar.c wz.def x.pro
 *
 */


#include "wtailor.h"
RCSID("$Id: tinyw.c,v 1.3 1996/09/10 12:20:02 wk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <wk/lib.h>

/****** constants *********/
/******** typedefs ********/
/******* globals **********/

static struct {
	int iso8859;
	int blackWhite;
    } opt ;

/******* prototypes *******/
/******* functions ********/

const char *CopyRight( int level )
{
    const char *p;
    switch( level ) {
      case 15:
      case 10:
      case 0:   p = "TinyW-Editor - V 1.00"
                    "; Copyright (C) 1993 Werner Koch (dd9jn)" ; break;
      case 14:  p =      "1.00"; break;
      case 1:
      case 11:  p = "Usage: tinyw [options] [files] (-h for help)";
		break;
      case 2:
      case 12:	p =
    "\nSyntax: tinyw [options] [file]\n\n"
    "Tiny Version of W (simply call w with a special profile)\n"
    "Options summary:\n"
    " -8       = use ISO 8859-1 character set\n"
    " -b       = force black & white mode\n"
    " --       = stop option processing\n"
    " -h       = help\n";
	break;
      case 13:  p = "TinyW"; break;
      default:  p = "?";
    }

    if( !level ) { puts( p ); fflush(stdout); }
    else if( level == 1 ) { fputs( p, stderr ); putc( '\n', stderr );exit(3);}
    else if( level == 2 ) {  /* help */ puts( p ); exit(0); }

    return p;
}




void main( int argc, char **argv )
{
    char  *s ;
    int i, rc;
    size_t n;

  #if 0
    if( ArgExpand( &argc, &argv, 4 | 1 ) )
	Error(4,GetStr(12));
  #endif
    ErrorStream(stdout);
    if( *argv )
        for( s=""; --argc && **++argv == '-' && *s != '-'; )
            for( s = *argv + 1 ; *s && *s != '-' ; s++ )
		switch( *s ) {
                  case '8' : opt.iso8859 = 1; break;
                  case 'b' : opt.blackWhite = 1; break;
                  case 'h' :
                  case '?' : CopyRight(0) ; CopyRight(2); break;
		  default  : Error(3,GetStr(15),s );
		}
    CopyRight(0) ;

    for(i=0,n=0; i < argc; i++ )
	n += strlen( argv[i] ) + 1;
    n += 100;
    s = xmalloc(n);
    strcpy(s, "w -Ptinyw.pro -q");
    if( opt.iso8859 )
        strcat(s," -8");
    if( opt.blackWhite )
        strcat(s," -b");
    for(i=0; i < argc; i++ ) {
        strcat( s, " " );
	strcat( s, argv[i] );
    }

    rc = system( s );
    free( s );

    exit( rc ) ;
} /* end main() */

/*** bottom of file ***/
