/* [jnx.h wk 05.04.95] Defs for the X 11 Interface for W
 *	Copyright (c) 1995 by Werner Koch (dd9jn)
 * This file is part of the W-Editor.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: jnx.h,v 1.2 1996/08/12 16:50:21 wk Exp $
 */

#ifndef HDR_JNX
#define HDR_JNX 1

void JnxParseArgs( int *c_argc, char ***c_argv );
void JnxInitApp( int x, int y, unsigned width, unsigned height );
int  JnxAvailable(void);
void JnxRegisterExposureHandler( void (*f)(void) );
void JnxRegisterNotifyHandler( void (*f)(int) );
void JnxQueryScreenSize( unsigned *x, unsigned *y );
int JnxWaitEvent(void);
int JnxReadKeyCode( unsigned *keycode, unsigned *state );
unsigned JnxReadMouse( int *x, int *y );
void JnxSetTitle( int mode, const char *s );
void JnxSetColor(unsigned);
void JnxSetDefaultColor(void);
void JnxWriteChar(int x, int y, int c);
void JnxClearScreen(void);
void JnxSetCaret(int x, int y, int caretType);

void JnxStoreBytes( char *text, size_t size );
void *JnxFetchBytes( size_t *r_nbytes );
void JnxFreeFetchedBytes( void *p );

#endif /* HDR_JNX */
