/* [strg4b.c wk 25.08.93] MemStr()
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 */

#include <wk/tailor.h>
RCSID("$Id: strg4b.c,v 1.4 1995/03/08 16:58:00 wk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <wk/string.h>


#ifdef DOCUMENTATION
@Summary MemStr 	 Find substring in buffer
 #include <wk/string.h>

 char *MemStr( buf, sub, n );
 const char   *string ;       buffer to search
 const char   *sub ;	      Substring to search for
 size_t n;		      len of buffer
@Description
 Same as strstr() but search in a buffer of length n.
@Return Value
 A pointer to the first occurrence of sub in buffer
 or NULL if sub not found.
#endif

char *MemStr( const char *text, const char *sub, size_t nbytes )
{
    const char	*t, *s ;
    size_t n;

    for( t=text,n=nbytes,s=sub ; n ; t++,n-- )
	if( *t == *s ) {
	    for( text=t++,nbytes=n--, s++; n && *t == *s; t++, s++,n-- )
		;
	    if( !*s )
		return (char*)text;
	    t = text ; n = nbytes; s = sub ;
	}

    return NULL ;
}


/***** bottom of file ******/
