/* [strg11.c wk 01.05.95] String to Array
 *	Copyright (c) 1988-95 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 */

#include <wk/tailor.h>
RCSID("$Id: strg11.c,v 1.2 1995/10/10 22:13:28 wernerk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <wk/string.h>

/****************
 * Create an Array of pointers to strings, from a string,
 * the string will be modified, by inserting 0 tokens
 * No options are currently defined (strings are seperated by
 * white spaces)
 * The end of the array is marked wit a NULL pointer, caller must
 * free the array
 *
 * Returns: Array with ptrs to the string or NULL on memory error
 *
 */

char **
StringToArray( char *string, int options )
{
    char **array;
    char *p;
    size_t n;

    xassert( !options );
    /* count # of strings */
    for( n = 1, p = string; *p ; ) {
	while( isspace( *p ) ) /* skip leading spaces */
	    p++;
	if( *p ) {
	    n++;
	    while( *p && !isspace( *p ) ) /* skip the string */
		p++;
	}
    }
    /* allocate the array */
    if( !(array = malloc( n * sizeof *array )) )
	return NULL;
    /* setup pointers */
    for( n = 0, p = string; *p ; ) {
	while( isspace( *p ) ) /* skip leading spaces */
	    p++;
	if( *p ) {
	    array[n++] = p;
	    while( *p && !isspace( *p ) ) /* skip the string */
		p++;
	    if( *p )
		*p++ = 0;
	}
    }
    array[n] = NULL;
    return array;
}

/*** bottom of file ***/
