/* [loadmod.c wk 26.11.93] Load an dynamic module
 *	Copyright (c) 1993 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 * History:
 * 13.07.94 wk	added cleanup()
 */

#include <wk/tailor.h>
RCSID("$Id: loadmod.c,v 1.7 1996/01/10 19:06:02 wernerk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <wk/string.h>
#include <wk/environ.h>
#ifdef OS2
    #define INCL_DOSMODULEMGR	  /* Module Manager values */
    #include <os2.h>
#endif

#ifdef __WTC__
  static char patch_to_make_the_obj_larger[]="this damned network....";
#endif

typedef struct module_s {
    struct module_s *next;
  #if OS2
    HMODULE  modHandle;
  #endif
    char name[1];   /* malloced name of module */
} module_t;

#if OS20
static module_t *moduleTable;
static int debug, initialized;
static void Cleanup( void *dummy );
static void _dllapi DummyFunction(void);
#endif


/****************
 * Unload all Modules
 */
#if OS20
static void
Cleanup( void *dummy )
{
  #if OS20
    APIRET   rc;
    module_t  *mod, *next;
    initialized = 2;
    for( mod=moduleTable; mod; mod = next ) {
	next = mod->next;
	if( debug )
	    Info("freeing module: '%s'", mod->name);
	if( rc = DosFreeModule( mod->modHandle ) )
	    Error(0,"error freeing module '%s': rc=%d", mod->name, rc);
	free( mod );
    }
  #endif
}
#endif


/****************
 * Ein Module laden.
 * Wenn das Module nicht geladen ist, so wird es geladen, ansonsten
 * wird nur die entsprechende Addrese der angegebenen Funktion zurueck-
 * gegeben. Wird fuer fncName NULL angegeben, so wird nur das Modul geladen
 * Returns: Addresse der Funktion bzw. die Adresse einer Dummy-Funktion
 *	    wenn nur das Modul geladen wird.
 *	oder
 *	    NULL bei einem Fehler; in diesem Fall kann dann der erroCode noch
 *	    geprueft werden (dieser kann aber auch als NULL angegeben sein)
 *
 * Besonderheit: Wird der Functionname: "#SYS-MODULE-HANDLE#" benutzt, so wird
 * statt der Funktion der interne Handle des Moduls zurckgegeben.
 *
 * Hier wird eine Interen Tabelle aller Module gehalten um ein doppeltes laden
 * zu vermeiden.
 */

void *
WKLoadModule(const char *modName, const char *fncName, int *errCode )
{
  #if OS20  /* there are somewhat different functions for os/2 1.3 */
    CHAR     buf[100];
    HMODULE  modHandle;
    APIRET   rc;
    PFN proc;
    module_t  *mod;

    if( !initialized ) {
	initialized = 1;
	AddCleanUp( Cleanup, NULL );
	debug = !!getenv("TRACEDLLLOAD");
    }
    else if( initialized == 2 )
	Bug("loading module during cleanup");

    /* find the module */
    for( mod=moduleTable; mod; mod = mod->next )
	if( !stricmp( mod->name, modName ) )
	    break;
    if( !mod ) { /* not found: load */
	if( rc = DosLoadModule((PSZ)buf, DIM(buf), (CHAR*)modName, &modHandle)){
	    if( debug )
		Info("error loading module '%s': rc=%d", modName, rc);
	    goto failure;
	}
	if( debug )
	    Info("loading module: '%s'", modName);
	mod = xcalloc( 1, sizeof *mod + strlen( modName ) );
	strcpy( mod->name, modName );
	mod->modHandle = modHandle;
	mod->next = moduleTable;
	moduleTable = mod;
    }

    if( !fncName )
	return (void *)DummyFunction;
    else if( !strcmp( fncName, "#SYS-MODULE-HANDLE#" ) )
	return (void *)(ulong)mod->modHandle;

    mem2str(buf, fncName, DIM(buf) );

    if( rc = DosQueryProcAddr(mod->modHandle, 0, buf, &proc) ) {
	if( debug )
	    Info("error loading module '%s' fnc '%s': rc=%d",
						mod->name, buf, rc);
	goto failure;
    }
    if( debug )
	Info("loading module '%s' fnc '%s' addr=%p", mod->name, buf, proc );

    return (void *)proc;

  #else
    int rc;
    rc = -1;
    goto failure;
  #endif

  failure:
    if( errCode )
	*errCode = rc;
    return NULL;
}


#if OS20
static void _dllapi DummyFunction()
{
    BUG();
}
#endif

/*** bottom of file ***/
