/* [ioerror.c wk 24.04.94] Critical I/O error handling
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 */


#include <wk/tailor.h>
RCSID("$Id: ioerror.c,v 1.8 1996/07/16 10:34:28 wernerk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <wk/io.h>

static int grabMode;

#if __ZTC__ && (MSDOS || DOS386 || DOS16RM)
#if DOS386 /* da ist was falsch definiert ! */
  #define _cerror_handler cerror_handler
#endif
#include <dos.h>
#include <cerror.h>
#include <bios.h>

static int installed;
static void Cleanup( void *dummy );
static int _far CritErrHandler( int *regAX, int *regDI );


/****************
 * Catch IO Errors
 *  mode 0 ::= do only return old mode
 *	 1 ::= Always fail the system call
 *	(others are not defined)
 *
 * Returns: Old mode
 */

int GrabIOErrors(int mode)
{
    int old;
    if( !installed ) {
	AddCleanUp( Cleanup, NULL );
	installed++;
    }
    old =grabMode;
    if( mode && mode != grabMode ) {
	UngrabIOErrors();
	if( _osmajor >= 3 || _exe_type == EXE_OS2 ) {
	    /* does not work prior to DOS version 3.0 */
	    _cerror_handler = CritErrHandler;
	    cerror_open();
	    grabMode = 1;
	}
    }
    return old;
}


int UngrabIOErrors(void)
{
    int old = grabMode;
    if( grabMode ) {
	cerror_close();
	grabMode = 0;
    }
    return old;
}

static void Cleanup( void *dummy )
{
    UngrabIOErrors();
}



/*******************
 * Monitor to intercept the Critical Error Interrupt
 */

static int _far CritErrHandler( int *regAX, int *regDI )
{
    *regAX = 3;  /* 3 = fail, 1 = retry */
    return 0;	/* fail */
}

#elif (__MSC__ || __WATCOMC__) && MSDOS && !MSDOS_WINDOWS

#include <dos.h>

/*******************
 * Monitor to intercept the Critical Error Interrupt
 */

static void _far CritErrHandler( unsigned deverr,
			    unsigned errcod,
			    unsigned _far *devhdr )
{
    _hardresume(_HARDERR_FAIL);
}



int GrabIOErrors(int mode)
{
  #if __MSC__
    void (_far *fptr)();
    long x;
  #endif
    int old =grabMode;
    if( mode && mode != grabMode ) {
	UngrabIOErrors();
	if( _osmajor >= 3 ) { /* does not work prior to DOS version 3.0 */
	  #if __MSC__
	    x  = (long)CritErrHandler;
	    fptr = x;
	    _harderr(fptr);
	  #else
	    _harderr(CritErrHandler);
	  #endif
	    grabMode = 1;
	}
    }
    return old;
}


int UngrabIOErrors(void)  /* dummy, doesn't work */
{
    int old = grabMode;
    /* can't do it here */
    return old;
}


#elif OS2

#define INCL_DOSMISC 1
#include <os2.h>

int GrabIOErrors(int mode)
{
    int old = grabMode;
    if( mode == 1 && mode != grabMode ) {
	DosError(0); /* disable harderrors */
	grabMode = 1;
    }
    return old;
}


int UngrabIOErrors(void)
{
    int old = grabMode;
    if( grabMode ) {
	DosError(1); /* enable harderrors */
	grabMode = 0;
    }
    return old;
}


#else	/* generic */

int GrabIOErrors(int mode)
{
    if( mode )
	grabMode = 1;
    return grabMode;
}


int UngrabIOErrors(void)
{
    int old = grabMode;
    if( grabMode )
	grabMode = 0;
    return old;
}

#endif


/******* bottom of file *******/
