/* [fixes1.c wk 11.05.95] Some fixes to lib functions
 *	Copyright (c) 1988-95 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <wk/tailor.h>
RCSID("$Id: fixes1.c,v 1.2 1995/05/11 20:52:01 wernerk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <wk/lib.h>

/* some systems do destroy the va_list pointer
 * with each call to a v*printf() function
 * so we restore this pointer after the call
 */
#if __WATCOMC__

#undef vprintf
#undef vfprintf
#undef vsprintf

int
wklib_vprintf(const char *format, va_list arg_ptr)
{
    va_list save;
    int rc;
    int dummy = 0; /* lanman probs with obj file size */

    save[0] = arg_ptr[0]; /* save */
    rc = vprintf( format, arg_ptr );
    arg_ptr[0] = save[0]; /* restore */
    return rc;
}

int
wklib_vfprintf(FILE *stream, const char *format, va_list arg_ptr)
{
    va_list save;
    int rc;

    save[0] = arg_ptr[0]; /* save */
    rc = vfprintf( stream, format, arg_ptr );
    arg_ptr[0] = save[0]; /* restore */
    return rc;
}

int
wklib_vsprintf(char *buf, const char *format, va_list arg_ptr)
{
    va_list save;
    int rc;

    save[0] = arg_ptr[0]; /* save */
    rc = vsprintf( buf, format, arg_ptr );
    arg_ptr[0] = save[0]; /* restore */
    return rc;
}

#endif


/*** bottom of file ***/
