/* [file7.c wk 20.11.90] extended fread()
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 * 22.05.92 wk	Neue Tabexpand Option: enfaches ersetne tab durch 8 blanks
 */

#include <wk/tailor.h>
RCSID("$Id: file7.c,v 1.6 1995/03/08 16:55:39 wk Exp $")
#include <stdio.h>
#include <string.h>
#include <wk/file.h>

#ifdef DOCUMENTATION
@Summary FExtRead	read from a file with options
 #include <wk/file.h>

 size_t FExtRead( buf, bufSize, stream, flags, length, pos )
 char *buf;		Buffer
 size_t bufSize;	Bufferlnge
 FILE *stream;		Stream
 unsigned flags;	Flags (may be ored together)
                        F_NFILE_LF  = Read up to '\n'
                        F_NFILE_FF  = Read op to '\f'
                        F_NFILE_NUL = Read up to '\0'
			F_NFILE_TAB = Expand tabs
				      (pos must be initialized to 0)
			default: length lesen, tabs nicht expandieren
 size_t length; 	Satzlnge (nur wenn kein End-Of-Line Character )
 size_t *pos;		Position innerhalb der Zeile
			(kann NULL sein wenn !F_NFILE_TAB)
@Description
 Erweiteret Lesefunktion auf einem Stream; Optionen:
 - Lesen von Files bis zu einem oder mehreren Satzende Zeichen
 - Lesen von Files mit einer festen Satzlnge
 - Expandieren von Tabulatoren
 Es wird in einen Buffer gelesen, ist dieser Buffer nicht gro
 genug, so wird nicht ber ihn hinausgeschrieben; auf diesen Fall kann
 getestet werden:
    Die Returnlnge ist dann gleich der Bufferlnge
    und der Parmeter pos zeigt nicht auf den Wert 0.
 Tabulatoren werden expandiert, dadurch kann auch bei einer festen Satzlnge
 der Buffer mehr Zeichen enthalten als eingelesen wurden.
 Die Funktion liefert alle Zeichen zurck ist also
 voll transparent (Ausnahme, bei Tabulatoroption, wird dieses Zeichen
 ersetzt durch einige Spaces)
@Return Value
 Bei einem Fehler oder EOF wird 0 zurckgegeben, ansonsten
 die Anzahl der gltigen Zeichen im Buffer (diese kann nie 0 sein,
 da die Satzlnge > 0 sein muss bzw. das End-Of-Line Zeichen mit
 in den Buffer kopiert wird).
 mit feof oder ferror kann dann festgestellt werden, ob es sich
 um einen Fehler oder EOF handelt.
#endif	/* end docu */


size_t FExtRead( char *p,	  /* buffer */
	       size_t bufSize,
	       FILE *stream,
	       unsigned flags,
	       size_t length,
	       size_t *pos   )
{
    int n, r , j , c , eol , tabMode;
    int eol_lf, eol_ff, eol_nul , tab_exp, skip_cr;
    size_t dummyPos;

    length = 0 ;    /* not yet implemented */
    if( !pos ) {
	pos = &dummyPos ;
	tabMode = 1;
    }
    else
	tabMode = 0;
    eol_lf  = flags & F_NFILE_LF ;
    eol_ff  = flags & F_NFILE_FF ;
    eol_nul = flags & F_NFILE_NUL;
    skip_cr = flags & F_NFILE_SKIP_CR;
    if( !(eol_lf || eol_ff || eol_nul) )
	BUG() ;   /* z.Z. noch nicht vollstndig impl. */
    tab_exp = flags & F_NFILE_TAB;

    eol = 0;
    c = 0;  /* avoid compiler warning about uninitialized use */
    n = 0 ;
    if( feof(stream) || ferror(stream) ) {
	eol++ ;
	c = EOF ;
    }
    while( n < bufSize && !eol ) {
	c = getc(stream);
	if( c == EOF )
	    eol++;
        else if( c == '\r' && skip_cr )
	    ; /* skip */
        else if( c == '\n' && eol_lf )
	    eol++ ;
        else if( c == '\f' && eol_ff )
	    eol++ ;
        else if( c == '\0' && eol_nul )
	    eol++ ;
        else if( c == '\t' && tab_exp ) {
	    if( tabMode ) { /* simple method: just replace a tab by 8 spaces */
                *(p++) = ' ';
		++*pos ;
		n++;
		for( j = 1 ; n < bufSize && j < 8 ; j++, ++*pos, n++ )
                    *(p++) = ' ' ;
	    }
	    else {
		r = 8 - ( (*pos<8)? *pos:(*pos-8) % 8 ) ;
                *(p++) = ' ';
		++*pos ;
		n++;
		for( j = 1 ; n < bufSize && j < r ; j++, ++*pos, n++ )
                    *(p++) = ' ' ;
	    }
	}
	else {
	    *(p++) = (char)c;
	    n++ ;
	    ++*pos;
	}
    }

    if( eol ) {
	if( c != EOF ) {
	    *(p++) = (char)c;
	    n++ ; /* wenn durch eol beendet, war n < bufSize */
	}
	*pos = 0 ;
    }

    return n;
}

/**** bottom of file ****/
