/* [file12.c wk  2.7.92] Filesystem
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 * 27.01.93 wk	C Set/2 Support
 */


#include <wk/tailor.h>
RCSID("$Id: file12.c,v 1.4 1995/03/08 16:55:14 wk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <wk/io.h>
#include <wk/file.h>
#include <wk/string.h>
#ifdef OS2
    #define INCL_NOCOMMON    1
    #define INCL_DOSFILEMGR  1
    #include <os2.h>
#endif


#ifdef DOCUMENTATION
@Summary FileQryFSLabel
 #include <wk/file.h>

 int FileQryFSLabel( const char *fname, char *buf, ushort buflen
		     ulong *serial );
@Description
 This function will return the VolumeLabel of the filesystem
 where the given file is stored. At least a drive letter is
 required for this function. If used on a Filesystem with a letter
 as a drive indicator you must specify the ':' to distingish the filename
 from a relative one.
@Return Value
 Returns: 0 = Okay
	 False = Error getting Filesystem label
#endif /*DOCUMENTATION*/


int FileQryFSLabel( const char *fname, char *retBuf, ushort retBufSize,
		    ulong *retSerial )
{
  #if MSDOS || DOS16RM || DOS386
    return -1;
  #elif OS2
    ushort drive;
    #if OS20
      char info[40];
    #else
      FSINFO fsinfo;
    #endif

    drive = 0;
    if( strlen(fname) > 1 )
        if( fname[1] == ':' )
            drive = toupper(*fname)-'A'+1;

  #if OS20
    if( !DosQueryFSInfo( drive, 2, info, DIM(info) ) ) {
	if( retSerial )
	    memcpy( retSerial, info, sizeof(long) );
	if( retBuf )
	    mem2str( retBuf, info+sizeof(long)+1, retBufSize );
	return 0;
    }
  #else
    if( !DosQFSInfo( drive, 2, (PBYTE)&fsinfo, sizeof fsinfo) ) {
	if( retSerial )
	    *retSerial = fsinfo.ulVSN;
	if( retBuf )
	    mem2str( retBuf, fsinfo.vol.szVolLabel, retBufSize );
	return 0;
    }
  #endif
    else
	return -1;
  #else
    return -1;
  #endif
}

/******* bottom of file *******/
