/* [dskspace.c wk 22.07.94] Get Disk space
 *	Copyright (c) 199$ by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 */


#include <wk/tailor.h>
RCSID("$Id: dskspace.c,v 1.5 1996/12/03 18:16:58 wk Exp $")
#include <stdio.h>
#include <wk/environ.h>
#if OS2
  #define INCL_DOSMEMMGR 1
  #include <os2.h>
#elif MSDOS || DOS386
  #include <dos.h>
#endif

#ifdef DOCUMENTATION
@Summary QryAvailableDiskSpace
 #include <wk/environ.h>

 ulong QryAvailableDiskSpace(void);
@Description
 Returns the free diskspace (of the current drive) in KB.
@Return Value
 Free diskspace in KB.
#endif /*DOCUMENTATION*/


ulong QryAvailableDiskSpace(void)
{
  #if __ZTC__
    unsigned drive;
    dos_getdrive( &drive );
    return dos_getdiskfreespace(drive)/1024L;
  #elif OS2
    union {
	ulong  l;
	ushort s;
    } buf[5];
   #if OS20
    if( DosQueryFSInfo(0, FSIL_ALLOC, buf, sizeof buf)	)
   #else
    if( DosQFSInfo(0, FSIL_ALLOC, (void*)buf, sizeof buf)  )
   #endif
	return 0; /* error */

    return (buf[1].l * buf[3].l * buf[4].s) / 1024;
  #elif NETWARE
    return 0; /* unknown (FIXME:)*/
  #elif WINNT
    return 0; /* unknown (FIXME:)*/
  #elif __WATCOMC__
    unsigned drive;
    struct diskfree_t disk_data;

    _dos_getdrive( &drive );
    if( _dos_getdiskfree( drive, &disk_data ) )
	return 0; /* error */
    return (disk_data.avail_clusters *
	    disk_data.sectors_per_cluster *
	    disk_data.bytes_per_sector)/1024L;
  #else
    return 0; /* unknown */
  #endif
}

/*** bottom of file ***/
