/* [cright.c wk 26.5.91] Generic CopyRight()
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 * 26.04.93 wk	Support for DLL, now Version 2.00
 * 27.07.94 wk	renamed to WklibCopyRight() adn added module cright2.c
 */

#include <wk/tailor.h>
RCSID("$Id: cright.c,v 1.25 1998/02/19 08:37:28 wk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <wk/lib.h>
#include <wk/environ.h>

static const volatile char wklib_version_str[] = "$WkLib: " WKLIB_VERSION " $";

#ifdef DOCUMENTATION
@Summary CopyRight
 #include <wk/lib.h>

 const char *CopyRight( int level );
 const char *WklibCopyRight( int level );
 level 0: Copyright String auf stdout ausgeben
       1: Kurzusage auf stderr ausgeben und beenden
       2: Langusage auf stdout ausgeben und beenden
      10: Copyrightstring zurckgeben
      11: Kurzusage zurckgeben
      12: Langusage zurckgeben
      13: Programmnamen zurckgeben
      14: Versionsnummer zurckgeben
      15: Titel fuer mainwindow
      16: Name unter dem im Profile gespeichert werden soll
      17: Kann der Name eines Resource files sein.
      18: Parenthesis string
      19: One line Copyright String
      20: FullPathname of active Program
      21: LoadDirectory zurckgeben
      22: Betriebssystem ID (alt)
      23: CompileTime
      24: Linkdate
      25: Name of Author
      26: Bug report info
      30: Additinal notes on the program
      31: Short copy info
      32: Printable OS-version string (alt)
      33: Special Link infos (delimited by spaces)
	  "mt" = multithreaded
      42: 43-44-45
      43: WK_CPU
      44: WK_COMPANY
      45: WK_SYSTEM
      71: DLL-Interface Version
@Description
 Overload Module zu Testzwecken; das eigentliche Modul sollte immer im
 HauptProgramm enthalten sein. Um zum Modultest diese Funktion nicht
 immer codieren zu mssen ist dies hier als DummyVersion enthalten.

 Copyright Funktion mit verschiedenen Modi:
 Level > 99 sind frei fr diesess Programm verfgbar und
 knnen fr bestimmte Konstanten benutzt werden.
@Return Value
 Pointer zum String
#endif /*DOCUMENTATION*/

const char *
WklibCopyRight( int level )
{
    const char *p;
    switch( level ) {
      case  0:	p = CopyRight(10); break;
      case  1:	p = CopyRight(11); break;
      case  2:	p = CopyRight(12); break;
      case 10:	p = "WkLib"
		  #if DOS386 && __WATCOMC__
		    " (DOS4G)"
		  #elif DOS386
		    " (DOSX)"
		  #elif DOS16RM
		    " (DOS16RM)"
		  #elif M_I86VM
		    " (VCM)"
		  #elif UNIX || POSIX
		    " (Posix)"
		  #elif OS2
		    " (OS/2)"
		  #elif WINNT && __CYGWIN32__
		    " (CygWin)"
		  #elif WINNT
		    " (WinNT)"
		  #elif NETWARE
		    " (Netware)"
		  #elif VMS
		    " (VMS)"
		  #endif
		    "; Copyright (c) 1988-96 by Werner Koch (dd9jn)" ; break;
      case 11:	p = "usage: ?"; break;
      case 16:
      case 13:	p = "WkLib"; break;
      case 14:	p = WKLIB_VERSION ; break;
      case 15:	p = "[Untitled]"; break;
      case 23:	p = "[unknown]"; break;
      case 24:	p = (p=WklibInfoString(NULL,"LinkDate"))? p : ""; break;
      case 12:	p =
   "WkLib is free software; you can redistribute it and/or modify\n"
   "it under the terms of the GNU General Public License as published by\n"
   "the Free Software Foundation; either version 2 of the License, or\n"
   "(at your option) any later version.\n\n"
   "WkLib is distributed in the hope that it will be useful,\n"
   "but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
   "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
   "GNU General Public License for more details.\n\n"
   "You should have received a copy of the GNU General Public License\n"
   "along with this program; if not, write to the Free Software\n"
   "Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,"
								  " USA.\n" ;
	break;
      case 22:
	  #if MSDOS
	    #if USE_EMS
	      p = "MSDOS+EMS";
	    #else
	      p = "MSDOS";
	    #endif
	  #elif OS2
	    p = "OS/2";
	  #elif WINNT && __CYGWIN32__
	    p = "CygWin";
	  #elif WINNT
	    p = "WinNT";
	  #elif DOS386
	    p = "DOS386";
	  #elif EMX
	    p = "EMX";
	  #elif DOS16RM
	    p = "DOS16RM";
	  #elif NETWARE
	    p = "Netware";
	  #elif __linux__
	    p = "Linux";
	  #elif UNIX || M_UNIX || M_XENIX
	    p = "UNIX";
	  #elif VMS
	    p = "VMS";
	  #else
	    p = "UnknownOS";
	  #endif
	    break;
      case 30: p = "";
      case 31: p =
    "This program comes with ABSOLUTELY NO WARRANTY.\n"
    "This is free software, and you are welcome to redistribute it\n"
    "under certain conditions. See the file COPYING for details.\n";
	    break;
      case 32: p = "["
	  #if MSDOS
	      "MSDOS Version"
	  #elif DOS386 && __ZTC__
	    "32-Bit MSDOS Version (Zortech's DOSX)"
	  #elif DOS386
	    "32-Bit MSDOS Version"
	  #elif OS20 && EMX
	    "OS/2 2.x EMX Version"
	  #elif OS20
	    "OS/2 2.x Version"
	  #elif OS2
	    "OS/2 1.x Version"
	  #elif WINNT && __CYGWIN32__
	    "Cygnus WinAPI Version"
	  #elif WINNT
	    "Windoze NT Version"
	  #elif EMX
	    "EMX Version"
	  #elif NETWARE
	    "NLM Version"
	  #elif DOS16RM
	    "DOS16RM Version"
	  #elif __linux__
	    "Linux Version"
	  #elif VMS
	    "OpenVMS Version"
	  #elif POSIX
	    "POSIX Version"
	  #elif M_UNIX || M_XENIX
	    "*IX Version"
	  #endif
	    "]";
	    break;
      case 33: p =
	  #ifdef MULTI_THREADED
	    "mt"
	  #else
	    ""
	  #endif
	    ; break;
      case 42: p = WK_CPU "-" WK_COMPANY "-" WK_SYSTEM; break;
      case 43: p = WK_CPU; break;
      case 44: p = WK_COMPANY; break;
      case 45: p = WK_SYSTEM; break;
      default: p = "?";
    }

    return p;
}


/***** bottom of file ******/
