/* [codepg2.c wk 11.12.90]  EBCDIC - Konvertierungen
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 * 26.01.93 wk	C Set/2 Support - removed header dos.h
 */


#include <wk/tailor.h>
RCSID("$Id: codepg2.c,v 1.5 1995/03/08 16:53:55 wk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <wk/environ.h>

/***** protoytpes ****/
/**** functions *****/


/****************
 * Translate EBCDIC to IBM CodePage 850
 *  dialect = 0 : Standard US EBCDIC
 *	     35 : EBCDIC wie im Automatischen Mahnverfahren benutzt (Siemens)
 *		  (dt. Umlaute, nur Grossbuchstaben)
 *		  Fr diese Teilemenge ist CP437 und CP850 identisch.
 */

byte MapEbcdic2Ibm( byte c, int dialect )
{
  #if DEBUG
    xassert(dialect==35);
  #endif
    switch( c ) {
      case 0x00: c = 0x00	  ; break;
      case 0x0b: c = 0x0b	  ; break;
      case 0x0c: c = 0x0c	  ; break;
      case 0x0d: c = 0x0d	  ; break;
      case 0x25: c = 0x0a	  ; break;

      case 0x40: c = (byte)' '    ; break;
      case 0x4b: c = (byte)'.'    ; break;
      case 0x6b: c = (byte)','    ; break;
      case 0x50: c = (byte)'&'    ; break;
      case 0x60: c = (byte)'-'    ; break;
      case 0x4e: c = (byte)'+'    ; break;
      case 0x61: c = (byte)'/'    ; break;
      case 0x7a: c = (byte)':'    ; break;
      case 0x7e: c = (byte)'='    ; break;
      case 0x7d: c = (byte)'\''   ; break;
      case 0x5e: c = (byte)';'    ; break;
      case 0x5c: c = (byte)'*'    ; break;
      case 0x4d: c = (byte)'('    ; break;
      case 0x5d: c = (byte)')'    ; break;
      case 0x4a: c = (byte)'\x15' ; break;  /* f5 ist auch paragraph,  */
      case 0x7b: c = (byte)'\x8e' ; break;  /*   aber 15 gilt auch in CP437 */
      case 0x7c: c = (byte)'\x99' ; break;
      case 0x5b: c = (byte)'\x9a' ; break;
      case 0x5f: c = (byte)'\xe1' ; break;
      default:
	if( c >= 0x81 && c <= 0x89 ) /* a .. i */
            c = 'a' + c - 0x81;
	else if( c >= 0x91 && c <= 0x99 ) /* j .. r */
            c = 'j' + c - 0x91;
	else if( c >= 0xa2 && c <= 0xa9 ) /* s .. z */
            c = 's' + c - 0xa2;
	else if( c >= 0xc1 && c <= 0xc9 ) /* A .. I */
            c = 'A' + c - 0xc1;
	else if( c >= 0xd1 && c <= 0xd9 ) /* J .. R */
            c = 'J' + c - 0xd1;
	else if( c >= 0xe2 && c <= 0xe9 ) /* S .. Z */
            c = 'S' + c - 0xe2;
	else if( c >= 0xf0 && c <= 0xf9 ) /* 0 .. 9 */
            c = '0' + c - 0xf0;
	else
	    c = 0xff;
	break;
    }
    return c;
}


/***************
 * Translate IBM CodePage 850 to EBCDIC
 *  dialect : Siehe oben
 */

byte MapIbm2Ebcdic( byte c, int dialect )
{
  #if DEBUG
    xassert(dialect==35);
  #endif
    switch( c ) {
      case 0x00: c = 0x00	  ; break;
      case 0x0b: c = 0x0b	  ; break;
      case 0x0c: c = 0x0c	  ; break;
      case 0x0d: c = 0x0d	  ; break;
      case 0x0a: c = 0x25	  ; break;

      case ' '   : c = 0x40 ; break;
      case '.'   : c = 0x4b ; break;
      case ','   : c = 0x6b ; break;
      case '&'   : c = 0x50 ; break;
      case '-'   : c = 0x60 ; break;
      case '+'   : c = 0x4e ; break;
      case '/'   : c = 0x61 ; break;
      case ':'   : c = 0x7a ; break;
      case '='   : c = 0x7e ; break;
      case '\''  : c = 0x7d ; break;
      case ';'   : c = 0x5e ; break;
      case '*'   : c = 0x5c ; break;
      case '('   : c = 0x4d ; break;
      case ')'   : c = 0x5d ; break;
      case 0x15  : /* Paragraph Zeichen ist in cp850 doppelt vorhanden */
      case 0xf5  : c = 0x4a ; break;
      case 0x84  : /* a + A diaeresis */
      case 0x8e  : c = 0x7b ; break;
      case 0x94  : /* o + O diaeresis */
      case 0x99  : c = 0x7c ; break;
      case 0x81  : /* u + U diaeresis */
      case 0x9a  : c = 0x5b ; break;
      case 0xe1  : c = 0x5f ; break; /* eszet */
      default:
        if( c >= '0' && c <= '9' )
            c = 0xf0 + c - '0';
        else if( c >= 'A' && c <= 'I' )
            c = 0xc1 + c - 'A';
        else if( c >= 'J' && c <= 'R' )
            c = 0xd1 + c - 'J';
        else if( c >= 'S' && c <= 'Z' )
            c = 0xe2 + c - 'S';
        else if( c >= 'a' && c <= 'i' )
            c = 0xc1 + c - 'a';
        else if( c >= 'j' && c <= 'r' )
            c = 0xd1 + c - 'j';
        else if( c >= 's' && c <= 'z' )
            c = 0xe2 + c - 's';
	else
	    c = 0xff;
	break;
    }
    return c;
}



/*** bottom of file ***/
