/* [strgbuf.h wk 13.07.93] String Buffer Package
 *	Copyright (c) 1993 by Werner Koch (dd9jn)
 * This file is part of WkLib. See wk/lib.h for details.
 * $Id: strgbuf.h,v 1.10 1996/11/26 16:09:28 wk Exp $
 */

#ifndef HDR_WK_STRGBUF
#define HDR_WK_STRGBUF 1
#ifndef HDR_WK_LIB
    #include <wk/lib.h>
#endif

#if __cplusplus
extern "C" {
#endif


typedef struct strgbuf_struct {
    size_t reserved;
    size_t siz;     /* allocated length of buffer -1 */
    size_t len;     /* current length */
    size_t rptr;
    size_t chunk;
    size_t savelen;
    char **arr;     /* malloced pointer array oder NULL */
    char *p;	    /* malloced buffer */
} strgbuf_t;
typedef strgbuf_t *STRGBUF; /* preferred type */

STRGBUF AllocStrgbuf( size_t initial );
void GrowStrgbuf( STRGBUF a );
void FreeStrgbuf( STRGBUF a );
char **GetStrgbufArray( STRGBUF a );
void AppStrgbuf( STRGBUF a, const char *s );
void AppendStrgbuf( STRGBUF a, STRGBUF b );
void SwapStrgbuf( STRGBUF a, STRGBUF b );

/****************
 * AllocStrgbuf(n) - Allocate a new Stringbuf with an initial size of N.
 * GrowStrgbuf(a)  - (Internal use only)
 * FreeStrgbuf(a)  - release all resources of the strgbuf.
 * FREEStrgbuf(a)  - Releases the resources and set A to NULL
 * PutStrgbuf(a,c) - Append charcacter C to the buffer.
 * UnputStrgbuf(a,n)- set the write pointer N bytes back
 * AppStrgbuf(a,s) - Append the string S to the buffer.
 *		     (The terminating null is not copied)
 * AppendStrgbuf(a,b) - Append buffer b to buffer a.
 * GetStrgbufArray(a) - Return an Array of pointers. this must be freed
 *		    with a call to free(). Each element must be a complete
 *		    C-String.
 * TermStrgbuf(a)  - Append a binary zero to the buffer, but do
 *		     not change its length. This can be used, to access the
 *		     buffer with the strxxx() family of functions().
 * ClearStrgbuf(a) - Clear the buffer for immediate reuse.
 * GetStrgbuf(a)   - Returns the next character or -1 when at end of buffer
 *		     (note: write and read pointers are independent)
 * GetRevStrgbuf(a)- Returns the prev character or -1 when at begin of buffer
 * RewindStrgbuf(a)- set the read pointer to the start of the buffer
 * UngetStrgbuf(a,n)- set the read pointer N bytes back
 * TellStrgbuf(a)   - Tell the current read offset of the buffer,
 *		      this is the offset, which will be read next.
 * SeekStrgbuf(a,n) - Set Readptr to new position n.
 * WriteStrgbuf(a,f)- Write the contents of the buffer to the stream F,
 *		      starting at the current read position.
 * StrgbufLen(a)    - Return the used length of the buffer
 * StrgbufPtr(a)    - Return a pointer to the start of the buffer.
 *		      (Note: This function may not besupported on all platforms)
 */
#define PutStrgbuf(a,c) do { if( (a)->len >= (a)->siz ) GrowStrgbuf(a); \
			     (a)->p[(a)->len++] = (c); } while(0)
#define UnputStrgbuf(a,n) do { if( (a)->len > (n) ) (a)->len -= (n); \
			       else (a)->len = 0; } while(0)
#define TermStrgbuf(a)	do { if( (a)->len >= (a)->siz ) GrowStrgbuf(a); \
			     (a)->p[(a)->len] = 0; } while(0)
#define FREEStrgbuf(a) do { FreeStrgbuf(a); (a) = NULL; } while(0)
#define ClearStrgbuf(a) do { (a)->len = (a)->rptr = 0; } while(0)
#define RewindStrgbuf(a) do { (a)->rptr = 0; } while(0)
#define GetStrgbuf(a)	 ((a)->rptr<(a)->len? ((byte*)(a)->p)[(a)->rptr++]:-1)
#define GetRevStrgbuf(a) ((a)->rptr? ((byte*)(a)->p)[--(a)->rptr]:-1)
#define UngetStrgbuf(a,n) do { if( (a)->rptr > (n) ) (a)->rptr -= (n); \
			       else (a)->rptr = 0; } while(0)
#define TellStrgbuf(a)	 ((a)->rptr)
#define SeekStrgbuf(a,n) do { (a)->rptr = (size_t)(n) >= (a)->len? \
			      (a)->len : (size_t)n; } while(0)
#define WriteStrgbuf(a,f)  do { if( (a)->rptr < (a)->len )     \
				    if( fwrite( (a)->p + (a)->rptr,\
					(a)->len-(a)->rptr, 1 , (f) ) == 1) \
					   (a)->rptr = (a)->len; \
			   } while(0);
#define StrgbufLen(a)	  ((a)->len)
#define StrgbufPtr(a)	  ((a)->p)  /* use with care! */


#if __cplusplus
}
#endif
#endif /* HDR_WK_STRGBUF */
