/* [wk/nmpipe.h wk 10.5.92] Defs for Named Pipes
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 * This file is part of WkLib. See wk/lib.h for details.
 * $Id: nmpipe.h,v 1.5 1995/03/08 16:51:31 wk Exp $
 */

#ifndef HDR_WK_NMPIPE
#define HDR_WK_NMPIPE 1
#ifndef HDR_WK_LIB
    #include <wk/lib.h>
#endif

#if __cplusplus
extern "C" {
#endif

/****** constants ******/
  /* errorcodes */
#define E_NMPIPE_GENERAL    1	/* catch all error */
#define E_NMPIPE_NOMEM	    2	/* out of memory */
#define E_NMPIPE_INVARG     3	/* invalid argument */
#define E_NMPIPE_BUSY	    4	/* pipe is busy */
#define E_NMPIPE_BROKEN     5	/* broken pipe */
#define E_NMPIPE_NOPATH     6	/* path not found (invalid name) */
#define E_NMPIPE_NOCON	    7	/* not connected */
#define E_NMPIPE_BADPIPE    8	/* bad pipe */
#define E_NMPIPE_INVFNC     9	/* invalid function */
#define E_NMPIPE_TIMEOUT   10
#define E_NMPIPE_NOACC	   11	/* access denied */
#define E_NMPIPE_MORE	   12	/* more data available */
#define E_NMPIPE_WFAULT    13	/* write fault */
#define E_NMPIPE_NOTAVL    14	/* not available */
#define E_NMPIPE_INTR	   15	/* operation was interrupted */


/****** prototypes *****/
int NmPipeCreate( int *retHd, const char *name, const char *mode,
		  ushort outSize, ushort inSize, ushort noInst );
int NmPipeOpen( int *retHd, const char *server, const char *name,
		  const char *mode, ulong timeout );
int NmPipeClose( int hd );
int NmPipeConnect( int hd );
int NmPipeDisConnect( int hd );
int NmPipeRead( int hd, void *buffer, ushort size, ushort *nread );
int NmPipeWrite( int hd, void *buffer, ushort nbytes );
int NmPipeDrain( int hd );
int NmPipeCall( const char *server, const char *pipename,
		void *requestBuffer, ushort requestBufferLen,
		void *replyBuffer, ushort replyBufferLen,
		ushort *bytesReplied, ulong timeout );
const char *NmPipeStrError( int n );

/***********************/

#if __cplusplus
}
#endif
#endif /* HDR_WK_NMPIPE */
