/* [wk/lwp.h wk 15.01.94] Light-Weight-Processes
 *	Copyright (c) 1994 by Werner Koch (dd9jn)
 * This file is part of WkLib. See wk/lib.h for details.
 *
 * $Id: lwp.h,v 1.3 1995/03/08 16:51:13 wk Exp $
 */

#ifndef HDR_WK_LWP
#define HDR_WK_LWP 1
#ifndef HDR_WK_LIB
  #include <wk/lib.h>
#endif

#if __cplusplus
extern "C" {
#endif

    /*-- lwpsema.c --*/
typedef struct sema_s {
    struct sema_s *next;
    int initial;
    volatile int count;
} *t_sema;

t_sema CreateSema( int count );
void   CloseSema( t_sema sema );
void   SignalSema( t_sema sema );
void   ResetSema( t_sema sema );
void   WaitSema( t_sema sema );
int    WaitSemaTimed( t_sema sema, ulong timeout );
int    TestSema( t_sema sema );
int    QuerySema( t_sema sema );
void   DecrementSema( t_sema sema );

    /*-- lwpproc.c --*/
#ifdef MULTI_THREADED_OS
  #define LwpYield()
#else
  #define LwpYield()   RelinquishThread()
#endif

typedef struct thread_s {
    struct thread_s *next;
    int  (*fnc)(void*); /* thread function */
    void *parm;     /* args passed to the thread at creation */
    t_sema active;  /* private: controls execution on startup and exit */
    int rc;	    /* return code from function, only valid if not active */
} *t_thread;

t_thread CreateThread( int (*fnc)(void*), void *parm, size_t stackWords );
int GetThreadState( t_thread tib );
void RelinquishThread(void);
void WaitThread( t_thread tib );


    /*-- lwpmain.c --*/
typedef struct eventflag_s {
    struct eventflag_s *next;
    t_sema lock, posted;
    void *value;
} *t_eventflag;

t_eventflag CreateEventFlag(void);
void CloseEventFlag( t_eventflag e );
void *PostEventFlag( t_eventflag e, void *value );
void *WaitEventFlag( t_eventflag e );
void *WaitEventFlagTimed( t_eventflag e, ulong timeout );
void *ResetEventFlag( t_eventflag e );


typedef struct {
    size_t size;    /* total size of the queue */
    size_t head;    /* pointer to first element */
    size_t next;    /* pointer where to insert the next element */
    t_sema space,items; /* semaphores to sync consumers and producers */
    void *d[1];     /* elements */
} *t_queue;

t_queue CreateQueue( size_t size );
void	CloseQueue( t_queue q );
int	Enqueue( t_queue q, void *item);
void *	Dequeue( t_queue q);


#if __cplusplus
}
#endif
#endif /*** end header file ***/
