/* [wk/io.h wk 15.05.93] Redirector for io.h
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 * This file is part of WkLib. See wk/lib.h for details.
 * $Id: io.h,v 1.15 1997/05/21 14:46:22 wk Exp $
 */

#ifndef HDR_WK_IO
#define HDR_WK_IO 1
#ifndef HDR_WK_LIB
    #include <wk/lib.h>   /* need the definition of GNU_C_LIB */
#endif

#if defined(POSIX) || defined(GNU_C_LIB_OS2)
    #include <unistd.h>
    #if EMX && !defined(S_IWRITE)
      #define S_IWRITE 0200 /* not defined because it is not posix */
    #endif
    #ifndef O_BINARY
      #define O_BINARY 0  /* for MSDOS and OS/2 */
    #endif
#else
    #include <io.h>
    #ifdef EMX
      int getpid(void);
      int getppid(void);
    #endif
    #ifndef F_OK
      #define F_OK  0	    /* test for existence of file */
    #endif
    #ifndef X_OK
      #define X_OK  0x01    /* test for execute or search permission */
    #endif
    #ifndef W_OK
      #define W_OK  0x02    /* test for write permission */
    #endif
    #ifndef R_OK
      #define R_OK  0x04    /* test for read permission */
    #endif
    #ifdef __WATCOMC__
      #include <process.h>
      typedef int pid_t;
      #ifdef NETWARE
	/*-- nwmiss.c --*/
	pid_t getpid(void);
	pid_t getppid(void);
      #endif
    #elif __MINGW32__
      #include <process.h>
      typedef int pid_t;
      #define getpid() _getpid()
    #endif
#endif

    /*-- ioerror.c --*/
int GrabIOErrors(int mode);
int UngrabIOErrors(void);


#endif /* HDR_WK_IO */
