/* [wk/file.h wk 20.11.90] Defs for file functions
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 * This file is part of WkLib. See wk/lib.h for details.
 * $Id: file.h,v 1.16 1997/05/21 14:46:22 wk Exp $
 * History:
 * 02.01.93 wk	EMX Support
 * 29.01.93 wk	C Set/2 Support
 */

#ifndef HDR_WK_FILE
#define HDR_WK_FILE 1
#ifndef HDR_WK_LIB
    #include <wk/lib.h>
#endif

#if __cplusplus
extern "C" {
#endif

/****** constants ******/
#if MSDOS || OS2 || DOS386 || DOS16RM || EMX
  #define MSDOSFILESYSTEM 1
#elif defined(WINNT) && WINNT != WINNT_CYG
  #define MSDOSFILESYSTEM 1
#endif

    /* max lengths of filenames (include trailing 0) */
#if OS2 || EMX || WINNT
#define F_MAX_PATH  261
#define F_MAX_DRIVE 3
#define F_MAX_DIR   261
#define F_MAX_FNAME 256
#define F_MAX_EXT   5
#else
#define F_MAX_PATH  144
#define F_MAX_DRIVE 3
#define F_MAX_DIR   130
#define F_MAX_FNAME 9
#define F_MAX_EXT   5
#endif

    /* FlagValues for FExtRead() */
#define F_NFILE_LF  0x0001
#define F_NFILE_FF  0x0002
#define F_NFILE_NUL 0x0004
#define F_NFILE_TAB 0x0008
#define F_NFILE_SKIP_CR 0x0010

    /* values from FileQryFS() ( use 0 for unknown )*/
#define F_FS_FAT    1
#define F_FS_HPFS   2
#define F_FS_UNIX   3
#define F_FS_VFAT   4



/****** prototypes *****/
    /*-- file1.c --*/
FILE *xfopen( const char *, const char *);
void xfclose(FILE*);
int IsTerminal(int);
#if __IBMC__ || GNU_C_LIB
int fcloseall(void);
#endif
    /*-- file2.c --*/
FILE *efopen( const char *, const char *, const char * );
char *efopen2( const char *env, const char *name, const char *type,
							FILE **retfp );
    /*-- file3.c --*/
FILE *fsopen( const char *, const char * );
char *fsopen2( const char *name, const char *type, FILE **retfp );
FILE *xfsopen( const char *, const char * );
    /*-- file4.c --*/
char *FilenameMkAbs( char *, char * );
char *FilenameCompr( char * );
char *Filename2Str( const char *name, char *buffer, size_t bufLen );
    /*-- file5.c --*/
void FilenameSplit(const char *,char *, char *, char *, char *);
void FilenameMake(char*,const char*,const char*,const char*,const char*);
    /*-- file6.c --*/
char *FTabGets(char*,int,FILE*,const char*,int,const char*,int,int*) ;
    /*-- file7.c --*/
size_t FExtRead( char *,size_t,FILE *,unsigned,size_t,size_t *);
    /*-- file8.c --*/
char *CreateTmpFile( const char *prefix );
char *CreateTmpFile2( const char *direct, const char *prefix );
char *CreateTmpFile3( const char *direct, const char *prefix, const char *suf);
char *RenameTmpFile( const char *name, const char *target,
		     const char *prefix, const char *suffix);
    /*-- file9.c --*/
long ScanOffsetTbl( const char *key, FILE *st );
long ScanOffsetTbl1( const char *key, FILE *st, ushort *keyNr );
long ScanOffsetTbl2( ushort keyNr, FILE *st );
    /*-- file10.c --*/
int FileDrvCheck( const char *);
int FileExtCheck( const char *);
int FileExtAppend( char *, const char *);
const char *FileGetFName( const char *path );
    /*-- file11.c --*/
int FileCmpName( const char *, const char * );
char *FileUnifyName( char *name );
int FileQryFS( const char * );
    /*-- file12.c --*/
int FileQryFSLabel( const char *, char *, ushort, ulong *);
    /*-- file13.c --*/
int FileForceRemove( const char *fname );

    /*-- file14.c --*/
int FileLock(int handle,int reserved,ulong offset,ulong nbytes,long timeout);
int FileUnlock(int handle,ulong offset,ulong nbytes);

    /*-- file15.c --*/
FILE *FOpenTmpFile( char **ret_filename, const char *mode, const char *prefix );
FILE *FOpenTmpFile2( char **ret_filename, const char *mode,
				       const char *direct, const char *prefix);
FILE *FOpenTmpFile3( char **ret_filename, const char *mode,
		      const char *direct, const char *prefix, const char *suf);
FILE *FReopenTmpFile( FILE *fp, const char *mode );
int  FCloseTmpFile( FILE *fp );
const char *FGetTmpFileName( FILE *fp );

    /*-- direc5.c --*/
char *extname( const char *path );

/******** defined functions *********/

#if EMX
    #include <unistd.h>  /* get the prototype of getcwd() */
    #if defined (_POSIX_SOURCE)
       char *_getcwd2(char *buffer, int size);
    #endif
    /* and now redefine it */
    #define getcwd(a,b) _getcwd2(a,b)
#endif


#if __cplusplus
}
#endif
#endif /* HDR_WK_FILE */
