/* [wk/fenestra.h wk 29.01.96] Common header for the fenestra system
 *	Copyright (c) 1996 by Werner Koch (dd9jn)
 *
 *  !!!! THIS FILE IS UNDER CONSTRUCTION!!!!
 *
 *  This file is part of Fenestra.
 *
 *  Fenestra is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Fenestra is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * $Id: fenestra.h,v 1.1 1996/02/23 18:08:53 wernerk Exp $
 */

#ifndef HDR_WK_FENESTRA
#define HDR_WK_FENESTRA
#if __cplusplus
extern "C" {
#endif

#ifdef OS2
  #define GUI_IS_PM 1
#else
  #define GUI_IS_X 1
#endif

/*************************************************
 **************** Common Types *******************
 *************************************************/

/****************
 * The type to identify a particular window.
 */
typedef struct fns_struct *FNS;
typedef struct fns_common_struct *FNSCOM;
/****************
 * The type to identify a particular window class
 */
typedef struct fns_class_struct *FNSCLS;
/****************
 * A type to hold unique names. Names must be comparable by a simple
 * comparision ('==' or '!='). A none name should yield false in 'if( name )'
 */
typedef const char *FNSNAME;
/****************
 * All methods are desribed by a function with this type.
 */
typdef int (*FNSFNC)( FNS, FNSMSG, void * )

/****************
 * The messages are desribed by an enum.
 */
typedef enum fns_messages_enum FNSMSG;



/*************************************************
 *************** Data Definitions ****************
 *************************************************/

/****************
 * A default structure for private data of a class
 */
#ifndef HAVE_PRIVATE_FENESTRA_CLASS_DATA
struct fns_class_data_struct {
    char private_class_data[1];
};
#endif

/****************
 * The structure holding all information about a Window class.
 */
struct fns_class_struct {
    FNSNAME name;   /* name of the class */
    FNSCLS  next_class; /* all classes are linked together by this pointer */
    FNSFNC  function; /* object function */
    FNSFNC  parent; /* the parent object function */
    FNSFNC  owner;  /* the function which will receive notifications */
    struct  fns_class_data_struct *data;  /* pointer to private data or NULL */
    unsigned member_size; /* size of a member */
    FNS     first_member; /* head of the linked list of members */
};


/****************
 * To implement a fenestra instance data structure use this code:
 * #define FENESTRA_DATA_IMPL 1
 * BEGIN_FENESTRA_DATA
 *	<declare your vars here>
 * END_FENESTRA_DATA
 */
#define BEGIN_FENESTRA_DATA  \
    struct fns_struct {      \
	FNSCLS cls;	     \
	FNS   next_member;   \

#define END_FENESTRA_DATA  }; \
static unsigned fenestra_data_offset;

/****************
 * The following struct must be identical to the above one!
 */
struct fns_common_struct {
	FNSCLS cls;	   /* the class of this instance */    \
	FNS   next_member; /* the next member of this class */
	char private_data[1];
};

/****************
 * A default instance structure definition.
 */
#ifndef FENESTRA_DATA_IMPL
BEGIN_FENESTRA_DATA
    char private_data[1];
END_FENESTRA_DATA
#endif



/***** The messages ********/
enum fns_messages_enum {
    mNop  = 0,	  /* no operation */
    mInit,	  /* send only once to each object, so that it can perform */
		  /* some initialization (first message seen by an object) */
    mRelease,	  /* last message seen by an object */
    mOpen,	  /* open the Window (not yet visible) */
    mShow,	  /* send when a window should get ready to get displayed */
    mHide,	  /* send when a window should get ready to get hide */
    mClose,	  /* close the window */
    mPaint,	  /* paint the window area */

    mUSER = 5000  /* user defined messages may start with this value */
};

/*************************************************
 *************** Macros **************************
 *************************************************/

/**** sending messages (f must be of type FNSCOM)*****/
#define FnsSend( f, m, d )	  (*(f)->cls->function)( m, d )
#define FnsSendParent( f, m, d )  (*(f)->cls->parent  )( m, d )
#define FnsSendOwner( f, m, d )   (*(f)->cls->owner   )( m, d )



/*************************************************
 *************** Prototypes **********************
 *************************************************/

/**** handling of fns-names (names.c) ****/
FNSNAME  FnsCreateName( const char *string );
FNSNAME  FnsFindName( const char *string );
const char *FnsQueryName( FNSNAME name );


/**** Internal functions (fenestra.c) ***/
void FnsRegisterInstallFunction(const char*, FNSFNC, unsigned );
int FnsDebug( int rc, const char *format, ... );

/**** Interface functions (fenestra.c) ***/
int  FnsInitialize(void);


/**** Object functions (object.c) *****/
FNSCLS FnsRegisterClass( FNSNAME classname, FNSFNC fnc, unsigned reqlen );
int FnsSubclassClass( FNSNAME class_name,
		      FNSNAME parent_name, FNSNAME owner_name);
FNSCLS FnsGetClass( FNSNAME classname );
FNS  FnsCreateObject( FNSCLS cls, void *init_data )
void FnsReleaseObject( FNS fns );



#if __cplusplus
}
#endif
#endif /* HDR_WK_FENESTRA */
