/* [wk/event.h wk 3.6.91] Events
 *	Copyright (c) 1991 by Werner Koch (dd9jn)
 * $Header: /vol1/src/master/libs/wk/event.h,v 1.5 1995/03/30 12:12:40 wernerk Exp $
 */

#ifndef HDR_WK_EVENT
#define HDR_WK_EVENT 1
#ifndef HDR_WK_KEYS
    #include <wk/keys.h>
#endif

#if __cplusplus
extern "C" {
#endif


/****** constants *******/
#define EVT_SIG  1  /* Ein Signal ist registriert */
#define EVT_KBD  2  /* Eine Taste bzw. MouseButton gedrckt. */
#define EVT_CMD  4  /* Ein Command wurde registriert. */
#define EVT_MSMV 8  /* Die Mouse wurde bewegt bei bettigten Knopf */
#define EVT_MSLB 16 /* Der linke Knopf ist bettigt */
#define EVT_MSRB 32 /* Der rechte Knopf ist bettigt */
#define EVT_MS	 (8|16|32)  /* any Mouse action */

#define EVT_MS_BT_L  1	/* returncodes from EventGetMs() */
#define EVT_MS_BT_R  2
#define EVT_MS_BT_LD 4	/* double Click */
#define EVT_MS_BT_RD 8
#define EVT_MS_MV_U 16
#define EVT_MS_MV_R 32
#define EVT_MS_MV_D 64
#define EVT_MS_MV_L 128

/****** types ***********/
/****** globals *********/
#if MSDOS || DOS386 || DOS16RM
volatile int event_Int1BPending; /* can be set by an INT1B Monitor */
#endif

/***** prototypes *******/

void	 EventInit(void);
unsigned EventPoll(void);
unsigned EventWait(void);
unsigned EventPeek(void);
void	 EventClear(unsigned);
int	 EventGetKbd(void);
void	 EventPutKbd(int);
void	 EventPutCmd(int);
int	 EventGetCmd(void);
unsigned EventGetMs( int *, int *);
void	 EventError(void);
void	 EventIdle(void);
int	 EventRgIdle( void (*)(int), int, long );
int	 EventDgIdle( void (*)(int) );
void	 EventRegisterKbd( int (*kbdFnc)(void), unsigned flag);
long	 EventGetCount(unsigned);


const char *EventInfo(void);

#if __cplusplus
}
#endif
#endif /* HDR_WK_EVENT */
