/* [wk/byteord.h wk 03.03.94] Byte Ordering
 *	Copyright (c) 1988-94 by Werner Koch (dd9jn)
 * This file is part of WkLib. See wk/lib.h for details.
 *
 * $Id: byteord.h,v 1.7 1997/10/06 12:55:07 wk Exp $
 */

#ifndef HDR_WK_BYTEORD
#define HDR_WK_BYTEORD 1
#ifndef HDR_WK_LIB
    #include <wk/lib.h>
#endif

#ifdef __linux__
  #include <linux/version.h>
#endif

#if defined(__linux__) && LINUX_VERSION_CODE >= 66054
  #include <asm/byteorder.h>
#else /* we do it ourself */

#ifdef WKLIB_BIG_ENDIAN  /* this is simple */

#define ntohs(x)	(x)
#define ntohl(x)	(x)
#define htons(x)	(x)
#define htonl(x)	(x)

#else /* LITTLE_ENDIAN */


#ifdef __WATCOMC__

  extern ushort htons(ushort);
  extern ushort ntohs(ushort);

  #pragma aux htons	   \
      =   0x86 0xc4	  /* xchg al,ah */			  \
      parm [ax] 	  /* pass value in AX */		  \
      value [ax]	  /* also, return result in AX */	  \
      modify exact [ax]   /* leave all other registers alone */   \
      ;
  #pragma aux (htons) ntohs;  /* ntohs is identical to htons */

  #ifdef __386__
    extern ulong htonl(ulong);
    extern ulong ntohl(ulong);
    #pragma aux htonl	    \
	=   0x86 0xc4	    /* xchg al,ah */			    \
	    0xc1 0xc0 0x10  /* rol eax,16 */			    \
	    0x86 0xc4	    /* xchg al,ah */			    \
	parm [eax]	    /* pass value in AX */		    \
	value [eax]	    /* also, return result in AX */	    \
	modify exact [eax]  /* leave all other registers alone */   \
	;
    #pragma aux (htonl) ntohl;	/* ntohl is identical to htonl */
    #else

    ulong  wklib_htonl(ulong);
    #define ntohl(x)	wklib_htonl(x)
    #define htonl(x)	wklib_htonl(x)
  #endif

#elif __MINGW32__ && defined(_GNU_H_WINDOWS32_SOCKETS)
  /* use functions in WSOCK32 */
#elif __GNUC__	&& __i386__

  extern unsigned long int	  ntohl(unsigned long int);
  extern unsigned short int	  ntohs(unsigned short int);
  extern unsigned long int	  htonl(unsigned long int);
  extern unsigned short int	  htons(unsigned short int);

  static __inline__ unsigned long int
  __ntohl(unsigned long int x)
  {
	  __asm__("xchgb %b0,%h0\n\t"     /* swap lower bytes     */
		  "rorl $16,%0\n\t"       /* swap words           */
		  "xchgb %b0,%h0"         /* swap higher bytes    */
		  :"=q" (x)
		  : "0" (x));
	  return x;
  }

  static __inline__ unsigned short int
  __ntohs(unsigned short int x)
  {
	  __asm__("xchgb %b0,%h0"         /* swap bytes           */
		  : "=q" (x)
		  :  "0" (x));
	  return x;
  }


  #define __htonl(x) __ntohl(x)
  #define __htons(x) __ntohs(x)

  #ifdef  __OPTIMIZE__

    static __inline__ unsigned short int
    __constant_ntohs(unsigned short int x)
    {
	    return (((x & 0x00ff) << 8) |
		    ((x & 0xff00) >> 8));
    }

    static __inline__ unsigned long int
    __constant_ntohl(unsigned long int x)
    {
	    return (((x & 0x000000ffU) << 24) |
		    ((x & 0x0000ff00U) <<  8) |
		    ((x & 0x00ff0000U) >>  8) |
		    ((x & 0xff000000U) >> 24));
    }

    #define __constant_htonl(x) __constant_ntohl(x)
    #define __constant_htons(x) __constant_ntohs(x)

    #define ntohl(x) \
    (__builtin_constant_p((long)(x)) ? \
     __constant_ntohl((x)) : \
     __ntohl((x)))
    #define ntohs(x) \
    (__builtin_constant_p((short)(x)) ? \
     __constant_ntohs((x)) : \
     __ntohs((x)))
    #define htonl(x) \
    (__builtin_constant_p((long)(x)) ? \
     __constant_htonl((x)) : \
     __htonl((x)))
    #define htons(x) \
    (__builtin_constant_p((short)(x)) ? \
     __constant_htons((x)) : \
     __htons((x)))
  #else
    #define ntohl(x) __ntohl((x))
    #define ntohs(x) __ntohs((x))
    #define htonl(x) __htonl((x))
    #define htons(x) __htons((x))
  #endif /* optimize */
#else /* generic functions */

ushort	wklib_htons(ushort);
ulong	wklib_htonl(ulong);

#define ntohs(x)    wklib_htons(x)
#define htons(x)    wklib_htons(x)
#define ntohl(x)    wklib_htonl(x)
#define htonl(x)    wklib_htonl(x)

#endif /* WATCOMC */

#endif	/* BIG_ENDIAN */
#endif	/* our own implementation */

#endif /* HDR_WK_BYTEORD */
