/* [wio.c wk 19.9.91] W-Editor IO-Operations
 *	Copyright (c) 1991 by Werner Koch (dd9jn)
 * This file is part of the W-Editor.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 * 14.05.92 wk	New Backup functions and secure saving mode
 * 27.10.92 wk	added noblanksstrib, when storing in binary mode
 *  6.12.92 wk	Cmd_print should now work with OS/2
 *		changed message from "lines printed" to "pages printed"
 * 09.01.93 wk	Bit 2 for savemode implemeted
 * 12.01.93 wk	Changed meaning of tabmode
 * 20.02.93 wk	Formfeed be print jetzt alle 55 Zeilen (alt: 60)
 * 17.06.94 wk	Now using FileForceRemove()
 * 02.08.94 wk	GP-Trap due to RestFilePos() when saving to an illegal file
 * 21.02.95 wk	added SETOPT_UNIXSAVE
 * 06.03.95 wk	changed savebackmode 2 to UNIX (standard)
 */

#include "wtailor.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <wk/file.h>
#include <wk/string.h>
#include <wk/keys.h>
#if __ZTC__
#include <direct.h>
#endif
#include <wk/io.h>
#include <wk/direc.h>

#include "w.h"
#include "wcmd.h"
#include "wscreen.h"
#include "wfile.h"

/****** constants *********/
#define BKUPDIR_PREFIX	   "/tmp/w.bak"     /* for (savemode & 4) */
#define BKUPDIR_PREFIX_LEN 10		    /* for (savemode & 4) */
/******* typedefs ********/
/******* globals **********/
/******* prototypes *******/
/******* functions ********/


/****************
 * Save the current file
 * -z	 = Append Ctrl-Z to file
 * -fu	 = force writing in UNIX mode (only LF)
 * -fd	 = force writing in DOS  mode (CR and LF)
 * -fl	 = write length prefixed
 * -fb	 = write in true binary mode
 * -f<n> = with n is a digit: write with fixed record length
 * -F<n> = same as -f but ignores trunctate errors
 * -nt	 = no tab compressing
 * -nb	 = no blank stripping
 * -js<n>= use savemode n
 * --	 = end of options
 */

int Cmd_Save( cmd_t *cmd )
{
    int fHd, err, i, blankstrip, savemode, specialTab, format, warn;
    ulong lnr, totLines;
    const char *p, *fileName, *s, *s2;
    char *tempName;
    char *varValue, *filesDirect;
    char showBuf[35];
    unsigned flags;
    char *buffer, *buf;
    ushort lineLen, reclen, xlen;
    size_t saveLen;
    saveFilePos_t savedPos;
    int posIsSaved = 0;
    FILE *st;
    struct {
	int trydef:1;
	int ctrlz:1;
	int fdos:1;
	int funix:1;
	int upr:1;
	int fix:1;
	int notabs:1;
	int nobstrip:1;
	int bin:1;
	int ign:1;
    } o;

    warn = err = 0;


    tempName = filesDirect = NULL;
    fHd = QryScreenFile();
    savemode = GetSetOption( SETOPT_SAVEMODE );
    specialTab= GetSetOption( SETOPT_TABMODE ) == 1;
    fileName = GetFileInfo2( fHd, &flags, &format, &reclen );
    if( cmd->type == ARGTYPE_VAR || cmd->type == ARGTYPE_VARENV ) {
	varValue = VarValue( cmd );
	s = varValue;
    }
    else {
	varValue = NULL;
	if( *cmd->arg.string )
	    s = cmd->arg.string;
	else
	    s = "";
    }


    memset( &o, 0, sizeof o );
    s2 = NULL;
    o.trydef = 1;
    buf = NULL;
    for(;;) {
	while( *s ) {
	    if( isspace( *s ) )
		s++;
	    else if( *s == '-' ) {
		o.trydef = 0;
		if( *++s == '-' ) {
		    s++;
		    while( isspace( *s ) )
			s++;
		    break; /* while loop */
		}
		for( ; *s && !isspace(*s); s++ ) {
		    switch( *s ) {
		      case 'z' : o.ctrlz++; break;
		      case 'F' : o.ign++; /* fall thru */
		      case 'f' :
			switch( s[1] ) {
			  case 'd' : o.fdos++; s++; break;
			  case 'u' : o.funix++; s++; break;
			  case 'l' : o.upr++ ; s++;break;
			  case 'b' : o.bin++ ; s++;break;
			  default:
			    if( isdigit( s[1] ) ) {
				o.fix++;
				s++;
				i = atoi( s ) ;
				if( i < 1 || i >= MAX_LINELEN ) {
				    if( buf )
					FreeVarValue( buf );
				    if( varValue )
					FreeVarValue( varValue );
				    return ERR_INVRLEN;
				}
				reclen = i;
				while( isdigit(*s) )
				    s++ ;
				s--;
			    }
			    break ;
			}
			break;
		      case 'n' :
			switch( s[1] ) {
			  case 't' : o.notabs++; s++; break;
			  case 'b' : o.nobstrip++; s++; break;
			}
			break;
		      case 'j':
			s++;
			switch( *s ) {
			  case 's':
			    s++;
			    savemode = atoi( s ) ;
			    while( isdigit(*s) )
				s++ ;
			    s--;
			    break;
			  default:
			    if( buf )
				FreeVarValue( buf );
			    if( varValue )
				FreeVarValue( varValue );
			  return ERR_INVOPT;
			}
			break;
		      default:
			if( buf )
			    FreeVarValue( buf );
			if( varValue )
			    FreeVarValue( varValue );
			return ERR_INVOPT;
		    }
		}
	    }
	    else
		break;	/* while loop */
	}
	if( !s2 )
	    s2 = s;
	if( o.trydef ) {  /* try default options */
	    o.trydef = 0; /* but not next time */
	    s = buf = VarValueStr( "ZDefSaveOpt", ARGTYPE_VAR );
	}
	else
	    break;
    }
    if( buf )
	FreeVarValue( buf );
    s = s2;
    if( *s)
	fileName = s;
    /* else: use original filename */


    if( !err && o.fdos + o.funix + o.upr +o.bin + o.fix > 1 )
	err = ERR_INVOPTC;
    if( !err && o.fdos + o.funix + o.upr +o.bin + o.fix == 0 )
	if( GetSetOption( SETOPT_UNIXSAVE )
	    && !( *fileName && fileName[1] == ':' &&
		  ( !FileCmpName( fileName+2, "/autoexec.bat" ) ||
		    !FileCmpName( fileName+2, "/config.sys" ) )
	       )
	   )
	   o.funix = 1;

    if( o.upr ) {
	format = WFILE_FMT_2PR;
	o.notabs = 1; /* load doesn't support tabs, so ... */
    }
    else if( o.fix ) {
	format = WFILE_FMT_FIX;
	o.notabs = 1; /* tabs don't make any sense */
    }
    else if( o.bin ) {
	format = WFILE_FMT_BIN;
	o.notabs = 1; /* tabs don't make any sense */
	o.nobstrip=1; /* doesn't make any sense */
    }

    FlushEditBuf( fHd );
    if( err )
	;
    else if( (flags & WFILE_INT) && !*s )
	err = ERR_SAVINT; /* can't save internal file */
    else if( (flags & WFILE_RO) && !*s )
	err = ERR_SAVRO;  /* can't save readonly file */
    else {
	buffer = NULL;
	st = NULL;
	if( access( fileName, F_OK ) )
	    savemode = 0; /* file does not exist, so we don't need savemode */
	else if( savemode )
	    filesDirect = VarValueStr( "ZDir", ARGTYPE_VAR);
	if( savemode  ) {
	    if( !(tempName = CreateTmpFile2( filesDirect, "$W0_" )) ) {
		err = ERR_OPNFIL;
		goto errLabel;
	    }
	}
	if( !(st=fopen(tempName ? tempName : fileName,
		 (!(o.fdos||o.funix||o.upr||o.bin||o.fix)&&
					 format==WFILE_FMT_STD)? "w": "wb" ) ) ) {
	    err = ERR_OPNFIL;
	    goto errLabel;
	}
	buffer = xmalloc( MAX_LINELEN+1 );
	SaveFilePos( fHd, &savedPos );
	posIsSaved=1;
	blankstrip = GetSetOption( SETOPT_BLANKSTRIP ) && !o.nobstrip ;
	totLines  = GetFileTotLines( fHd );
	for(lnr=0; lnr < totLines && !err && !sigIntPending; lnr++) {
	    SeekLine( fHd, lnr );
	    p = GetPtr2Line( fHd, &lineLen );
	    xassert( lineLen < MAX_LINELEN+1 );
	    memcpy( buffer, p, lineLen );
	    if( blankstrip )
		for( ; lineLen; lineLen-- )
		    if( buffer[lineLen-1] != ' ' )
			break;
	    if( !(flags & WFILE_NOTAB) && !o.notabs )
		saveLen = specialTab ? InsertTabs2( buffer, lineLen ) :
				       InsertTabs( buffer, lineLen );
	    else
		saveLen = lineLen;

	    if( format == WFILE_FMT_2PR ) {
		xlen = saveLen + 2;
	      #if !WKLIB_BIG_ENDIAN
		xlen = (xlen << 8) | ((xlen >> 8) & 0xff);
	      #endif
		if( fwrite( &xlen, sizeof xlen, 1, st ) != 1 )
		    err = ERR_WRTFIL;
	    }
	    else if( format == WFILE_FMT_FIX ) {
		if( saveLen > reclen ) {
		    saveLen = reclen;
		    if( o.ign )
			warn = ERR_LTRUNC;
		    else
			err = ERR_LTRUNCNS;
		}
		else { /* fill up with spaces */
		    for( ; saveLen < reclen; saveLen++ )
			buffer[saveLen] = ' ';
		}
	    }

	    if( err )
		;
	    else if( fwrite( buffer, 1, saveLen, st ) != saveLen )
		err = ERR_WRTFIL;
	    else if( sigIntPending )
		err = ERR_CMDINT;
	    else {
		if( o.fdos ) {
		    fputc( '\r', st );
		    fputc( '\n', st );
		}
		else if( o.funix )
		    fputc( '\n', st );
		else if( format == WFILE_FMT_STD )
		    fputc('\n', st );
		if( !((lnr+1) % 200) ) {
		    Filename2Str( tempName? tempName:fileName,
					    showBuf, DIM(showBuf) );
		    ShowMessageAsInfo("%lu lines yet written to %s ...",
				 lnr+1, showBuf );
		    SigIntPoll(); /* do a poll, may be DOS-Break is off */
		}
	    }
	}

	if( !err )
	    if( (GetSetOption( SETOPT_APPCTRLZ ) && format==WFILE_FMT_STD) ||
		o.ctrlz )
		 fputc('\x1a', st) ;
	if( !err ) {
	    fclose(st);
	    st = NULL;
	  #ifdef UNIX
	    {	struct stat *sp;
		const char *s;

		if( sp = GetFileStat(fHd) ) {
		    s = tempName ? tempName : fileName;
		    if( chmod(s, sp->st_mode  ) )
			Error(1000,"%s: chmod failed", fileName);
		    if( !pathconf(s,_PC_CHOWN_RESTRICTED) ) {
			if( chown(s, sp->st_uid, sp->st_gid) )
			    Error(1000,"%s: chown failed", fileName);
		    }
		    else { /* but we should try to change the group */
			if( chown(s, -1, sp->st_gid) )
			    Error(1000,"%s: chgrp failed", fileName);
		    }
		}
	    }
	  #endif
	    p = FileGetFName( fileName );
	    if( buffer )
		FREE( buffer );
	    if( savemode & 2 ) { /* rename old file to backup dir */
		buffer = xmalloc( BKUPDIR_PREFIX_LEN +
				  strlen(filesDirect)+9+strlen(p)+1 );
		if( (savemode & 4) && strlen(filesDirect) > 2 )  {
		  #if MSDOSFILESYSTEM
		    mem2str( buffer, filesDirect+2, BKUPDIR_PREFIX_LEN +1 );
		    if( strcmpl( buffer, BKUPDIR_PREFIX) )
		  #else
		    mem2str( buffer, filesDirect, BKUPDIR_PREFIX_LEN +1 );
		    if( strcmp( buffer, BKUPDIR_PREFIX) )
		  #endif
		    {
		      #if MSDOSFILESYSTEM
			mem2str( buffer, filesDirect, 3 ); /*drive and colon*/
		      #else
			*buffer = 0;
		      #endif
			strcat( buffer, BKUPDIR_PREFIX );
			strcat( buffer, filesDirect+2);
			i = strlen(buffer)-1;
			strcat( buffer, p );
			FileForceRemove( buffer ); /* delete old backup file */
			if( rename( fileName, buffer ) ) {
			    /* may be the directory is not yet created */
			    buffer[i] = '\0';
			    CreateDirectory( buffer, 1 );
			    buffer[i] = '/';
			    if( rename( fileName, buffer ) ) {
				err = ERR_RENFIL;
				goto errLabel;
			    }
			}
		    }
		    else { /* file already in backupdirectory */
			/* but we have to delete him, so that the */
			/* later following rename can work */
			if( FileForceRemove( fileName ) ) {
			    err = ERR_DELFIL;
			    goto errLabel;
			}
		    }
		}
		else {
		    strcpy( buffer, filesDirect);
		  #if UNIX /* use standard UNIX method (append a tilde) */
		    strcat( buffer, p );
		    if( *buffer && buffer[strlen(buffer)-1] == '~' )
			; /* do not backup a backup file */
		    else
			strcat( buffer, "~" );
		    FileForceRemove( buffer ); /* delete old backup file */
		    if( rename( fileName, buffer ) ) {
			err = ERR_RENFIL;
			goto errLabel;
		    }
		  #else
		    strcat( buffer, "Backup.W/");
		    i = strlen(buffer)-1;
		    strcat( buffer, p );
		    FileForceRemove( buffer ); /* delete old backup file */
		    if( rename( fileName, buffer ) ) {
			/* may be the directory is not yet created */
			buffer[i] = '\0';
			CreateDirectory( buffer , 0 );
			buffer[i] = '/';
			if( rename( fileName, buffer ) ) {
			    err = ERR_RENFIL;
			    goto errLabel;
			}
		    }
		  #endif
		}
	    }
	    if( savemode ) { /* delete file and rename temp file */
		if( !(savemode & 2) ) /* but don't delete if already renamed */
		    if( FileForceRemove( fileName ) ) {
			err = ERR_DELFIL;
			goto errLabel;
		    }
		if( rename( tempName, fileName ) ) {
		    Filename2Str( tempName, showBuf, DIM(showBuf) );
		    ShowMessage("Warning: Saved as %s - hit ESCAPE", showBuf );
		    while( GetKeyId(NULL) != K_VK_ESCAPE )
			;
		    err = ERR_RENFIL;
		}
		FREE( tempName );
	    }
	    if( !err )
		RefreshLineIds( fHd );
	}

      errLabel:
	free( buffer );
	if( st )
	    fclose(st);
	if( tempName ) {
	    FileForceRemove( tempName );
	    FREE( tempName );
	}

	ShowMessageAsInfo( warn? GetErrorString(warn) : NULL);
	if( sigIntPending )
	    err = ERR_CMDINT;
	else if( posIsSaved )
	    RestFilePos( &savedPos );
	if( !err && !*s ) {
	    ResetFileFlag( fHd, WFILE_CHG );
	    ResetFileFlag( fHd, WFILE_NEW );
	}
    }
    if( varValue )
	FreeVarValue( varValue );
    if( filesDirect )
	FreeVarValue( filesDirect );
    return err;
}



/****************
 * Print the current file or the marked area
 * mode : 0 = complete file
 *	  1 = only the marked lines
 */
#if W_FULL
int Cmd_Print( cmd_t *cmd, int mode )
{
    int fHd, err, i, ffCount;
    ulong lnr, totLines, pages;
    const char *p;
    unsigned flags;
    char *buffer;
    ushort lineLen;
    size_t saveLen;
    saveFilePos_t savedPos;
    FILE *st_prn;



    err = 0;
    fHd = QryScreenFile();
    FlushEditBuf( fHd );
    buffer = xmalloc( MAX_LINELEN+1 );
    SaveFilePos( fHd, &savedPos );
    totLines  = GetFileTotLines( fHd );
    GetFileInfo( fHd, &flags );
#if __STDC__ || OS2
    /* stdprn doesn't work under OS/2 */
    if( !(st_prn = fopen("PRN", "w")) ) {
	err = ERR_OPNFIL;
	goto errLabel;
    }
#else
    st_prn = stdprn;
#endif
    ffCount = 0;
    pages = 0;
    for(lnr=0; lnr < totLines && !err && !sigIntPending; lnr++) {
	SeekLine( fHd, lnr );
	p = GetPtr2Line( fHd, &lineLen );
	xassert( lineLen < MAX_LINELEN+1 );
	memcpy( buffer, p, saveLen = lineLen );
	if( !(flags & WFILE_NOTAB) )
	    saveLen = InsertTabs( buffer, lineLen );
	if( fwrite( buffer, 1, saveLen, st_prn ) != saveLen )
	    err = ERR_WRTFIL;
	else {
	    fputc('\n', st_prn );
	    for(p=buffer,i=0; saveLen; p++, saveLen-- )
		if( *p == '\f' )
		    i++;
	    if( i ) {
		pages += i;
		ffCount = 0;
	    }
	    else if( ++ffCount > 55 ) {
		fputc('\f', st_prn );
		pages++;
		ffCount = 0;
		i = 1;
	    }
	    if( i ) {
		ShowMessageAsInfo("%lu page%s yet printed ...",
				    pages, pages==1? "":"s");
	    }
	}
    }

    if( !err && ffCount )
	fputc('\f', st_prn );
    clearerr(st_prn);

#if __STDC__ ||  OS2
  errLabel:
    if( st_prn )
	fclose( st_prn );
#endif

    free( buffer );
    ShowMessage(NULL);
    if( sigIntPending )
	err = ERR_CMDINT;
    else
	RestFilePos( &savedPos );
    return err;
}



/****************
 * ffne den file: .editlist und schreibe alle file dort hinein.
 */

int Cmd_EditList( cmd_t *cmd )
{
    int err=0, i, fhd, starthd;
    unsigned flags;
    const char *name;
    char *buffer;


    starthd = QryScreenFile();
    if( !(err=Cmd_Edit(".editlist")) ) {
	fhd = QryScreenFile();
	ResetFileFlag( fhd, WFILE_RO );
	DeleteAllLines( fhd );
	buffer = xmalloc( MAX_LINELEN );
	i = starthd;
	do {
	    name = GetFileInfo(i, &flags );
	    if( !(flags & WFILE_INT) ) {
		sprintf( buffer, "%c %s",
			 flags & WFILE_NEW ? 'n':
			 flags & WFILE_CHG ? '*':' ',
			 name );
		InsertLine( fhd, buffer, strlen(buffer) );
	    }
	    i = GetNextFileHandle( i );
	} while( i != starthd );
	i = starthd;
	do {
	    name = GetFileInfo(i, &flags );
	    if( flags & WFILE_INT ) {
		sprintf( buffer, "%c %s",
			 flags & WFILE_CHG ? '*':' ',
			 name );
		InsertLine( fhd, buffer, strlen(buffer) );
	    }
	    i = GetNextFileHandle( i );
	} while( i != starthd );
	free(buffer);
	SeekLine( fhd, 0 );
	if( GetFileTotLines( fhd ) > 1 )
	    DeleteLine( fhd );
	Move2Pos( fhd, 0, 0 );
	ResetFileFlag( fhd, WFILE_CHG );
	SetFileFlag( fhd, WFILE_RO );
    }
    return err;
}


int Cmd_Erase( cmd_t *cmd )
{
    const char *s;
    char *varValue;
    int i;

    if( cmd->type == ARGTYPE_VAR || cmd->type == ARGTYPE_VARENV ) {
	varValue = VarValue( cmd );
	s = varValue;
    }
    else {
	varValue = NULL;
	if( *cmd->arg.string )
	    s = cmd->arg.string;
	else
	    s = "";
    }
    /* optionprocessing */
    while( *s ) {
	if( isspace( *s ) )
	    s++;
	else if( *s == '-' ) {
	    if( *++s == '-' ) {
		s++;
		while( isspace( *s ) )
		    s++;
		break; /* while loop */
	    }
	    for( ; *s && !isspace(*s); s++ )
		return ERR_INVOPT;
	}
	else
	    break;  /* while loop */
    }
    /* end optionprocessing */
    if( *s )
	i = remove( s ) ? ERR_DELFIL : 0;
    else
	i = ERR_INVARG;
    if( varValue )
	FreeVarValue( varValue );
    return i;
}
#endif

/*** bottom of file ***/
