/* [wedit8.c wk 27.1.92] W-Editor Operations 8
 *	Copyright (c) 1991 by Werner Koch (dd9jn)
 * This file is part of the W-Editor.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 *  CUT/COPY/PASTE
 *
 *  MS-Windows support is somewhat undocumented
 *   (see: c't 12/92 pg. 246ff )
 *
 * History:
 *
 */


#include "wtailor.h"
#if OS2 || OS20
  #ifndef OS2_PM
    #define OS2_PM 1
  #endif
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <limits.h>
#include <wk/lib.h>
#include <wk/string.h>
#include <wk/file.h>

#if OS20
    /* funktioniert nicht */
#elif OS2
    /* funktioniert auch nicht */
#elif OS2
    #define GUI_IS_PM 1
#elif MSDOS
    #define GUI_IS_WINDOWS 1 /* should say: .. maybe Windows */
#endif


#if GUI_IS_PM
    #define INCL_DOSMEMMGR 1
    #define INCL_WIN 1
    #include <os2.h>
    #define INCL_WK_WSCRDRV_GUI 1
    #include <wk/wscrdrv.h>
#elif GUI_IS_WINDOWS
    #include <dos.h>
#endif

#if OS20 && GUI_IS_PM
    #error Have problems with OS/2
#endif

#include "w.h"
#include "wcmdpr.h"
#include "wscreen.h"
#include "wfile.h"     /* hier prototype fuer CleanupPMClipBoard() */
#ifdef UNIX
#include "jnx.h"
#endif
#if W_FULL

/****** constants *********/
#define DDE_SIZE 8192
/******* typedefs ********/
/******* globals **********/
static int  cleanUpInitialized;
static int  typeOfClipboard;  /* Flag, controls clipboard type */
			      /* 0 = unknown		    */
			      /* 1 = GUI-Clipboard NOT available */
			      /* 2 = GUI-Cipboard IS available */
static char *clipboardData; /* Ptr to allocated Clipboarddata or NULL */
			    /* if Windows or OS/2 Clipboard is in Use */
#if GUI_IS_PM || GUI_IS_WINDOWS
static char   accessMsg[] = "Accessing clipboard ...";
#endif

#if GUI_IS_PM
static habIsValid;  /* 0 = invalid , 1 = initialized here,
				     2 = initialized somewhere else */
static HAB     hab;	/* anchor block handle */
static int    pmClipBoardIsOpen;
#endif

/******* prototypes *******/
static void DoInit(void);
static void CleanUp(void *dummy);
/******* functions ********/


static void
DoInit(void)
{
    static int lastOption = -1;
    int i;
  #if GUI_IS_WINDOWS
    union REGS inregs, outregs ;
  #endif

    if( !cleanUpInitialized ) {
	AddCleanUp( CleanUp, NULL );
	cleanUpInitialized = 1;
    }
    i = GetSetOption( SETOPT_INTCLIP );
    if( i != lastOption ) {
	lastOption = i;
	typeOfClipboard = i ? 1 : 0;
    }
    if( typeOfClipboard )
	return; /* already initialized */

  #if GUI_IS_PM
    if( habIsValid ) {
	typeOfClipboard = 2;
	return;
    }
    if( hab = ScrDrvGetActiveHAB() ) {
	habIsValid = 2;
	typeOfClipboard = 2;
	return;
    }

    if( !(hab = WinInitialize(0)) ) {
	/* WinInitialize failed */
	typeOfClipboard = 1;
	return;
    }
    habIsValid = 1;
    typeOfClipboard = 2;

  #elif GUI_IS_WINDOWS
    inregs.x.ax = 0x1700; /* clipboard available ?*/
    int86( 0x2f, &inregs, &outregs ) ;
    if( outregs.x.ax == 0x1700 )
	typeOfClipboard = 1;
    else
	typeOfClipboard = 2;
  #elif defined(UNIX)
    if( JnxAvailable() )
	typeOfClipboard = 2;
    else
	typeOfClipboard = 1;
  #endif
}


static void CleanUp(void *dummy)
{
  #if GUI_IS_PM
    if( habIsValid == 1 ) {
	WinTerminate( hab );
	habIsValid = 0;
    }
  #endif
    FREE(clipboardData);
}


#if GUI_IS_PM
/****************
 * Kann aufgerufen werden, um sicherzustellen, dass
 * das Clipboard nicht offen ist (kann z.B. durch KILL_PROCESS)
 * geschehen. - Scheint bei einer FS-Anwendung notwendig zu sein.
 * Wird via DosExitList() aufgerufen.
 */
void CleanupPMClipBoard(void)
{
    if( pmClipBoardIsOpen )
	WinCloseClipbrd( hab );
}
#elif OS2 /* wir brauchen eine dummy function */
void CleanupPMClipBoard(void)
{
    ;
}
#endif	/* GUI_IS_PM */




#ifdef UNIX
int
Cmd_Copy()
{
    int fhd, err, mtype;
    const char *txt;
    ulong line1, line2, lnr, bufSize;
    ushort pos1, pos2, xlen, nsrc;
    ulong srcLineNr=0; /* avoid uninitialized warning */
    ushort srcPos;
    char  *buffer, *p;

    DoInit();
    err = 0;
    bufSize = 0;
    buffer = NULL;
    fhd = QryScreenFile();
    if( mtype = MarkInfo( &fhd ) )
	srcLineNr = GetFilePos( fhd, &srcPos );
    switch( mtype ) {
      case MARKTYPE_LINE:
	line1 = MarkStart( NULL );
	line2 = MarkEnd( NULL );
	/* calc bufSize */
	for( lnr = line1; lnr <= line2 && !err; lnr++ ){
	    SeekLine( fhd, lnr );
	    GetPtr2Line( fhd, &nsrc );
	    bufSize += nsrc + 1; /* for terminating LF */
	    if( SigIntPoll() )
		err = ERR_CMDINT;
	}
	if( err )
	    goto retLabel;
	bufSize += 1; /* and one for terminating 0 */
	if( bufSize > UINT_MAX-100 ) {
	    err = ERR_MRK2LRG;
	    goto retLabel;
	}
	if( !(buffer = malloc( bufSize )) ) {
	    err = ERR_NOMEM;
	    goto retLabel;
	}

	/* now copy to our buffer */
	p = buffer;
	for( lnr = line1; lnr <= line2 && !err; lnr++ ){
	    SeekLine( fhd, lnr );
	    for( txt = GetPtr2Line(fhd, &nsrc ) ; nsrc ; nsrc--, txt++ )
		*p++ = *txt ? *txt : ' ';
	    *p++ = '\n';
	    if( SigIntPoll() )
		err = ERR_CMDINT;
	}
	*p = 0;
	break;

      case MARKTYPE_BLOCK:
	line1 = MarkStart( &pos1);
	line2 = MarkEnd( &pos2);
	xlen = pos2 - pos1 + 1;
	/* calc bufSize */
	for( lnr = line1; lnr <= line2 && !err; lnr++ ){
	    SeekLine( fhd, lnr );
	    GetPtr2Line( fhd, &nsrc );
	    if( pos1 > nsrc )
		nsrc = 0;
	    else {
		nsrc -= pos1;
		if( nsrc > xlen )
		    nsrc = xlen;
	    }
	    bufSize += nsrc + 1; /* for terminating LF */
	    if( SigIntPoll() )
		err = ERR_CMDINT;
	}
	if( err )
	    goto retLabel;
	bufSize += 1; /* and one for terminating 0 */
	if( bufSize > UINT_MAX-100 ) {
	    err = ERR_MRK2LRG;
	    goto retLabel;
	}
	if( !(buffer = malloc( bufSize )) ) {
	    err = ERR_NOMEM;
	    goto retLabel;
	}

	/* now copy to the buffer */
	p = buffer;
	for( lnr = line1; lnr <= line2 && !err; lnr++ ){
	    SeekLine( fhd, lnr );
	    txt = GetPtr2Line( fhd, &nsrc );
	    if( pos1 > nsrc )
		nsrc = 0;
	    else {
		nsrc -= pos1;
		if( nsrc > xlen )
		    nsrc = xlen;
	    }
	    for( txt += pos1; nsrc ; nsrc--, txt++ )
		*p++ = *txt ? *txt : ' ';
	    *p++ = '\n';
	    if( SigIntPoll() )
		err = ERR_CMDINT;
	}
	*p = 0;
	break;

      default:
	err = ERR_NOMRK;
	break;
    }
    if( mtype && !err && typeOfClipboard == 2 && JnxAvailable() ) {
	JnxStoreBytes(buffer, strlen(buffer) );
    }
    else if( mtype && !err ) { /* typeofclipboard == 1 */
	free(clipboardData);	  /* empty clipboard */
	clipboardData = buffer;   /* save allocated memory = setCPData */
	buffer = NULL;	 /* do not free this ptr */
    }


  retLabel:
    if( buffer )
	free( buffer );
    if( mtype )
	Move2Pos( fhd, srcLineNr, srcPos );
    return err;
}
#else /* not unix */
int
Cmd_Copy()
{
    int fhd, err, mtype;
    const char *txt;
    ulong line1, line2, lnr, bufSize;
    ushort pos1, pos2, xlen, nsrc;
    ulong srcLineNr=0; /* avoid uninitialized warning */
    ushort srcPos;
  #if GUI_IS_PM || GUI_IS_WINDOWS
    ushort n;
  #endif
  #if GUI_IS_PM
    PCHAR  buffer, p;
  #else
    char  *buffer, *p;
  #endif
  #if GUI_IS_WINDOWS
    union REGS inregs, outregs ;
    struct SREGS segregs;
  #endif

    DoInit();
    err = 0;
    bufSize = 0;
    buffer = NULL;
    fhd = QryScreenFile();
    if( mtype = MarkInfo( &fhd ) )
	srcLineNr = GetFilePos( fhd, &srcPos );
    switch( mtype ) {
      case MARKTYPE_LINE:
	line1 = MarkStart( NULL );
	line2 = MarkEnd( NULL );
	/* calc bufSize */
	for( lnr = line1; lnr <= line2 && !err; lnr++ ){
	    SeekLine( fhd, lnr );
	    GetPtr2Line( fhd, &nsrc );
	    bufSize += nsrc + 2; /* for terminating CR,LF */
	    if( SigIntPoll() )
		err = ERR_CMDINT;
	}
	if( err )
	    goto retLabel;
	bufSize += 1; /* and one for terminating 0 */
	if( bufSize > UINT_MAX-100 ) {
	    err = ERR_MRK2LRG;
	    goto retLabel;
	}
      #if GUI_IS_PM
	if( typeOfClipboard == 2 ) {
	    if( DosAllocSharedMem((PVOID*)&buffer, NULL, bufSize,
			 PAG_READ|PAG_WRITE|PAG_COMMIT|OBJ_GIVEABLE ) ) {
		DbgPoint();
		buffer = NULL;
		err = ERR_NOMEM;
		goto retLabel;
	    }
	}
	else {
      #endif
	    if( !(buffer = malloc( bufSize )) ) {
		DbgPoint();
		err = ERR_NOMEM;
		goto retLabel;
	    }
      #if GUI_IS_PM
	}
      #endif

	/* now copy to the shared memory */
	p = buffer;
	for( lnr = line1; lnr <= line2 && !err; lnr++ ){
	    SeekLine( fhd, lnr );
	    for( txt = GetPtr2Line(fhd, &nsrc ) ; nsrc ; nsrc--, txt++ )
		*p++ = *txt ? *txt : ' ';
	    *p++ = '\r';
	    *p++ = '\n';
	    if( SigIntPoll() )
		err = ERR_CMDINT;
	}
	*p = 0;
	break;

      case MARKTYPE_BLOCK:
	line1 = MarkStart( &pos1);
	line2 = MarkEnd( &pos2);
	xlen = pos2 - pos1 + 1;
	/* calc bufSize */
	for( lnr = line1; lnr <= line2 && !err; lnr++ ){
	    SeekLine( fhd, lnr );
	    GetPtr2Line( fhd, &nsrc );
	    if( pos1 > nsrc )
		nsrc = 0;
	    else {
		nsrc -= pos1;
		if( nsrc > xlen )
		    nsrc = xlen;
	    }
	    bufSize += nsrc + 2; /* for terminating CR,LF */
	    if( SigIntPoll() )
		err = ERR_CMDINT;
	}
	if( err )
	    goto retLabel;
	bufSize += 1; /* and one for terminating 0 */
	if( bufSize > UINT_MAX-100 ) {
	    err = ERR_MRK2LRG;
	    goto retLabel;
	}
      #if GUI_IS_PM
	if( typeOfClipboard == 2 ) {
	    if( DosAllocSharedMem((PVOID*)&buffer, NULL, bufSize,
			 PAG_READ|PAG_WRITE|PAG_COMMIT|OBJ_GIVEABLE ) ) {
		DbgPoint();
		buffer = NULL;
		err = ERR_NOMEM;
		goto retLabel;
	    }
	}
	else {
      #endif
	    if( !(buffer = malloc( bufSize )) ) {
		DbgPoint();
		err = ERR_NOMEM;
		goto retLabel;
	    }
      #if GUI_IS_PM
	}
      #endif

	/* now copy to the shared/allocated memory */
	p = buffer;
	for( lnr = line1; lnr <= line2 && !err; lnr++ ){
	    SeekLine( fhd, lnr );
	    txt = GetPtr2Line( fhd, &nsrc );
	    if( pos1 > nsrc )
		nsrc = 0;
	    else {
		nsrc -= pos1;
		if( nsrc > xlen )
		    nsrc = xlen;
	    }
	    for( txt += pos1; nsrc ; nsrc--, txt++ )
		*p++ = *txt ? *txt : ' ';
	    *p++ = '\r';
	    *p++ = '\n';
	    if( SigIntPoll() )
		err = ERR_CMDINT;
	}
	*p = 0;
	break;

      default:
	err = ERR_NOMRK;
	break;
    }
    if( mtype && !err && typeOfClipboard == 2) {
      #if GUI_IS_PM || GUI_IS_WINDOWS
	ShowMessageAsInfo(accessMsg);
      #endif
      #if GUI_IS_PM
	pmClipBoardIsOpen++;
	if( !WinOpenClipbrd( hab ) ) {
	    pmClipBoardIsOpen--;
	    DbgPoint();
	    ShowMessageAsInfo(NULL);
	    err = ERR_CLPBRD;
	    goto retLabel;
	}
	ShowMessageAsInfo(NULL);
	if( !WinEmptyClipbrd( hab ) ) {
	    DbgPoint();
	    err = ERR_CLPBRD;
	    goto retLabel;
	}
	if( !WinSetClipbrdData( hab, (ULONG)buffer, CF_TEXT, CFI_POINTER ) ) {
	    DbgPoint();
	    err = ERR_CLPBRD;
	    goto retLabel;
	}
	buffer = NULL; /* clipboard is now the owner */
	if( !WinCloseClipbrd( hab ) ) {
	    DbgPoint();
	    err = ERR_CLPBRD;
	    goto retLabel;
	}
	pmClipBoardIsOpen--;

      #elif GUI_IS_WINDOWS

	inregs.x.ax = 0x1701; /* open clipboard */
	int86( 0x2f, &inregs, &outregs ) ;
	if( !outregs.x.ax ) {
	    ShowMessageAsInfo(NULL);
	    err = ERR_CLPBRD;
	    goto retLabel;
	}
	ShowMessageAsInfo(NULL);

	inregs.x.ax = 0x1702; /* empty clipboard */
	int86( 0x2f, &inregs, &outregs ) ;
	if( !outregs.x.ax )
	    err = ERR_CLPBRD;
	else {
	    inregs.x.ax = 0x1709; /* query available memory */
	    inregs.x.si = (bufSize >> 16) & 0xfff; /* highword of des. length*/
	    inregs.x.cx = bufSize & 0xffff;	   /* lowword of des. length */
	    int86( 0x2f, &inregs, &outregs );
	    if( ((ulong)outregs.x.ax+((ulong)outregs.x.dx<<16)) < bufSize )
		err = ERR_CLPBRD;
	    else {
		inregs.x.ax = 0x1703; /* set clipboard data */
		inregs.x.dx = 7;      /* CF_OEMTEXT */
		segregs.es  = FP_SEG(buffer);
		inregs.x.bx = FP_OFF(buffer);
		inregs.x.si = (bufSize >> 16) & 0xfff;	/* highword of length*/
		inregs.x.cx = bufSize & 0xffff; 	/* lowword of length */
		int86x( 0x2f, &inregs, &outregs, &segregs ) ;
		if( !outregs.x.ax )
		    err = ERR_CLPBRD;
	    }
	}

	inregs.x.ax = 0x1708; /* close clipboard */
	int86( 0x2f, &inregs, &outregs ) ;
	if( !outregs.x.ax ) {
	    if( !err )
		err = ERR_CLPBRD;
	    goto retLabel;
	}
      #endif /* GUI_IS... */
    }
    else if( mtype && !err ) { /* typeofclipboard == 1 */
	free(clipboardData);	  /* empty clipboard */
	clipboardData = buffer;   /* save allocated memory = setCPData */
	buffer = NULL;	 /* do not free this ptr */
    }


  retLabel:
    if( buffer )
      #if GUI_IS_PM
	if( typeOfClipboard == 2 )
	    DosFreeMem( buffer );
	else
      #endif
	    free( buffer );

    if( mtype )
	Move2Pos( fhd, srcLineNr, srcPos );
    return err;
}
#endif /* not unix */



#ifdef UNIX
int
Cmd_Paste()
{
    int err=0, fhd;
    unsigned flags;
    size_t nbytes;
    char *p;

    DoInit();
    nbytes = 0;
    fhd = QryScreenFile();
    GetFileInfo( fhd, &flags );
    if( flags & WFILE_RO ) {
	err = ERR_EDTRO;
	goto retLabel;
    }

    if( typeOfClipboard == 2 && JnxAvailable() ) {
	p = JnxFetchBytes( &nbytes );
	if( p ) {
	    err = PutTTYString( p, nbytes );
	    JnxFreeFetchedBytes( p );
	}
	else
	    err = ERR_CLPEMPTY;
    }
    else {  /* typeOfClipboard == 1 */
	if( clipboardData )
	    err = PutTTYString( clipboardData, strlen(clipboardData) );
	else
	    err = ERR_CLPEMPTY;
    }


  retLabel:
    return err;
}
#else /* not unix */
int
Cmd_Paste()
{
    int err=0, fhd;
    unsigned flags;
    ushort nbytes;
    char   *buffer;
  #if GUI_IS_PM || GUI_IS_WINDOWS
    ushort n, pos;
    char  *p;
  #endif
  #if GUI_IS_PM
    PCHAR  clipBuf;
  #endif

    DoInit();
    buffer = NULL;
    nbytes = 0;
    fhd = QryScreenFile();
    GetFileInfo( fhd, &flags );
    if( flags & WFILE_RO ) {
	err = ERR_EDTRO;
	goto retLabel;
    }

    if( typeOfClipboard == 2 ) {
      #if GUI_IS_PM || GUI_IS_WINDOWS
	ShowMessageAsInfo(accessMsg);
      #endif
      #if GUI_IS_PM
	pmClipBoardIsOpen++;
	if( !WinOpenClipbrd( hab ) ) {
	    pmClipBoardIsOpen--;
	    DbgPoint();
	    ShowMessageAsInfo(NULL);
	    err = ERR_CLPBRD;
	    goto retLabel;
	}
	ShowMessageAsInfo(NULL);
	nbytes = 0;
	if( clipBuf = (PCHAR)WinQueryClipbrdData( hab, CF_TEXT ) ) {
	    ULONG   ulFmtInfo;	 /* Memory model and usage flags */
	    BOOL    fExists;	  /* Format-exists indicator */

	    fExists = WinQueryClipbrdFmtInfo(hab, CF_TEXT, &ulFmtInfo);
	    printf("Exists=%d Format=%08lx\n");


	    DbgPoint();
	    nbytes = strlen(clipBuf);
	    if( !(buffer = malloc( nbytes+1 )) )
		err = ERR_NOMEM;
	    else {
		for(p=buffer; *clipBuf; )
		    *p++ = *clipBuf++;
	    }
	}
	else
	    err = ERR_CLPEMPTY;
	if( !WinCloseClipbrd( hab ) ) {
	    DbgPoint();
	    err = ERR_CLPBRD;
	    goto retLabel;
	}
	pmClipBoardIsOpen--;
      #elif GUI_IS_WINDOWS
	err = ERR_USPCMD;
      #endif
	if( !err )  /* ... und ausgeben wenn clipboard closed */
	    err = PutTTYString( buffer, nbytes );
    }
    else {  /* typeOfClipboard == 1 */
	if( clipboardData )
	    err = PutTTYString( clipboardData, strlen(clipboardData) );
	else
	    err = ERR_CLPEMPTY;
    }


  retLabel:
    if( buffer )
	free( buffer );
    return err;
}
#endif /* not unix */


int Cmd_Cut()
{
    int err;

    if( !(err=Cmd_Copy()) )
	err = Cmd_DeleteMark();
    return err;
}

#endif	/* W_FULL */

/*** bottom of file ***/
