/* [wedit6.c wk 7.1.92] W-Editor Operations 6
 *	Copyright (c) 1991 by Werner Koch (dd9jn)
 * This file is part of the W-Editor.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Header: /usr/src/master/apps/w/src/wedit6.c,v 1.8 1996/09/10 12:20:04 wk Exp $
 *
 *  block delimiter match, ascii table, help
 */

#include "wtailor.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <limits.h>
#include <wk/lib.h>
#include <wk/string.h>

#include "w.h"
#include "wcmdpr.h"
#include "wscreen.h"
#include "wfile.h"

/****** constants *********/
/******* typedefs ********/
/******* globals **********/
/******* prototypes *******/
/******* functions ********/


/****************
 * match a block delimiter, that ist: find the corresponding delimiter:
 * Delimiters are: {, }, (, )
 *  The Cursor must be at a valid delimiter.
 * Returns: Errorcode (ERR_INVDEL, ERR_NFOUND)
 */
#if W_FULL
int Cmd_MatchBlock(void)
{
    int fhd, err=0, direction, count;
    const char *p;
    char del1, del2;
    ushort nbytes, n, savePos;
    long saveLine, curLine, lastLnr;

    direction = 0; /* avoid uninitialized warning */
    del1=del2 = 0; /* avoid uninitialized warning */
    fhd = QryScreenFile();
    p = GetPtr2Line( fhd, &nbytes );
    curLine = saveLine = GetFilePos( fhd, &n );
    savePos = n;
    if( n >= nbytes )
	err = ERR_INVDEL;
    else {
	p += n;
	switch( del1 = *p ) {
	  case '{': del2 = '}'; direction = 1; break;
	  case '}': del2 = '{'; direction = 0; break;
	  case '(': del2 = ')'; direction = 1; break;
	  case ')': del2 = '('; direction = 0; break;
	  case '[': del2 = ']'; direction = 1; break;
	  case ']': del2 = '['; direction = 0; break;
	  case '<': del2 = '>'; direction = 1; break;
	  case '>': del2 = '<'; direction = 0; break;
	  case '`': del2 = '\''; direction = 1; break;
	  case '\'': del2 = '`'; direction = 0; break;
	  default: err = ERR_INVDEL;
	}
    }

    count = 1;
    if( !err && direction) { /* search forward */
	lastLnr = GetFileTotLines( fhd )-1;
	n++; p++;
	while( !err ) {
	    for( ; n < nbytes; n++, p++ )
		if( *p == del1 )
		    count++;
		else if( *p == del2 ) {
		    if( !--count )  /* found */
			goto endLabel;
		}
	    if( sigIntPending )
		err = ERR_CMDINT;
	    else if( curLine < lastLnr ) {
		SeekLine( fhd, ++curLine );
		p = GetPtr2Line( fhd, &nbytes );
		n = 0;
	    }
	    else
		err =  ERR_NFOUND;
	}
    }
    else if( !err ) { /* search backward */
	p--;
	while( !err ) {
	    for( ; n ; n--, p-- )
		if( *p == del1 )
		    count++;
		else if( *p == del2 ) {
		    if( !--count ) { /* found */
			n--;
			goto endLabel;
		    }
		}
	    if( sigIntPending )
		err = ERR_CMDINT;
	    else if( curLine ) {
		SeekLine( fhd, --curLine );
		p = GetPtr2Line( fhd, &n );
		if( n)
		    p += n-1;
	    }
	    else
		err =  ERR_NFOUND;
	}
    }

  endLabel:
    if( !err )
	Move2Pos( fhd, curLine, n );
    else
	Move2Pos( fhd, saveLine, savePos );

    return err;
}


/****************
 * Open Internal file Ascii Table
 */

int Cmd_Ascii()
{
    int err=0, n, fhd, i, j;
    char *buffer;

    if( !(err=Cmd_Edit(".ascii")) ) {
	fhd = QryScreenFile();
	ResetFileFlag( fhd, WFILE_RO );
	DeleteAllLines( fhd );
	buffer = xmalloc( MAX_LINELEN );
	for(i=0; !err && i < 32; i++ ) {
	    for(n=0,j=0; j < 256; j += 32 ) {
		sprintf(buffer+n,"%3d %02X %c""   ", i+j, i+j, (byte)(i+j) );
		n += n==30? 11:10;
	    }
	    err = InsertLine( fhd, buffer, 79 );
	}
	free(buffer);
	if( !err ) {
	    SeekLine( fhd, 0 );
	    if( GetFileTotLines( fhd ) > 1 )
		DeleteLine( fhd );
	    Move2Pos( fhd, 0, 0 );
	}
	ResetFileFlag( fhd, WFILE_CHG );
	SetFileFlag( fhd, WFILE_RO );
    }

    return err;
}

#endif

/****************
 * Show Help, if key is empty show the standard helpfile
 * else take key as a command and try to locate it in the docfile
 */

int Cmd_Help( const char *key )
{
    int err=0;
    int cmd, fhd;
    char *buffer, *d;
    const char *p;
    ushort nbytes;
    int a,b;

    EnableHistoryUpdate(0);
  #if W_FULL
    if( !*key )
	err = Cmd_ExecuteString(
	"cc;bl;ee;'load -j0 '%ZLoadDir %ZPgmName'.hlp'excl;s ro;ring off"
		, ARGTYPE_STRING );
    else if( !(err = Cmd_ExecuteString(
	     "cc;bl;ee;'load -jR '%ZLoadDir %ZPgmName'.rfi'excl;s ro;ring off"
		, ARGTYPE_STRING )) ) {
	fhd = QryScreenFile();
	SetFileFlag( fhd, WFILE_INT );
	Move2Line( fhd , 0 );
	if( cmd=String2Cmd( key ) )
	    p = Cmd2String( cmd, 0 );
	else /* not a command, but try to locate by key */
	    p = key;
	/* build the search string */
	buffer = xmalloc( 100 );
	if( strlen(p) < 3 )
	    sprintf( buffer, "l/(%s)/", p );
	else
	    sprintf( buffer, "l/%.30s/l", p );
	err = Cmd_ExecuteString( buffer, ARGTYPE_STRING );
	if( err == ERR_NFOUND ) {
	    Cmd_Quit();
	    ShowMessage("Command '%s' not found", p );
	    err = 0;
	}
	else {
	    p = GetPtr2Line( fhd, &nbytes );
	    if( nbytes > 98 )
		nbytes = 98;
	    for(d=buffer; nbytes && *p ; nbytes-- )
		*d++ = *p++;
	    *d = 0;
	    Cmd_Quit();
	    if( (d=strchr(buffer, ':')) && (d=strchr(d+1, ':')) ) {
		d++;
		a = atoi(d);
		b = (d = strchr(d,'('/*)*/))? atoi(d+1) : 100;
		sprintf(buffer,
			"cc;bl;ee;'load -jR -s%d -m%d '%%ZLoadDir"
			" %%ZPgmName'.ref'excl;s ro", a , b );

		if( !(err = Cmd_ExecuteString( buffer, ARGTYPE_STRING )) ) {
		    fhd = QryScreenFile();
		    SetFileFlag( fhd, WFILE_INT );
		    SetFileFlag( fhd, WFILE_INCMD);
		}
	    }
	    else
		ShowMessage("Helpindex is invalid");
	}
	free(buffer);
    }
  #else
    buffer = xmalloc(300);
    sprintf(buffer, "cc;bl;ee;'load -j0 %s%s.hlp'excl;s ro",
		    CopyRight(21), CopyRight(13)  );
    err = Cmd_ExecuteString( buffer, ARGTYPE_STRING );
    free( buffer);
  #endif

    EnableHistoryUpdate(1);
    return err;
}
/*** bottom of file ***/
