/* [wedit4.c wk 3.10.91] W-Editor Operations 4
 *	Copyright (c) 1991 by Werner Koch (dd9jn)
 * This file is part of the W-Editor.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 *  set tabs , margins ...
 * History:
 * 03.01.93 wk	Removed unused vars
 */

#include "wtailor.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <wk/lib.h>
#include <wk/string.h>

#include "w.h"
#include "wcmdpr.h"
#include "wscreen.h"
#include "wfile.h"

/****** constants *********/
/******* typedefs ********/
/******* globals **********/
static const char whiteSpaces[] = " \t\n" ;

/******* prototypes *******/
/******* functions ********/
#if W_FULL
int Cmd_SetTabs( cmd_t *cmd )
{
    int err=0, n;
    char *varValue, *str, *nxt;
    ushort tabArray[MAX_TABS];
    ushort pos, lastpos;

    str = varValue = VarValue( cmd );
    str += strspn( str, whiteSpaces ); /* skip Blanks */
    if( !strncmp( str, "rpt ", 4 ) ) { /* special keyword */
	pos = atoi( str+4 );
	if( pos < 1 )
	    err = ERR_INVTAB;
	else {
	    for(n=0; n < MAX_TABS; n++ )
		tabArray[n] = pos * (n+1);
	}
    }
    else {
	lastpos = 1;
	for( n = 0; n < MAX_TABS  ; n++ ) {
	    pos = (int)strtol( str, &nxt, 0 );
	    if( pos <= lastpos ) {
		err = ERR_INVTAB;
		break;
	    }
	    lastpos = pos;
	    tabArray[n] = pos-1;
	    if( *nxt )
		str = nxt;
	    else {
		n++;
		break;
	    }
	}
    }

    if( !err )
	SetFilesTabSettings( QryScreenFile(), tabArray, n );

    FreeVarValue( varValue );
    return err;
}


void Cmd_QueryTabs()
{
    ushort tabArray[MAX_TABS];
    int i,cnt, rpt;
    char *buf;
    size_t n;

    cnt = GetFilesTabSettings( QryScreenFile() ,tabArray, MAX_TABS );
    rpt = 0;
    if( cnt == MAX_TABS ) {
	rpt = 1;
	for( i=1; i < cnt; i++ )
	    if( tabArray[i] - tabArray[i-1] != tabArray[0] ) {
		rpt = 0;
		break;
	    }
    }

    buf = xmalloc( MAX_LINELEN );
    strcpy( buf, "set tabs" );
    n = 8;
    if( rpt )
        sprintf( buf+n, " rpt %u", tabArray[0] );
    else {
	for(i=0; i < cnt ; i++ )
            n += sprintf( buf+n, " %u", tabArray[i]+1 );
    }
    Write2CurCmdLine( buf );
    free( buf );
}



int Cmd_SetMargins( cmd_t *cmd )
{
    int err=0, n;
    char *varValue, *str, *nxt;
    ushort marg[3];

    GetFilesMargins( QryScreenFile(), marg+0, marg+1, marg+2);
    str = varValue = VarValue( cmd );
    str += strspn( str, whiteSpaces ); /* skip Blanks */
    if( strcmpl( str, "default" ) ) {
	for( n=0; n < 3 && *str ; n++, str = nxt )
	    marg[n] = (int)strtol( str, &nxt, 0 )-1;
    }
    else {
	marg[0] = 0;
	marg[1] = MAX_LINELEN-1;
	marg[2] = 0;
	n=3;
    }
    FreeVarValue( varValue );

    if( !n || marg[1] <= marg[0] || marg[2]+1 >= marg[1] ||
	      marg[1] > MAX_LINELEN-1 )
	err = ERR_INVMRG;
    else
	SetFilesMargins( QryScreenFile(), marg[0], marg[1], marg[2]);

    return err;
}


void Cmd_QueryMargins()
{
    char *buf;
    ushort marg[3];

    GetFilesMargins( QryScreenFile(), marg+0, marg+1, marg+2);
    buf = xmalloc( 60 );
    sprintf( buf, "set margins %u %u %u", marg[0]+1, marg[1]+1, marg[2]+1 );
    Write2CurCmdLine( buf );
    free( buf );
}
#endif
/*** bottom of file ***/
