/* [wedit3.c wk 3.10.91] W-Editor Operations 3
 *	Copyright (c) 1991 by Werner Koch (dd9jn)
 * This file is part of the W-Editor.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Header: /usr/src/master/apps/w/src/wedit3.c,v 1.5 1996/09/10 12:20:04 wk Exp $
 *
 *  split / join
 */

#include "wtailor.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <wk/lib.h>
#include <wk/string.h>

#include "w.h"
#include "wcmdpr.h"
#include "wscreen.h"
#include "wfile.h"

/****** constants *********/
/******* typedefs ********/
/******* globals **********/
/******* prototypes *******/
/******* functions ********/


int Cmd_Split()
{
    int err=0, fhd;
    ushort pos, nbytes;
    const char *src;
    unsigned flags;

    fhd = QryScreenFile();
    GetFileInfo( fhd, &flags );
    if( flags & WFILE_INCMD )
	; /* no function in commandline */
    else {
	src = GetPtr2Line( fhd, &nbytes );
	GetFilePos( fhd, &pos );
	if( !(err = pos < nbytes ? Cmd_InsertLine( src+pos, nbytes-pos ):
				   Cmd_InsertLine( NULL, 0 ) )		) {
	    MoveUp( fhd, 1 );
	    Move2Column( fhd, pos );
	    err = Cmd_EraseEndLine();
	}
    }

    return err;
}



int Cmd_Join()
{
    int err=0, fhd;
    ushort pos, nsrc, ndst;
    ulong lnr, totlines;
    char *dst;
    const char *src;
    unsigned flags;

    fhd = QryScreenFile();
    GetFileInfo( fhd, &flags );
    lnr = GetFilePos( fhd, &pos );
    if( flags & WFILE_INCMD )
	; /* no function in commandline */
    else if( lnr+1 == (totlines=GetFileTotLines( fhd )) )
	;   /* no function in the last line */
    else {
	dst = GetEditBuf( fhd, &ndst );
	MoveDown( fhd, 1 );
	src = GetPtr2Line( fhd, &nsrc );
	xassert( ndst < MAX_LINELEN );
	if( ndst + nsrc > MAX_LINELEN-1 ) {
	    ShowMessage( GetErrorString(ERR_LTRUNC) );
	    nsrc = MAX_LINELEN-1-ndst;
	}
	memcpy( dst+ndst, src, nsrc );
	SetEditBuf( fhd, ndst + nsrc );
	if( !(err = Cmd_DeleteLine()) )
	    if( lnr+2 != totlines )
		MoveUp( fhd, 1 );
    }

    return err;
}

/*** bottom of file ***/
