/* [wcmdtbl.h wk 26.7.91] W-Editor CommandTable
 *	Copyright (c) 1991 by Werner Koch (dd9jn)
 * This file is part of the W-Editor.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Local to wcmd.c !!!
 *  contains: - Name of commands
 *	      - Default profile
 * History:
 * 05.02.93 wk	changed macro _dir_dir - will now switch to the directory
 * 15.05.93 wk	BEGIN_WORD, TAB_WORD now with arg
 */

#ifndef MODULE_WCMD
    #error This module is local to wcmd.c
#endif


static struct {
	const ushort cmd;
	const byte argtype;
	const byte flag;	/* 0 = n Woerter, keine Paramter */
				/* 1 = 1 Wort dann Paramter */
				/* 2 = 2 Woerter dann Paramter */
				/* 3 = 3 Woerter dann Paramter */
	const char *strg;	/* must be sorted by the first character */
				/* and in lowercase */
	byte  strgLen;		/* this will be filled in at runtime */
    } command[] = {
{ CMD_Q_ABBREV		 , ARGTYPE_NO	  , 0, "? abbrev"         },
{ CMD_Q_APPCTRLZ	 , ARGTYPE_NO	  , 0, "? appctrlz"       },
{ CMD_Q_AUTOLOCK	 , ARGTYPE_NO	  , 0, "? autolock"       },
{ CMD_Q_BACKUP		 , ARGTYPE_NO	  , 0, "? backup"         },
{ CMD_Q_BLANKSTRIP	 , ARGTYPE_NO	  , 0, "? blankstrip"     },
{ CMD_Q_CRTSAVE 	 , ARGTYPE_NO	  , 0, "? crtsave"        },
{ CMD_Q_DIR		 , ARGTYPE_NO	  , 0, "? dir"            },
{ CMD_Q_DISKSPACE	 , ARGTYPE_NO	  , 0, "? diskspace"      },
{ CMD_Q_HEAP		 , ARGTYPE_NO	  , 0, "? heap"           },
{ CMD_Q_HISTORY 	 , ARGTYPE_NO	  , 0, "? history"        },
{ CMD_Q_HSCROLL 	 , ARGTYPE_NO	  , 0, "? hscroll"        },
{ CMD_Q_KEY		 , ARGTYPE_KEY	  , 2, "? key"            },
{ CMD_Q_LOCKCHECK	 , ARGTYPE_NO	  , 0, "? lockcheck"      },
{ CMD_Q_MARGINS 	 , ARGTYPE_NO	  , 0, "? margins"        },
{ CMD_Q_MEMORY		 , ARGTYPE_NO	  , 0, "? memory"         },
{ CMD_Q_MEMSWAP 	 , ARGTYPE_NO	  , 0, "? memswap"        },
{ CMD_Q_PUREASCII	 , ARGTYPE_NO	  , 0, "? pureascii"      },
{ CMD_Q_SEARCHCASE	 , ARGTYPE_NO	  , 0, "? searchcase"     },
{ CMD_Q_TABEXPAND	 , ARGTYPE_NO	  , 0, "? tabexpand"      },
{ CMD_Q_TABS		 , ARGTYPE_NO	  , 0, "? tabs"           },
{ CMD_Q_ABBREV		 , ARGTYPE_NO	  , 0, "?a"               },
{ CMD_Q_BLANKSTRIP	 , ARGTYPE_NO	  , 0, "?b"               },
{ CMD_Q_DISKSPACE	 , ARGTYPE_NO	  , 0, "?d"               },
{ CMD_Q_TABEXPAND	 , ARGTYPE_NO	  , 0, "?e"               },
{ CMD_Q_HSCROLL 	 , ARGTYPE_NO	  , 0, "?h"               },
{ CMD_Q_BACKUP		 , ARGTYPE_NO	  , 0, "?k"               },
{ CMD_Q_MARGINS 	 , ARGTYPE_NO	  , 0, "?m"               },
{ CMD_Q_SEARCHCASE	 , ARGTYPE_NO	  , 0, "?s"               },
{ CMD_Q_TABS		 , ARGTYPE_NO	  , 0, "?t"               },
{ CMD_Q_MEMORY		 , ARGTYPE_NO	  , 0, "?y"               },
{ CMD_ASCII		 , ARGTYPE_NO	  , 0, "ascii"            },
{ CMD_ASSIGN		 , ARGTYPE_VAR	  , 0, "assign"           },
{ CMD_AUTOMARK		 , ARGTYPE_NO	  , 0, "automark"         },
{ CMD_BACKTAB_WORD	 , ARGTYPE_STRORVAR,2, "backtab word"     },
{ CMD_BACKTAB		 , ARGTYPE_NO	  , 0, "backtab"          },
{ CMD_BOTTOM_EDGE	 , ARGTYPE_NO	  , 0, "be"               },
{ CMD_BEEP		 , ARGTYPE_NO	  , 0, "beep"             },
{ CMD_BEGIN_LINE	 , ARGTYPE_NO	  , 0, "begin line"       },
{ CMD_BEGIN_MARK	 , ARGTYPE_NO	  , 0, "begin mark"       },
{ CMD_BEGIN_WORD	 , ARGTYPE_STRORVAR,2, "begin word"       },
{ CMD_BEGIN_LINE	 , ARGTYPE_NO	  , 0, "bl"               },
{ CMD_BEGIN_MARK	 , ARGTYPE_NO	  , 0, "bm"               },
{ CMD_BEGIN		 , ARGTYPE_NO	  , 0, "begin"            },
{ CMD_BOTTOM		 , ARGTYPE_NO	  , 0, "bo"               },
{ CMD_BOTTOM_EDGE	 , ARGTYPE_NO	  , 0, "bottom edge"      },
{ CMD_BOTTOM		 , ARGTYPE_NO	  , 0, "bottom"           },
{ CMD_BEEP		 , ARGTYPE_NO	  , 0, "bp"               },
{ CMD_BACKTAB		 , ARGTYPE_NO	  , 0, "bt"               },
{ CMD_BUG		 , ARGTYPE_STRORVAR,1, "bug"              },
{ CMD_BACKTAB_WORD	 , ARGTYPE_STRORVAR,1, "bw"               },
{ CMD_CHANGE		 , ARGTYPE_CHG	  , 1, "c"                },
{ CMD_CURSOR_DATA	 , ARGTYPE_NO	  , 0, "ca"               },
{ CMD_CALL		 , ARGTYPE_OP	  , 1, "call"             },
{ CMD_CANCEL_PROCESS	 , ARGTYPE_NUMBER , 2, "cancel job"       },
{ CMD_CANCEL_PROCESS	 , ARGTYPE_NUMBER , 2, "cancel process"   },
{ CMD_RECORD_CANCEL	 , ARGTYPE_NO	  , 0, "cancel recorder"  },
{ CMD_CURSOR_COMMAND	 , ARGTYPE_NO	  , 0, "cc"               },
{ CMD_CHDIR		 , ARGTYPE_FILE   , 1, "cd"               },
{ CMD_CLEAR_MESSAGE	 , ARGTYPE_NO	  , 0, "ce"               },
{ CMD_CENTER_IN_MARGINS  , ARGTYPE_NO	  , 0, "center in margins"},
{ CMD_CENTER_LINE	 , ARGTYPE_NO	  , 0, "center line"      },
{ CMD_COPY_FROM_COMMAND  , ARGTYPE_NO	  , 0, "cf"               },
{ CMD_COMMAND_TOGGLE	 , ARGTYPE_NO	  , 1, "cg"               },
{ CMD_CHANGE		 , ARGTYPE_CHG	  , 1, "change"           },
{ CMD_CHDIR		 , ARGTYPE_FILE   , 1, "chdir"            },
{ CMD_CENTER_IN_MARGINS  , ARGTYPE_NO	  , 0, "ci"               },
{ CMD_CLEAR_MARKS	 , ARGTYPE_NO	  , 0, "ck"               },
{ CMD_CENTER_LINE	 , ARGTYPE_NO	  , 0, "cl"               },
{ CMD_CLEAR_MARKS	 , ARGTYPE_NO	  , 0, "clear marks"      },
{ CMD_CLEAR_MESSAGE	 , ARGTYPE_NO	  , 0, "clear message"    },
{ CMD_COPY_MARK 	 , ARGTYPE_NO	  , 0, "cm"               },
{ CMD_CONFIRM_CHANGE	 , ARGTYPE_NO	  , 0, "co"               },
{ CMD_COLUMN		 , ARGTYPE_NUMBER , 1, "column"           },
{ CMD_COMMAND_TOGGLE	 , ARGTYPE_NO	  , 0, "command toggle"   },
{ CMD_CONFIRM_CHANGE	 , ARGTYPE_NO	  , 0, "confirm change"   },
{ CMD_COMMIT		 , ARGTYPE_NO	  , 0, "commit"           },
{ CMD_COPY_FROM_COMMAND  , ARGTYPE_NO	  , 0, "copy from command"},
{ CMD_COPY_MARK 	 , ARGTYPE_NO	  , 0, "copy mark"        },
{ CMD_COPY_TO_COMMAND	 , ARGTYPE_NO	  , 0, "copy to command"  },
{ CMD_COPY_TO_HISTORY	 , ARGTYPE_STRORVAR,3, "copy to history"  },
{ CMD_COPY		 , ARGTYPE_NO	  , 0, "copy"             },
{ CMD_CSTR		 , ARGTYPE_STRORVAR,1, "cstr"             },
{ CMD_COPY_TO_COMMAND	 , ARGTYPE_NO	  , 0, "ct"               },
{ CMD_CURSOR_COMMAND	 , ARGTYPE_NO	  , 0, "cursor command"   },
{ CMD_CURSOR_DATA	 , ARGTYPE_NO	  , 0, "cursor data"      },
{ CMD_CUT		 , ARGTYPE_NO	  , 0, "cut"              },
{ CMD_DEFINE		 , ARGTYPE_KEYDEF , 1, "d"                },
{ CMD_DELETE_CHAR	 , ARGTYPE_NUMBER , 0, "dc"               },
{ CMD_DEMO_END		 , ARGTYPE_NO	  , 0, "de"               },
{ CMD_DEFINE		 , ARGTYPE_KEYDEF , 1, "def"              },
{ CMD_DEFINE		 , ARGTYPE_KEYDEF , 1, "define"           },
{ CMD_DEFKEY		 , ARGTYPE_FILEORVAR,1,"defkey"           },
{ CMD_DELETE_CHAR	 , ARGTYPE_NUMBER , 0, "delete char"      },
{ CMD_DELETE_LINE	 , ARGTYPE_NO	  , 0, "delete line"      },
{ CMD_DELETE_MARK	 , ARGTYPE_NO	  , 0, "delete mark"      },
{ CMD_DEMO_END		 , ARGTYPE_NO	  , 0, "demo end"         },
{ CMD_DEMO_FAST 	 , ARGTYPE_NO	  , 0, "demo fast"        },
{ CMD_DEMO_KEYS 	 , ARGTYPE_NO	  , 0, "demo keys"        },
{ CMD_DEMO_SLOW 	 , ARGTYPE_NO	  , 0, "demo slow"        },
{ CMD_DEMO_FAST 	 , ARGTYPE_NO	  , 0, "df"               },
{ CMD_DIR		 , ARGTYPE_FILE   , 1, "dir"              },
{ CMD_DELETE_LINE	 , ARGTYPE_NO	  , 0, "dl"               },
{ CMD_DELETE_MARK	 , ARGTYPE_NO	  , 0, "dm"               },
{ CMD_DETACH		 , ARGTYPE_FILEORVAR,1,"detach"           },
{ CMD_DOS		 , ARGTYPE_FILEORVAR,1,"dos"              },
{ CMD_DOWN		 , ARGTYPE_NUMBER , 1, "down"             },
{ CMD_DEMO_SLOW 	 , ARGTYPE_NO	  , 0, "ds"               },
{ CMD_EDIT		 , ARGTYPE_FILEORVAR,1,"e"                },
{ CMD_ERASE_BEGIN_LINE	 , ARGTYPE_NO	  , 0, "eb"               },
{ CMD_EDIT		 , ARGTYPE_FILEORVAR,1,"edit"             },
{ CMD_EDITLIST		 , ARGTYPE_NO	  , 0, "editlist"         },
{ CMD_ERASE_END_LINE	 , ARGTYPE_NO	  , 0, "ee"               },
{ CMD_END_LINE		 , ARGTYPE_NO	  , 0, "el"               },
{ CMD_END_MARK		 , ARGTYPE_NO	  , 0, "em"               },
{ CMD_END_LINE		 , ARGTYPE_NO	  , 0, "end line"         },
{ CMD_END_MARK		 , ARGTYPE_NO	  , 0, "end mark"         },
{ CMD_END_WORD		 , ARGTYPE_STRORVAR,2, "end word"         },
{ CMD_END		 , ARGTYPE_NO	  , 0, "end"              },
{ CMD_ERASE_BEGIN_LINE	 , ARGTYPE_NO	  , 0, "erase begin line" },
{ CMD_ERASE_END_LINE	 , ARGTYPE_NO	  , 0, "erase end line"   },
{ CMD_ERASE		 , ARGTYPE_FILEORVAR, 1, "erase"          },
{ CMD_ERROR		 , ARGTYPE_NUMBER , 1, "error"            }, /*new*/
{ CMD_ESCAPE		 , ARGTYPE_NO	  , 0, "es"               },
{ CMD_ESCAPE		 , ARGTYPE_NO	  , 0, "escape"           },
{ CMD_EXECUTE		 , ARGTYPE_STRORVAR,0, "ex"               },
{ CMD_EXECUTECLEAR	 , ARGTYPE_NO	   ,0, "excl"             },
{ CMD_EXECUTE		 , ARGTYPE_STRORVAR,0, "execute"          },
{ CMD_EXIT		 , ARGTYPE_NO	  , 0, "exit"             },
{ CMD_FIND_BLANK_LINE	 , ARGTYPE_NO	  , 0, "fb"               },
{ CMD_FILE		 , ARGTYPE_FILEORVAR,1,"file"             },
{ CMD_FILL_MARK 	 , ARGTYPE_NO	  , 0, "fill mark"        },
{ CMD_FIND_BLANK_LINE	 , ARGTYPE_NO	  , 0, "find blank line"  },
{ CMD_FIRST_NONBLANK	 , ARGTYPE_NO	  , 0, "first nonblank"   },
{ CMD_FILL_MARK 	 , ARGTYPE_NO	  , 0, "fm"               },
{ CMD_FIRST_NONBLANK	 , ARGTYPE_NO	  , 0, "fn"               },
{ CMD_GOTO_LABEL	 , ARGTYPE_STRING , 1, "gb"               },
{ CMD_GOTO_LABEL	 , ARGTYPE_STRING , 2, "goto label"       },
{ CMD_GOTO_LINEID	 , ARGTYPE_NUMBER , 2, "goto lineid"      },
{ CMD_HELP		 , ARGTYPE_FILE   , 1, "help"             },
{ CMD_HISTORY		 , ARGTYPE_NO	  , 0, "history"          },
{ CMD_HISTORY_DOWN	 , ARGTYPE_NO	  , 0, "history down"     },
{ CMD_HISTORY_UP	 , ARGTYPE_NO	  , 0, "history up"       },
{ CMD_INSERT_LINE	 , ARGTYPE_NO	  , 0, "il"               },
{ CMD_INSERT_MODE	 , ARGTYPE_NO	  , 0, "im"               },
{ CMD_INDENT		 , ARGTYPE_NO	  , 0, "in"               },
{ CMD_INDENT		 , ARGTYPE_NO	  , 0, "indent"           },
{ CMD_INSERT_LINE	 , ARGTYPE_NO	  , 0, "insert line"      },
{ CMD_INSERT_MODE	 , ARGTYPE_NO	  , 0, "insert mode"      },
{ CMD_INSERT_TOGGLE	 , ARGTYPE_NO	  , 0, "insert toggle"    },
{ CMD_INSERT_TOGGLE	 , ARGTYPE_NO	  , 0, "it"               },
{ CMD_JMP		 , ARGTYPE_OP	  , 1, "jmp"              },
{ CMD_JOIN		 , ARGTYPE_NO	  , 0, "jo"               },
{ CMD_JOIN		 , ARGTYPE_NO	  , 0, "join"             },
{ CMD_KEY		 , ARGTYPE_KEY	  , 1, "key"              },
{ CMD_KEYDEFS		 , ARGTYPE_NO	  , 0, "keydefs"          },
{ CMD_KILL_PROCESS	 , ARGTYPE_NUMBER , 2, "kill job"         },
{ CMD_KILL_PROCESS	 , ARGTYPE_NUMBER , 2, "kill process"     },
{ CMD_LOAD		 , ARGTYPE_FILEORVAR,1,"load"             },
{ CMD_LOCATE		 , ARGTYPE_LOC	  , 1, "l"                },
{ CMD_LOWERCASE 	 , ARGTYPE_NO	  , 0, "lc"               },
{ CMD_LEFT_EDGE 	 , ARGTYPE_NO	  , 0, "le"               },
{ CMD_LEAP_TO		 , ARGTYPE_STRORVAR,2, "leap to"          },
{ CMD_LEFT_EDGE 	 , ARGTYPE_NO	  , 0, "left edge"        },
{ CMD_LEFT_MARGIN	 , ARGTYPE_NO	  , 0, "left margin"      },
{ CMD_LEFT		 , ARGTYPE_NUMBER , 1, "left"             },
{ CMD_LEFT_MARGIN	 , ARGTYPE_NO	  , 0, "lg"               },
{ CMD_LINE		 , ARGTYPE_NUMBER , 1, "line"             },
{ CMD_LOCATE		 , ARGTYPE_LOC	  , 1, "locate"           },
{ CMD_LOCK		 , ARGTYPE_NO	  , 0, "lock"             },
{ CMD_LOWERCASE 	 , ARGTYPE_NO	  , 0, "lowercase"        },
{ CMD_MACRO		 , ARGTYPE_FILEORVAR,1,"m"                },
{ CMD_MACRO		 , ARGTYPE_FILEORVAR,1,"macro"            },
{ CMD_MARK_BLOCK	 , ARGTYPE_NO	  , 0, "mark block"       },
{ CMD_MARK_CHAR 	 , ARGTYPE_NO	  , 0, "mark char"        },
{ CMD_MARK_LINE 	 , ARGTYPE_NO	  , 0, "mark line"        },
{ CMD_MATCHBLOCK	 , ARGTYPE_NO	  , 0, "matchblock"       },
{ CMD_MARK_BLOCK	 , ARGTYPE_NO	  , 0, "mb"               },
{ CMD_MARK_CHAR 	 , ARGTYPE_NO	  , 0, "mc"               },
{ CMD_MARK_LINE 	 , ARGTYPE_NO	  , 0, "ml"               },
{ CMD_MOVE_MARK 	 , ARGTYPE_NO	  , 0, "mm"               },
{ CMD_MOVE_MARK 	 , ARGTYPE_NO	  , 0, "move mark"        },
{ CMD_NAME		 , ARGTYPE_FILE   , 1, "n"                },
{ CMD_NAME		 , ARGTYPE_FILE   , 1, "name"             },
{ CMD_NEXT_BLANK	 , ARGTYPE_NO	  , 0, "nb"               },
{ CMD_NEW		 , ARGTYPE_FILEORVAR,1,"new"              },
{ CMD_NEXT_BLANK	 , ARGTYPE_NO	  , 0, "next blank"       },
{ CMD_NEXT_NONBLANK	 , ARGTYPE_NO	  , 0, "next nonblank"    },
{ CMD_NEXT_VIEW 	 , ARGTYPE_NO	  , 0, "next view"        },
{ CMD_NEXT_WINDOW	 , ARGTYPE_NO	  , 0, "next window"      },
{ CMD_NEXT_NONBLANK	 , ARGTYPE_NO	  , 0, "nnb"              },
{ CMD_NOERROR		 , ARGTYPE_NO	  , 0, "noerror"          }, /*new*/
{ CMD_NOP		 , ARGTYPE_NO	  , 0, "nop"              }, /*new*/
{ CMD_NEXT_VIEW 	 , ARGTYPE_NO	  , 0, "nv"               },
{ CMD_NEXT_WINDOW	 , ARGTYPE_NO	  , 0, "nw"               },
{ CMD_OVERLAY_BLOCK	 , ARGTYPE_NO	  , 0, "ob"               },
{ CMD_OVERLAY_BLOCK	 , ARGTYPE_NO	  , 0, "overlay block"    },
{ CMD_PAGE_DOWN 	 , ARGTYPE_NO	  , 0, "page down"        },
{ CMD_PAGE_UP		 , ARGTYPE_NO	  , 0, "page up"          },
{ CMD_PARAGRAPH_MARGIN	 , ARGTYPE_NO	  , 0, "paragraph margin" },
{ CMD_PASTE		 , ARGTYPE_NO	  , 0, "paste"            },
{ CMD_PAUSE		 , ARGTYPE_NUMBER , 0, "pause"            },
{ CMD_PAGE_DOWN 	 , ARGTYPE_NO	  , 0, "pd"               },
{ CMD_PUTENV		 , ARGTYPE_STRING , 1, "pe"               }, /* new */
{ CMD_PARAGRAPH_MARGIN	 , ARGTYPE_NO	  , 0, "pg"               },
{ CMD_PLAY_MARK 	 , ARGTYPE_NO	  , 0, "play mark"        },
{ CMD_PRINT_MARK	 , ARGTYPE_NO	  , 0, "pm"               },
{ CMD_POP_MARK		 , ARGTYPE_NO	  , 0, "po"               },
{ CMD_POP_MARK		 , ARGTYPE_NO	  , 0, "pop mark"         },
{ CMD_POSATMOUSE	 , ARGTYPE_NO	  , 0, "posatmouse"       },
{ CMD_PRINT		 , ARGTYPE_NO	  , 0, "pr"               },
{ CMD_PRINT_MARK	 , ARGTYPE_NO	  , 0, "print mark"       },
{ CMD_PRINT		 , ARGTYPE_NO	  , 0, "print"            },
{ CMD_PUSH_MARK 	 , ARGTYPE_NO	  , 0, "ps"               },
{ CMD_PAGE_UP		 , ARGTYPE_NO	  , 0, "pu"               },
{ CMD_PUSH_MARK 	 , ARGTYPE_NO	  , 0, "push mark"        },
{ CMD_PUT		 , ARGTYPE_STRING , 1, "put"              }, /* new */
{ CMD_PUTENV		 , ARGTYPE_STRING , 1, "putenv"           }, /* new */
{ CMD_QUIT		 , ARGTYPE_NO	  , 0, "q"                },
{ CMD_QUIT		 , ARGTYPE_NO	  , 0, "quit"             },
{ CMD_REDRAW		 , ARGTYPE_NO	  , 0, "rd"               },
{ CMD_RIGHT_EDGE	 , ARGTYPE_NO	  , 0, "re"               },
{ CMD_REDRAW		 , ARGTYPE_NO	  , 0, "redraw"           },
{ CMD_REEDIT		 , ARGTYPE_FILEORVAR,1,"reedit"           },
{ CMD_REFLOW		 , ARGTYPE_NO	  , 0, "reflow"           },
{ CMD_REHASH		 , ARGTYPE_NO	  , 0, "rehash"           },
{ CMD_REPLACE_MODE	 , ARGTYPE_NO	  , 0, "replace mode"     },
{ CMD_REFLOW		 , ARGTYPE_NO	  , 0, "rf"               },
{ CMD_RIGHT_MARGIN	 , ARGTYPE_NO	  , 0, "rg"               },
{ CMD_RIGHT_EDGE	 , ARGTYPE_NO	  , 0, "right edge"       },
{ CMD_RIGHT_MARGIN	 , ARGTYPE_NO	  , 0, "right margin"     },
{ CMD_RIGHT		 , ARGTYPE_NUMBER , 1, "right"            },
{ CMD_RING		 , ARGTYPE_ONOFF  , 1, "ring"             },
{ CMD_REPLACE_MODE	 , ARGTYPE_NO	  , 0, "rm"               },
{ CMD_RUBOUT		 , ARGTYPE_NO	  , 0, "ro"               },
{ CMD_RUBOUT		 , ARGTYPE_NO	  , 0, "rubout"           },
{ CMD_SET_NOTABS	 , ARGTYPE_ONOFF  , 2, "s nt"             },
{ CMD_SET_RO		 , ARGTYPE_NO	  , 0, "s ro"           },
{ CMD_SET_RW		 , ARGTYPE_NO	  , 0, "s rw"           },
{ CMD_SET_SUPSCREEN	 , ARGTYPE_ONOFF  , 2, "s sps"          },
{ CMD_SET_TABS		 , ARGTYPE_FILE   , 2, "s tabs"         },
{ CMD_SAVE		 , ARGTYPE_FILEORVAR,1,"save"             },
{ CMD_SET_LABEL 	 , ARGTYPE_STRING , 1, "sb"               },
{ CMD_SCROLLDOWN	 , ARGTYPE_NUMBER , 0, "scrolldown"       },
{ CMD_SCROLLLEFT	 , ARGTYPE_NUMBER , 0, "scrollleft"       },
{ CMD_SCROLLRIGHT	 , ARGTYPE_NUMBER , 0, "scrollright"      },
{ CMD_SCROLLUP		 , ARGTYPE_NUMBER , 0, "scrollup"         },
{ CMD_SHOW_COPYING	 , ARGTYPE_NO	  , 0, "show copying"     },
{ CMD_SHOW_PROCESS	 , ARGTYPE_NUMBER , 2, "show job"         },
{ CMD_SHOW_PROCESS	 , ARGTYPE_NUMBER , 2, "show process"     },
{ CMD_SHOW_WARRANTY	 , ARGTYPE_NO	  , 0, "show warranty"    },
{ CMD_SET_ABBREV	 , ARGTYPE_ONOFF  , 2, "set abbrev"       },
{ CMD_SET_APPCTRLZ	 , ARGTYPE_ONOFF  , 2, "set appctrlz"     },
{ CMD_SET_AUTOLOCK	 , ARGTYPE_ONOFF  , 2, "set autolock"     },
{ CMD_SET_BACKUP	 , ARGTYPE_NUMBER , 2, "set backup"       },
{ CMD_SET_BLANKSTRIP	 , ARGTYPE_ONOFF  , 2, "set blankstrip" },
{ CMD_SET_DCOLORS	 , ARGTYPE_FILE   , 2, "set color"      },
{ CMD_SET_CRTSAVE	 , ARGTYPE_NUMBER , 2, "set crtsave"    },
{ CMD_SET_DISPLAY	 , ARGTYPE_STRING , 2, "set display"      },
{ CMD_SET_DLAYOUT	 , ARGTYPE_NUMBER , 2, "set dlayout"      },
{ CMD_SET_DCOLORS	 , ARGTYPE_FILE   , 2, "set dcolors"      },
{ CMD_SET_HILITE	 , ARGTYPE_FILE   , 2, "set hilite"       },
{ CMD_SET_HISTORY	 , ARGTYPE_NUMBER , 2, "set history"      },
{ CMD_SET_HSCROLL	 , ARGTYPE_ONOFF  , 2, "set hscroll"      },
{ CMD_SET_IGNORE_BACKUPS , ARGTYPE_ONOFF  , 3, "set ignore backups" },
{ CMD_SET_INTCLIP	 , ARGTYPE_ONOFF  , 2, "set intclip"      },
{ CMD_SET_KEYPREFIX	 , ARGTYPE_STRING , 2, "set keyprefix"    },
{ CMD_SET_LABEL 	 , ARGTYPE_STRING , 2, "set label"        },
{ CMD_SET_LATIN 	 , ARGTYPE_ONOFF  , 2, "set latin"        },
{ CMD_SET_LOCKCHECK	 , ARGTYPE_ONOFF  , 2, "set lockcheck"    },
{ CMD_SET_MARGINS	 , ARGTYPE_FILE   , 2, "set margins"      },
{ CMD_SET_MEMSWAP	 , ARGTYPE_ONOFF  , 2, "set memswap"      },
{ CMD_SET_NOTABS	 , ARGTYPE_ONOFF  , 2, "set notabs"       },
{ CMD_SET_PUREASCII	 , ARGTYPE_ONOFF  , 2, "set pureascii"    },
{ CMD_SET_READBINARY	 , ARGTYPE_ONOFF  , 2, "set readbinary"   },
{ CMD_SET_REFRESH	 , ARGTYPE_NUMBER , 2, "set refresh"      },
{ CMD_SET_RO		 , ARGTYPE_NO	  , 0, "set readonly"     },
{ CMD_SET_RW		 , ARGTYPE_NO	  , 0, "set readwrite"    },
{ CMD_SET_RO		 , ARGTYPE_NO	  , 0, "set ro"           },
{ CMD_SET_RW		 , ARGTYPE_NO	  , 0, "set rw"           },
{ CMD_SET_SAVEMODE	 , ARGTYPE_NUMBER , 2, "set savemode"     },
{ CMD_SET_SEARCHCASE	 , ARGTYPE_ANYEXA , 2, "set searchcase"   },
{ CMD_SET_SUPSCREEN	 , ARGTYPE_ONOFF  , 2, "set supscreen"    },
{ CMD_SET_TABEXPAND	 , ARGTYPE_ONOFF  , 2, "set tabexpand"    },
{ CMD_SET_TABMODE	 , ARGTYPE_NUMBER , 2, "set tabmode"      },
{ CMD_SET_TABS		 , ARGTYPE_FILE   , 2, "set tabs"         },
{ CMD_SET_UNIXSAVE	 , ARGTYPE_ONOFF  , 2, "set unixsave"     },
{ CMD_SET_EDITCMD	 , ARGTYPE_ONOFF  , 2, "set editcmd"      },
{ CMD_SHIFT_LEFT	 , ARGTYPE_NO	  , 0, "shift left"       },
{ CMD_SHIFT_RIGHT	 , ARGTYPE_NO	  , 0, "shift right"      },
{ CMD_SHIFT_LEFT	 , ARGTYPE_NO	  , 0, "sl"               },
{ CMD_SORT		 , ARGTYPE_STRORVAR,1, "sort"             },
{ CMD_SPLIT_SCREEN	 , ARGTYPE_NO	  , 0, "split screen"     },
{ CMD_SPLIT		 , ARGTYPE_NO	  , 0, "split"            },
{ CMD_SHOW_PROCESS	 , ARGTYPE_NUMBER , 1, "sp"               },
{ CMD_SHIFT_RIGHT	 , ARGTYPE_NO	  , 0, "sr"               },
{ CMD_SPLIT_SCREEN	 , ARGTYPE_NO	  , 0, "ss"               },
{ CMD_STRIPBLANKS	 , ARGTYPE_NO	  , 0, "stripblanks"      },
{ CMD_RECORD_START	 , ARGTYPE_KEYDEF , 2, "start recorder"   },
{ CMD_RECORD_STOP	 , ARGTYPE_NO	  , 0, "stop recorder"    },
{ CMD_SWITCH_CONSOLE	 , ARGTYPE_NUMBER , 2, "switch console"   },
{ CMD_TAB_WORD		 , ARGTYPE_STRORVAR,2, "tab word"         },
{ CMD_TAB		 , ARGTYPE_NO	  , 0, "tab"              },
{ CMD_TAB		 , ARGTYPE_NO	  , 0, "tb"               },
{ CMD_TOP_EDGE		 , ARGTYPE_NO	  , 0, "te"               },
{ CMD_TOGGLE		 , ARGTYPE_NO	  , 0, "toggle"           },
{ CMD_TOP		 , ARGTYPE_NO	  , 0, "to"               },
{ CMD_TOP_EDGE		 , ARGTYPE_NO	  , 0, "top edge"         },
{ CMD_TOP		 , ARGTYPE_NO	  , 0, "top"              },
{ CMD_TREE		 , ARGTYPE_NO	  , 0, "tree"             },
{ CMD_TAB_WORD		 , ARGTYPE_STRORVAR,1, "tw"               },
{ CMD_UPPERCASE 	 , ARGTYPE_NO	  , 0, "uc"               },
{ CMD_UNDO		 , ARGTYPE_NO	  , 0, "ud"               },
{ CMD_UNMARK		 , ARGTYPE_NO	  , 0, "um"               },
{ CMD_UNDO		 , ARGTYPE_NO	  , 0, "undo"             },
{ CMD_UNLOCK		 , ARGTYPE_NO	  , 0, "unlock"           },
{ CMD_UNMARK		 , ARGTYPE_NO	  , 0, "unmark"           },
{ CMD_UNTIL		 , ARGTYPE_OP	  , 1, "until"            },
{ CMD_UP		 , ARGTYPE_NUMBER , 1, "up"               },
{ CMD_UPPERCASE 	 , ARGTYPE_NO	  , 0, "uppercase"        },
{ CMD_VARLIST		 , ARGTYPE_NO	  , 0, "varlist"          },
{ CMD_VIEW		 , ARGTYPE_FILEORVAR,1,"view"             },
{ CMD_BEGIN_WORD	 , ARGTYPE_STRORVAR,1, "wb"               },
{ CMD_END_WORD		 , ARGTYPE_STRORVAR,1, "we"               },
{ CMD_WHILE		 , ARGTYPE_OP	  , 1, "while"            },
{ CMD_ZOOM_WINDOW	 , ARGTYPE_NO	  , 0, "zoom window"      },
{ CMD_ZOOM_WINDOW	 , ARGTYPE_NO	  , 0, "zw"               },
{ 0			 , 0		  , 0, NULL   }  };



static struct {
	const char *name;
	const byte len;
	const byte code;
    } operatorTbl[] = {
      #if W_FULL
	{ "eq"   , 2 , OPERATOR_EQ    },
	{ "ne"   , 2 , OPERATOR_NE    },
	{ "lt"   , 2 , OPERATOR_LT    },
	{ "le"   , 2 , OPERATOR_LE    },
	{ "gt"   , 2 , OPERATOR_GT    },
	{ "ge"   , 2 , OPERATOR_GE    },
	{ "true" , 4 , OPERATOR_TRUE  },
	{ "false", 5 , OPERATOR_FALSE },
	{ "add"  , 3 , OPERATOR_ADD   },
	{ "sub"  , 3 , OPERATOR_SUB   },
	{ "mlt"  , 3 , OPERATOR_MLT   },
	{ "div"  , 3 , OPERATOR_DIV   },
	{ "mod"  , 3 , OPERATOR_MOD   },
	{ "len"  , 3 , OPERATOR_LEN   },
	{ "dup"  , 3 , OPERATOR_DUP   },
	{ "evl"  , 3 , OPERATOR_EVL   },
	{ "same" , 4 , OPERATOR_SAME  },
	{ "diff" , 4 , OPERATOR_DIFF  },
	{ "sameCI", 6 , OPERATOR_SAMECI  },
	{ "diffCI", 6 , OPERATOR_DIFFCI  },
	{ "cat"  , 3 , OPERATOR_CAT   },
	{ "pop"  , 3 , OPERATOR_POP   },
	{ "clear", 5 , OPERATOR_CLEAR },
	{ "tpath", 5 , OPERATOR_TPATH },
	{ "swap" , 4 , OPERATOR_SWAP  },
	{ "val"  , 3 , OPERATOR_VAL   },
	{ "valx" , 4 , OPERATOR_VALX  },
	{ "valb" , 4 , OPERATOR_VALB  },
	{ "hex"  , 3 , OPERATOR_HEX   },
	{ "bin"  , 3 , OPERATOR_BIN   },
	{ "julian",6 , OPERATOR_JULIAN},
	{ "daytime",7 , OPERATOR_TMOFDAY},
	{ "getword",7 , OPERATOR_GETWORD},
	{ "exist"  ,5 , OPERATOR_EXIST},
	{ "ineditor" ,8 , OPERATOR_INEDITOR},
      #endif
	{ NULL	 , 0 , 0  }  }; /* end of table marker */




/*** default Profile ****/

static const char *defaultMacros[] = {
    "set abbrev on",
    "set tabexpand on",
    "set readbinary on",
  #if W_FULL
    "set lockcheck on",
    "set backup 100",
  #endif
    "set blankstrip on",
    "set editcmd on",
    "d up=up",
    "d down=down",
    "d left=left",
    "d right=right",
    "d pgup=pu",
    "d pgdn=pd",
    "d home=bl",
    "d end=el",
    "d ins=it",
    "d del=dc",
    "d esc=cg",
    "d tab=tb",
    "d c-home=to",
    "d c-end=bo",
    "d c-enter=ex",
    "d s-up=scrollup",
    "d s-down=scrolldown",
    "d s-left=scrollleft",
    "d s-right=scrollright",
    "d s-pgup=te",
    "d s-pgdn=be",
    "d s-home=le",
    "d s-end=re",
    "d s-ins=ud",
    "d s-tab=bt",
    "d s-f10=dl",
  #if W_FULL
    "d enter=bl;down;indent",
  #else
    "d enter=bl;down",
  #endif
    "d backspace=rubout",
    "d f1=help",
    "d f2=cc;bl;ee;'save '",
    "d f3=cc;bl;ee;'file '",
    "d f4=quit",
    "d f5=co;ex",
    "d f8=e;",
    "d f9=escape",
    "d f10=il",
    "d c-f9=rd",
    "d a-f1=um;ml",
    "d a-f2=ml",
    "d a-f3=um;mb",
    "d a-f4=mb",
    "d a-f5=ca;bm;dm;up",
    "d a-f6=ob",
    "d a-f7=cm",
    "d a-f8=mm",
    "d a-f9=um",
    "d a-f10=um;wb;mb;we;mb;bm",
    "d c-l=sb",
    "d c-g=gb",
  #if W_FULL
    "d lclick=posatmouse;:%ZPath:'.dir'jmp same;key c-e",
    "d s-lclick=posatmouse;el",
    "d rclick=posatmouse;um;mb;automark",
    "d s-rclick=posatmouse;um;ml;automark",
    "d _loadatcrs=:'load ':%ZDir^cat:';=(){}[]>|<%\"?*':\"'\"^cat;"
				 "wb %ZCtop;^getword^cat;ex %ZCpop",
    "d _dir_dir=cc;ct;bl;dc 30;im; 'dir ' %ZDir excl;ca;"
			     ":'cd ':%ZDir^cat;ex %ZCpop",
    "d _dir_load=cc;ct;bl;dc 30;im; 'load ' %ZDir;ca;column 30;excl",
    "d _dir=:'.dir':%ZPath;jmp diff e .dir; "
	   "ca;column 22;:%ZChrAtCrs :'<' jmp same; _dir_dir; _dir_load",
    "d c-e=_dir",
  #else
    "d f6 =cc; bl; ee;'line '",
    "d f7 =cc; bl; ee;'/'",
    "d padminus =bw;",
    "d padplus =tw;",
    "d s-f1 =wb;",
    "d s-f2 =we;",
    "d s-f3 =ca; sp; il; up; el; down; left;' ' jo; up;",
    "d s-f4 =ee; bl; down; im;' ' left; um; mb; fn; left; mb; dm; rm; up; el; jo;",
    "d s-f5 =bl; ee",
    "d s-f6 =ee",
    "d s-f7 =sl",
    "d s-f8 =sr",
    "d c-c = ps; ml; ci; um; po",
    "d c-f = cf",
    "d c-i = bm; sr; up; left; cc; bl; ee; im;'c/ //*M' column 5",
    "d c-j = ps; down; fn; mb; el; we; mb; up; el; we; right; cm; down; um; dl; up; po",
    "d c-k = ee",
    "d c-t = ct",
    "d c-y = dl",
    "d c-f3 = ps; ml; cm; po",
    "d c-f4 = fm",
    "d c-f5 = uc",
    "d c-f6 = bm",
    "d c-f7 = lc",
    "d c-f8 = em",
    "d c-f10 = rf",
    "d c-left = left 40",
    "d c-right = right 40",
    "d c-pgup = scrollup 10",
    "d c-pgdn = scrolldown 10",
    "d c-backspace =  ps; mb; nb; nnb; sp; bm; ee; jo; po",
  #endif
    NULL };


/*** bottom of header file ***/
