/* [w.h wk 2.7.91] Defs for W
 *	Copyright (c) 1991 by Werner Koch (dd9jn)
 * This file is part of the W-Editor.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Header: /usr/src/master/apps/w/src/w.h,v 1.7 1998/02/10 10:52:21 wk Exp $
 * Global definitions
 */

#ifndef HDR_W
#define HDR_W 1
#if __cplusplus
extern "C" {
#endif


#include "werr.h"

#define W_FULL 1   /* standard */
#if W_MINI	   /* Small W wanted */
    #undef W_FULL  /* so reset W-FULL indicator */
    #define NDEBUG 1	/* no asserts */
#endif

#if W_FULL
#if __ZTC__	/* DGROUP > 64K problem */
  #define MAX_FILES    25
#else
  #define MAX_FILES    30
#endif
#define MAX_SCREENS  1
#if OS20 || DOS386 || UNIX
  #define MAX_LINELEN  1026
#elif OS2 && !__ZTC__
  #define MAX_LINELEN  1026
#else
  #define MAX_LINELEN  514
#endif
#define MAX_TABS     25     /* max. number of tab positions */
#else
#define MAX_FILES    3
#define MAX_SCREENS  1
#define MAX_LINELEN  512
#define MAX_TABS     10     /* max. number of tab positions */
#endif

/*** globals ****/
volatile int sigIntPending;
int demoModeFlag;

/*** prototypes ***/
int  SwitchCPForMode( int mode );
void DemoProcess(void);
const char *GetErrorString( int n );
void Try2AllocReservedMemory(void);
int QryReservedMemoryState(void);
int SigIntPoll(void);

    /*-- w.c --*/
#ifdef UNIX
  char **GetEnvironmentArray(void);
#endif

    /*-- whack.c --*/
int HackerCheck(int mode);
int RegistrationCheck(void);
const char *RegistrationText(void);

    /*-- wdos.c --*/
const char *GetDirPattern(void);

    /*-- wvar.c --*/
const char *GetWordDelimiters(void);

#if __cplusplus
}
#endif
#endif /* HDR_W */
