/* [w.c wk 2.7.91] W-Editor main
 *	Copyright (c) 1991-94 by Werner Koch (dd9jn)
 * This file is part of the W-Editor.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 * History:
 *  9.05.92 wk	Neue Version 1.02
 * 11.05.92 wk	Neue Version 1.02a (only OS/2 and DOSX)
 * 18.12.92 wk	Neue Version 1.05d (OS/2 and MSDOS)
 * 04.04.93 wk	Version 1.06d (1.06c zeigte unter OS2 keine DIRs mehr an)
 * 10.06.93 wk	Removed all that registering stuff, now published under
 *		the GNU GPL = Version 1.10.
 * 20.06.93 wk	Now uses VARLIST as scratch file
 * 14.08.93 wk	added option quiet to support TINYW
 */


#include "wtailor.h"
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include <wk/lib.h>
#include <wk/file.h>
#include <wk/keys.h>
#include <wk/string.h>
#include <wk/io.h>
#if !__IBMC__ && !__GNUC__
#include <dos.h>  /* for _osmajor */
#endif

#include "version.h"
#include "w.h"   /* unbedingt hier, da einige Konstanten definiert */

#include <wk/environ.h>
#if !OS2
   #include <wk/wscrdrv.h>
#endif
#if __ZTC__    /* works on all platforms */
  #include <controlc.h>

  #if DOS386 /* da ist was falsch definiert ! */
    #define _cerror_handler cerror_handler
  #endif
  #include <cerror.h>

  #include <bios.h>
  #if !DOS386 && W_FULL /* da klappt was nicht */
      #define USE_CRITERR_HANDLER 1
  #endif
  #if !MSDOS && !DOS386 && !DOS16RM  /* This is OS/2 or UNIX */
    #define ShowMessageViaBios ShowMessage
  #endif
#endif
#include <wk/environ.h>

#ifdef UNIX
#include "jnx.h"
#endif

#include "wfile.h"
#include "wscreen.h"
#include "wcmd.h"
#include "wkbddrv.h"

/****** constants *********/
/******** typedefs ********/
/******* globals **********/

volatile int sigIntPending=0;	/* allocate it here */
int demoModeFlag=0;		/* allocate it here */
static void *reservedMemoryBlock=NULL;	/* for panic */
static char loadDirectory[F_MAX_PATH];
#if __ZTC__
static int controlCHandlerState; /* true = open */
#endif
static int orgCodePage;
#ifdef UNIX
static int lookForRemote;
#endif


static struct {
	char *profile;
	int prfFlag;
	int mac;
	int i24;
	int iso8859;
	int blackWhite;
	int verfexit;
	int noenvcheck;
	int quiet;
	int debugscans;
      #ifdef UNIX
	int xwindows;	/* run in xwindows mode */
	int console;	/* run in console mode */
      #endif
    } opt ;

/******* prototypes *******/
static void CleanUp( void *dummy );
static void Editor( void );
static void AutoRefresh(int);
static void SetSigIntHandler(void);
#if __ZTC__
  static void ControlCHandler(void);
  int _far CritErrHandler( int *regAX, int *regDI );
#else
  static void SigIntHandler( int val );
#endif
static int XAllocFailure( size_t needed );
/******* functions ********/

const char *
CopyRight( int level )
{
    const char *p;
    switch( level ) {
      case 15:
      case 10:	p =
		  #if W_FULL
		    "W-Editor"
		  #else
		    "W-Minimal-Editor"
		  #endif
		    " v" VERSION
		    "; Copyright (C) 1991-96,98 by Werner Koch (dd9jn)" ; break;
      case 14:	p =   VERSION ; break;
      case 11:	p = "Usage: w [options] [files] (-h for help)";
		break;
      case 12:	p =
    "\nSyntax: w [options] [file]\n\n"
  #if W_FULL
    "Programmers File Editor\n"
  #else
    "Minimal source file editor\n"
  #endif
    "Options summary:\n"
  #ifdef UNIX
    " -X       = run in X-Windows mode\n"
    " -C       = run in Console mode\n"
  #endif
  #if W_FULL
    " -p<name> = use name as profile instead of w.pro\n"
    " -P<name> = same as -p but read file from load Directory\n"
    " -m       = use the commandline args as macros\n"
  #ifdef __linux__
    " -8       = assume ISO 8859-1 console character set\n"
  #else
    " -8       = use ISO 8859-1 character set\n"
  #endif
    " -ws      = use WS-like emulation\n"
    " -l<dir>  = set loaddirectory to dir\n"
    " -ne      = no environment check\n"
  #endif
    " -v       = request exit confirmation\n"
    " -b       = force black & white mode\n"
    " -q       = quiet (do not print copyright message)\n"
    " -Jdbgscan = print keyboard scancodes on stderr\n"
    " --       = stop option processing\n"
    " -h       = help\n";
	break;
  #if W_FULL
      case 13:	p = "w"; break;
  #else
      case 13:	p = "wmini"; break;
  #endif
      case 21:	p = loadDirectory; break;
      case 31: p =
    "W comes with ABSOLUTELY NO WARRANTY; for details type `show warranty'.\n"
    "This is free software, and you are welcome to redistribute it\n"
    "under certain conditions; type `show copying' for details.\n";
	    break;
      case 32: p = "["
	  #if MSDOS
	    #if USE_EMS
	      "MSDOS Version with EMS support"
	    #elif __ZTC__
	      "MSDOS Version with memory swapping"
	    #else
	      "MSDOS Version"
	    #endif
	  #elif DOS386 && __ZTC__
	    "32-Bit MSDOS Version (Zortech's DOSX)"
	  #elif DOS386
	    "32-Bit MSDOS Version"
	  #elif OS20
	    "OS/2 2.x Version"
	  #elif OS2
	    "OS/2 1.x Version"
	  #elif EMX
	    "EMX Version"
	  #elif WINNT
	    "Windoze NT Version"
	  #elif DOS16RM
	    "DOS16RM Version"
	  #elif __linux__
	    "Linux Version"
	  #elif HPUX
	    "HP-UX"
	  #elif M_UNIX || M_XENIX || UNIX
	    "Generic UNIX Version"
	  #endif
	    "]";
	    break;

      default:	p = WklibCopyRight(level);
    }
    ShowCopyRight(level);
    return p;
}

#ifdef UNIX
static void
Die(int x)
{
    fprintf(stderr, "caught signal %d, cleaning up...\n", x);
    exit(3);
}

static void
FlagRemote(int x)
{
    signal(SIGUSR1, FlagRemote);
    lookForRemote = 1;
}



/****************
 * This is only used to interrupt the XNextEvent, no real action is performed
 */
static void
AlarmHandler(int x)
{
    signal(SIGALRM,AlarmHandler);
}
#endif

int
main( int argc, char **argv )
{
    char  *s ;
    int  err=0, loadDirFlag, i;
  #ifdef UNIX
    int have_xargs;
  #endif
    char *pgmname;

    Enter_Main();
    if( ArgExpand( &argc, &argv, 4 | 1 ) )
	Error(4,GetStr(12));

    ErrorStream(stderr);
  #ifdef UNIX
    strcpy( loadDirectory, "/usr/local/lib/w-edit/" );
  #else
    strcpy( loadDirectory, *argv ? *argv: "" );
  #endif
    loadDirFlag = 0;

  #ifdef UNIX
    have_xargs = argc;
    JnxParseArgs( &argc, &argv );
    have_xargs = argc != have_xargs;
  #endif

    pgmname = argc? *argv : NULL;
    if( pgmname && (s=strrchr(pgmname,'/')) )
	pgmname = s+1;
    if( argc && *argv )
	for( s=""; --argc && **++argv == '-' && *s != '-'; )
	    for( s = *argv + 1 ; *s && *s != '-' ; s++ )
		switch( *s ) {
		  #ifdef UNIX
		    case 'X': opt.xwindows++; break;
		    case 'C': opt.console++; break;
		  #endif
		 #if W_FULL
		  case 'n' : if( s[1] == 'e' ) {
			opt.noenvcheck++;
			s++;
		    }
		    else
			Error(3,GetStr(15),s );
		    break;

		  case 'P' : opt.prfFlag++; /* fall thru */
		  case 'p' :
		    opt.profile = s[1] ? (s+1) : "w.pro";
		    while( *s )
			s++;
		    s--;
		    break;
		  case 'w' : if( s[1] == 's' ) {
			opt.prfFlag++;
			opt.profile = "ws.pro";
			s++;
		    }
		    else
			Error(3,GetStr(15),s );
		    break;

		  case 'l' : loadDirFlag++;
		    strcpy( loadDirectory, s[1] ? (s+1) : "." );
		    while( *s )
			s++;
		    s--;
		    strcat( loadDirectory, "/" );
		    break;

		  case 'm' : opt.mac = 1; break;
		  case '8' : opt.iso8859 = 1; break;
		#endif
		  case 'v' : opt.verfexit++; break;
		  case 'b' : opt.blackWhite = 1; break;
		  case 'q' : opt.quiet=1; break;
		  case 'J' :
		    if( !strcmp(s+1,"dbgscan" ) )
			opt.debugscans++;
		    else
			Error(3,GetStr(15),s );
		    while( *s ) s++; s--;
		    break;
		  case 'h' :
		  case '?' : CopyRight(0) ; CopyRight(2); break;
		  default  : Error(3,GetStr(15),s );
	    }
    if( !opt.quiet )
	CopyRight(0) ;
  #if UNIX
    opt.iso8859 = 0; /* disable */
    if( have_xargs && !opt.xwindows ) {
	Error(0,"warning: X args given; assuming option -X");
	opt.xwindows++;
    }
    if( opt.xwindows && opt.console )
	Error(3,"error: options -X and -C are exclusive");
    if( !opt.xwindows && !opt.console ) {
	if( pgmname && !strcmp(pgmname,"we") )
	    opt.console++;
	else if( pgmname && !strcmp(pgmname,"wx") )
	    opt.xwindows++;
	else {
	    s = ttyname(0);
	    if( strlen(s) == 9 && !memcmp(s, "/dev/tty",8) && isdigit(s[8]) )
		opt.console++;
	}
    }
    if( !opt.xwindows && !opt.console )
	Error(3,"error: no display detected (try an option)");
  #ifndef USE_VT_LINUX
    if( opt.console )
	Error(3,"error: virtual console mode is not supported");
  #endif
  #endif

    setvbuf(stdout,NULL,_IONBF,0);
    if( !opt.noenvcheck )
	if( getenv(";W_IS_ACTIVE") )
	    Error(2,"W invoked from W; use option -ne to overide this check");

    GrabIOErrors(1);

  #ifndef UNIX
    if( !loadDirFlag ) {
	char *drvBuf, *dirBuf;

      #if OS2
	SearchCommand( loadDirectory );
      #endif
	drvBuf = xmalloc( F_MAX_DRIVE);
	dirBuf = xmalloc( F_MAX_DIR  );
	FilenameSplit( loadDirectory, drvBuf, dirBuf, NULL, NULL );
	FilenameMake( loadDirectory, drvBuf, dirBuf, NULL, NULL );
	FilenameCompr( loadDirectory );
	free( dirBuf);
	free( drvBuf);
    }
  #endif

    if( opt.debugscans )
	KybrdDrvSetDebug( 1 );

  #if !(__STDC__ || OS2)
    setbuf( stdprn, NULL );
  #endif
  #ifdef UNIX
    if( opt.xwindows )
	JnxInitApp( 20, 20, 0, 0 );
  #endif
  #if W_FULL
    if( opt.iso8859 ) {
      #ifndef __linux__
	if( SwitchCPForMode( 1 ) )
	    Error(4,"Codepage 850 is not prepared" );
	InitCmdTables(1);
      #else
	InitCmdTables(0);
      #endif
	MakeScreen(1,opt.blackWhite);
    }
    else {
  #endif
	InitCmdTables(0);
	MakeScreen(0, opt.blackWhite);
  #if W_FULL
    }
  #endif

  #ifdef UNIX
    signal(SIGALRM,AlarmHandler);
    signal(SIGHUP, Die);
    /*signal(SIGINT, Die);*/
    signal(SIGQUIT, Die);
    signal(SIGILL, Die);
    signal(SIGTRAP, Die);
    signal(SIGABRT, Die);
    signal(SIGIOT, Die);
    signal(SIGFPE, Die);
    signal(SIGKILL, Die);
    signal(SIGUSR1, FlagRemote);
    signal(SIGSEGV, Die);
    signal(SIGUSR2, Die);
    signal(SIGPIPE, Die);
    signal(SIGTERM, Die);
    signal(SIGSTKFLT, Die);
    /*signal(SIGCHLD, Die ); */
    /*signal(SIGCONT, Die); used by vt_linux */
    signal(SIGSTOP, Die);
    /*signal(SIGTSTP, Die); used by vt_linux */
    signal(SIGTTIN, Die);
    signal(SIGTTOU, Die);
  #endif
    SetSigIntHandler();

  #if USE_CRITERR_HANDLER
    if( _osmajor >= 3 || _exe_type == EXE_OS2 ) {
	_cerror_handler = CritErrHandler;
	cerror_open();
	opt.i24 = 1;
    }
  #endif
    AddCleanUp( CleanUp, NULL );
    reservedMemoryBlock = xmalloc( 5000 );
    XAllocFailureHook = XAllocFailure;
    ShowMessageAsInfo("Initializing ...");

    /* the system needs at least one active file to work correct */
    if( err = Cmd_New( ".1" ) )
	Bug("Can't open scratch file: %s", GetErrorString(err) );
    PutSetOption( SETOPT_LOADUPD, 1 );
    ReadCmdFile("",0);  /* Start with default bindings */
  #if W_FULL
    if( opt.profile && !opt.prfFlag )
	s = xstrdup( opt.profile );
    else {
	s = xmalloc( strlen(loadDirectory) + 1 + F_MAX_FNAME+4+1);
	strcpy( s, loadDirectory );
	if( opt.prfFlag )
	    mem2str( s+strlen(s), opt.profile, F_MAX_FNAME+4 );
	else
	    strcat( s, "w.pro" );
    }
    err = ReadCmdFile( s, 1 );
    LockTextUpdate(0); /* allow update of text area */
    UpdateScreen();
    if( err )
	ShowMessage("'%s': %s", s, GetErrorString(err));
    else
	ShowMessage(NULL);
    free(s);
  #else
    ShowMessage(NULL);
  #endif

   #if W_FULL
    if( opt.mac ) { /* use commandline args as macros */
	for(err=0 ; argc && !err ; argc-- , argv++ )
	    err = Cmd_ExecuteString( *argv, ARGTYPE_STRING );
	if( err )
	    ShowMessage("Error in commandline macro: %s",
			  GetErrorString(err));
    }
    else {
  #endif
	/* load the files specified from the command line */
	for(err=0 ; argc && !err ; argc-- , argv++ )
	    err = Cmd_Edit( *argv );
	if( err )
	    ShowMessage("Error reading '%s': %s", argv[-1],
			GetErrorString(err));
  #if W_FULL
    }
  #endif

    if( !err && GetFileCount() > 1) { /* so I don't need the scratch anymore */
	if( !(err =Cmd_Switch2NamedFile( ".1" )) )
	    err = Cmd_Quit();
	if( err )
	    ShowMessage("Can't get rid of \".1\": %s",
			GetErrorString(err));
    }

    do {
	Editor();
	if( opt.verfexit ) {
	    ShowMessageAsInfo("Exit W ? - Type y or n");
	    for(;;) {
		while( !(i=GetKeyValue()) )
		    ;
		if( (i=toupper(i)) == 'Y' ) {
		    opt.verfexit = 0;
		    break;
		}
		else if( i == 'N' ) {
		    if( err = Cmd_VarList( NULL ) )
			Bug("Can't open varlist: %s",GetErrorString(err));
		    break;
		}
	    }
	    ShowMessage(NULL);

	}
    } while( opt.verfexit );
    ReadCmdFile(NULL,0);  /* Clear all bindings */
    FREE( reservedMemoryBlock );
    return 0;
} /* end main() */


static void CleanUp( void *dummy )
{
  #if __ZTC__ && !DOS386  /* DOS386 without Debug results in heap corruption */
    if( controlCHandlerState ) {
	controlc_close();
	controlCHandlerState = 0;
    }
  #endif

  #if USE_CRITERR_HANDLER
    if( opt.i24 ) {
	cerror_close();
	opt.i24 = 0;
    }
  #endif
  #if W_FULL
    if( orgCodePage )
	SetActiveCodePage( orgCodePage );
  #endif
}


int
SwitchCPForMode( int mode )
{
    if( !orgCodePage ) /* save orgcodepage */
	orgCodePage = QryActiveCodePage();
    if( SetActiveCodePage( mode ? 850 : 437 ) ) {
	orgCodePage = 0; /* do not restore */
	return ERR_INVCP;
    }
    return 0;
}



static void
Editor( )
{
    int err, c, val, idle;
    unsigned flags;

    while( GetFileCount() ) {
	err = idle = 0;
	UpdateScreen();
      #if W_FULL
	IdleScreen(0);
	AutoRefresh(0);
      #endif
	while( !(c = GetKeyId(&val)) && !sigIntPending && !idle ) {
	  #if W_FULL
	    IdleScreen(1);
	  #if OS2 || UNIX
	    if( CheckDetachedProcs() == 2 )
		UpdateScreen();
	  #endif
	  #ifdef UNIX
	    if( lookForRemote ) {
		char buf[20];

		lookForRemote = 0;
		sprintf(buf,"/tmp/w-edit.%d", getpid() );
		if( err = ReadCmdFile( buf, 0 ) )
		    ShowMessage("'%s': %s", buf, GetErrorString(err));
		remove(buf);
		idle++;
		break;
	    }
	  #endif
	    AutoRefresh(1);
	  #endif
	  #if USE_VT_LINUX
	    if( opt.console )
		if( VTLinuxWait() == 1 ) {
		    /*Info("VTLinuxWait: EINTR or timeout");*/
		    idle++;
		}
	  #endif
	  #ifdef UNIX
	    if( opt.xwindows ) {
		int r;
		r =  JnxWaitEvent();
		if( r == -1 )
		    return;
		else if( r == 1 )
		    idle++;
	    }
	  #endif
	}
	if( !idle )
	    ShowMessage(NULL);
	if( idle )
	    err = 0;
	else if( sigIntPending )
	    err = ERR_SIGINT;
	else {
	    if( c == K_VK_RETURN ) {
		GetFileInfo( QryScreenFile(), &flags );
		if( flags & WFILE_INCMD )
		    err = ExecuteCmdLine();
		else
		    err = ExecKeyCmd( c, val );
	    }
	    else
		err = ExecKeyCmd( c, val );
	}
	if( err ) {
	    if( err == ERR_CMDINT || err == ERR_SIGINT ) {
		demoModeFlag = 0;
		if( err == ERR_SIGINT )
		    Write2CurCmdLine(NULL);
		RedrawScreen();
		SetSigIntHandler();
		SetFileFlag( QryScreenFile(), WFILE_INCMD);
	    }
	    ShowMessage( GetErrorString(err) );
	}
    }
}


void DemoProcess()
{
  #if W_FULL
    if( demoModeFlag ) {
	UpdateScreen();
	if( demoModeFlag > 1 )
	    Sleep(1000);
    }
  #endif
}


static void AutoRefresh(int mode )
{
    static long lastHit, interval;
    static int saved;
    const char *p;
    unsigned flags;
    char *buf;

    if( !mode ) {
	lastHit = clock();
	saved = 0;
	interval = GetSetOption( SETOPT_REFRESH );
    }
    else if( interval ) {
	if( clock() - lastHit > interval * CLOCKS_PER_SEC ) {
	    p = GetFileInfo( QryScreenFile(), &flags );
	    if( (flags & WFILE_INT) && (flags & WFILE_INCMD) )
		if( !strcmp( p, ".varlist" ) ) {
		    Cmd_ExecuteString( ":%ZLine^evl;varlist;line;cc",
							ARGTYPE_STRING );
		    UpdateScreen();
		}
		else if( !strcmp( p, ".dir" ) ) {
		    buf = xmalloc( F_MAX_PATH + 50 );
		    sprintf( buf, ":%%Zline^evl;dir %s;line;cc",
						    GetDirPattern() );
		    Cmd_ExecuteString( buf, ARGTYPE_STRING );
		    free( buf );
		    UpdateScreen();
		}
	}
    }
}



const char *GetErrorString( int n )
{
    const char *p;
    static char buf[20];

    switch( n ) {
      case ERR_NOERROR: p = "No error"; break;
      case ERR_UNKNOWN: p = "Unknown"; break;
      case ERR_NOMEM  : p = "Out of core"; break;
      case ERR_NOLINE : p = "No Line"; break;
      case ERR_INVCMD : p = "Invalid Command"; break;
      case ERR_MRKCFL : p = "Mark conflict"; break;
      case ERR_FINUSE : p = "File is in use"; break;
      case ERR_FILEHD : p = "Out of file-handles"; break;
      case ERR_INVARG : p = "Invalid argument"; break;
      case ERR_INVKEY : p = "Invalid key"; break;
      case ERR_LOCCMD : p = "Error in locate or change command"; break;
      case ERR_SETCMD : p = "Error in set command"; break;
      case ERR_NOPRO  : p = "Profile invalid or not found"; break;
      case ERR_NOCHGP : p = "No change pending"; break;
      case ERR_MISNAM : p = "Missing filename"; break;
      case ERR_2DEEP  : p = "Recursion too deep"; break;
      case ERR_NOMRK  : p = "No marked area"; break;
      case ERR_USPCMD : p = "Command not supported"; break;
      case ERR_STCNFL : p = "Source and target conflict"; break;
      case ERR_DIRNF  : p = "Directory not found"; break;
      case ERR_PUTENV : p = "Error setting environment"; break;
      case ERR_LOOP   : p = "Error in loop command"; break;
      case ERR_NOBMRK : p = "No block mark"; break;
      case ERR_NFOUND : p = "Not found"; break;
      case ERR_SRCHPAT: p = "Error in search pattern"; break;
      case ERR_CMDINT : p = "Command interrupted"; break;
      case ERR_NOASCII: p = "Non ASCII-Character entered"; break;
      case ERR_NOFILE : p = "File not found"; break;
      case ERR_INTNAM : p = "Internal file"; break;
      case ERR_SAVINT : p = "Can't save internal file"; break;
      case ERR_SAVRO  : p = "Can't save read-only file"; break;
      case ERR_SETRW  : p = "Can't set file to read-write"; break;
      case ERR_OPNFIL : p = "Error opening file"; break;
      case ERR_WRTFIL : p = "Error writing file"; break;
      case ERR_NOSAVE : p = "Save not allowed for this file"; break;
      case ERR_NOLABEL: p = "Label not set"; break;
      case ERR_INVLAB : p = "Invalid Label"; break;
      case ERR_PUSHMRK: p = "Too many marks saved"; break;
      case ERR_POPMRK : p = "No marks saved"; break;
      case ERR_SIGINT : p = "SIGINT received"; break;
      case ERR_INVOP  : p = "Invalid operator"; break;
      case ERR_CSTKOVR: p = "Calculation stack overflow (use: ^clear)"; break;
      case ERR_CSTKUDR: p = "Calculation stack underflow"; break;
      case ERR_DIVZERO: p = "Division by zero"; break;
      case ERR_VARROOM: p = "Not enough room for variables"; break;
      case ERR_INVVAR : p = "Invalid variable"; break;
      case ERR_LTRUNC : p = "Line(s) truncated"; break;
      case ERR_EDTRO  : p = "Can't edit readonly file"; break;
      case ERR_INVTAB : p = "Invalid tab settings"; break;
      case ERR_INVMRG : p = "Invalid margin settings"; break;
      case ERR_NOLMRK : p = "No line mark"; break;
      case ERR_DELFIL : p = "Error erasing file"; break;
      case ERR_REDFIL : p = "Error reading file"; break;
      case ERR_VALRNG : p = "Range error"; break;
      case ERR_INVDEL : p = "Invalid delimiter"; break;
      case ERR_SYSLIMIT:p = "System limit reached"; break;
      case ERR_READPER: p = "No read permission"; break;
      case ERR_RENFIL : p = "Error renaming file"; break;
    #if OS2 || EMX || UNIX
      case ERR_DETACH : p = "Error creating detached process"; break;
      case ERR_INVPID : p = "Invalid job"; break;
      case ERR_KILLP  : p = "Error killing process"; break;
      case ERR_SNDSIG : p = "Error sending signal"; break;
    #endif
      case ERR_MAC2LNG: p = "Macro is too long"; break;
      case ERR_FILEXIST: p = "File exists"; break;
      case ERR_CLPBRD: p = "Error in clipboard operation"; break;
      case ERR_INVOPT: p = "Invalid option"; break;
      case ERR_USPFFMT: p = "Unsupported fileformat or reclen"; break;
      case ERR_INVOPTC: p = "Invalid comination of options"; break;
      case ERR_INVRLEN: p = "Invalid record length"; break;
      case ERR_LTRUNCNS : p = "Line(s) truncated - not saved"; break;
      case ERR_INVNAME	: p = "Invalid name"; break;
      case ERR_UDFFNC	: p = "Undefined function"; break;
      case ERR_UXPBEG	: p = "Unexpected BEGIN"; break;
      case ERR_UXPEND	: p = "Unexpected END"; break;
      case ERR_MISEND	: p = "Missing END"; break;
      case ERR_BLKNEST	: p = "Blocks nested too deep"; break;
      case ERR_MRK2LRG	: p = "Mark is too large"; break;
      case ERR_CLPEMPTY : p = "Clipboard is empty"; break;
      case ERR_NOLINEID : p = "LineId not found"; break;
      case ERR_INVRE	: p = "Invalid regular expression"; break;
      case ERR_BUG	: p = "Internal error - recovered"; break;
      case ERR_VIEW	: p = "Can't do this in view-mode"; break;
      case ERR_INVCP	: p = "CodePage not available"; break;
      case ERR_BUGDB	: p = "Problem with BugDB"; break;
      default:	sprintf(buf, "Error %d", n ); p = buf; break;
    }
    return p;
}


int SigIntPoll()
{
  #if DEBUG
    CHKSTACK();    /* a good place for this */
  #endif
  #if !OS2
    ScrDrvPoll();
  #endif
    return sigIntPending;
}



#if __ZTC__
static void ControlCHandler(void)
{
    sigIntPending = 1;
}
#else
static void SigIntHandler( int val )
{
    sigIntPending = 1;
    signal( SIGINT, SigIntHandler );
}
#endif

static void SetSigIntHandler()
{
    sigIntPending = 0;
  #if __ZTC__
    if( !controlCHandlerState ) {
	_controlc_handler = ControlCHandler;
	controlc_open();
	controlCHandlerState = 1;
    }
  #else
    signal( SIGINT, SigIntHandler );
  #endif
}


/****************
 * Try to free up some memory, so that xmalloc can go to continue for a while
 * we have to return true, to let xallocs retry the allocation.
 */

static int XAllocFailure( size_t needed )
{
    static int sentinel;
    int okay;

    okay = 0;
    if( sentinel )
	return 0;
    sentinel++;

    if( reservedMemoryBlock ) {
	FREE( reservedMemoryBlock );
	ShowMessage("Warning: System is in low memory state");
	okay = 1;
    }

    sentinel--;
    return okay;

}


void Try2AllocReservedMemory()
{
    if( !reservedMemoryBlock )
	reservedMemoryBlock = malloc( 5000 );
}


/****************
 * Returns: True if Reserved Memory is available
 */

int QryReservedMemoryState()
{
    return reservedMemoryBlock != NULL;
}


#if USE_CRITERR_HANDLER
/*
 * Monitor to intercept the Critical Error Interrupt
 */


int _far CritErrHandler( int *regAX, int *regDI )
{
    static char *errNames[] = {
	"Write protected",
	"Unkown device",
	"Drive not ready",
	"Unkown command",
	"CRC error in data",
	"Invalid DRSL",
	"Positioning error",
	"Unkown media type",
	"Sector not found",
	"Out of paper",
	"Write error",
	"Read error",
	"General error"  } ;
    static char text1[] = "Critical error";
    static char text2[] = " -  (R)etry, (C)ancel";

    if( *regDI < 0 || *regDI > DIM( errNames ) ) /* unkown error code */
	ShowMessageViaBios( "%s: AX=%X DI=%X %s",
			    text1, *regAX, *regDI, text2 );
    else if( *regAX & 0x8000 )	/* not an a drive */
	ShowMessageViaBios( "%s: %s %s",
			    text1, errNames[*regDI], text2 );
    else    /* results from a drive */
	ShowMessageViaBios( "%s on %c: %s %s",
			    text1, (*regAX&0xff)+'A',errNames[*regDI], text2 );

    for(;;) {
	switch( bioskey(0)&0xff ) {
	  case 'c':
	  case 'C':
	    ShowMessageViaBios(NULL);
	    *regAX = 3;
	    return 0;	/* fail */
	  case 'r':
	  case 'R':
	    ShowMessageViaBios(NULL);
	    *regAX = 1;
	    return 0;	/* retry */
	}
    }
}

  #if OS2 /* I think there must be an error in the Zortech Documentation */
    int cerror_open(void)  {  }     /* dummy function, nothing will happen */
    int cerror_close(void) {  }
  #endif
#endif

#if DOS386 && __ZTC__
int putenv(const char *a)
{
    return 0;  /* there is an error in the current DOSX Impl. */
}	       /* which causes a GP (possible ill addr) */
#elif defined(UNIX)
/*
 * We use our own putenv/environment system
 * because the use of environ, getenv() and putenv is not well defined
 * I think - Without these functions the environment is messed up.
 */

static char **environ_array;

char **
GetEnvironmentArray(void)
{
    extern char **environ;
    char **ep;
    int i, len;

    if( !environ_array ) {
	/* copy it from the parent environment */
	for(i=0,ep=environ; *ep; ep++, i++ )
	    ;
	i++;
	len = i + 10;
	environ_array = xmalloc( len * sizeof *environ_array );
	for(i=0,ep=environ; *ep; ep++, i++ )
	    environ_array[i] = xstrdup(*ep);
	for( ; i < len ; i++ )
	    environ_array[i] = NULL;
	environ_array[i-1] = "+++"; /* this marks the end of the gap */
    }
    return environ_array;
}

const char *
GetEnvironmentStrings(void)
{
    static char *env;
    static size_t envSize;
    char **pp, **pporg;
    char *p;
    size_t n;

    if( !environ_array )
	GetEnvironmentArray();

    /* determine needed space */
    pporg = environ_array;
    for(n = 0, pp = pporg; *pp ; pp++ )
	n += strlen( *pp ) + 1;
    n += 3; /* add extra 0 plus 2 for security */
    if( !env || n != envSize ) { /* first call or size changed */
	free( env );
	env = xmalloc( envSize = n );
    }
    /* copy to space */
    for(p = env, pp = pporg; *pp ; pp++ )
	if( **pp )
	    p = stpcpy(p, *pp) + 1;
    *p++ = 0;  /* terminating 0 */
    *p++ = 0;  /* plus two extras */
    *p	 = 0;
    return env;
}

char *
getenv(const char *name)
{
    const size_t len = strlen(name);
    char **ep;
    static int sentinel;

    if( !environ_array ) {
	if( sentinel ) { /* may happen because lib functions may use getenv*/
	    extern char **environ;
	    /* return value from the original environment */
	    for(ep = environ; *ep ; ep++ )
		if( !strncmp( *ep, name, len) && (*ep)[len] == '=' )
		    return (*ep)+len+1;
	    return NULL;
	}
	sentinel++;
	GetEnvironmentArray();
	sentinel--;
    }

    for(ep = environ_array; *ep ; ep++ )
	if( !strncmp( *ep, name, len) && (*ep)[len] == '=' )
	    return (*ep)+len+1;
    return NULL;
}

int
putenv(const char *string)
{
    size_t len;
    char **ep, **dp;
    const char *se = strchr( string, '=' );

    if( !environ_array )
	GetEnvironmentArray();

    if( !se ) { /* remove this var */
	len = strlen(string);
	for(ep = environ_array; *ep ; ep++ )
	    if( !strncmp( *ep, string, len) && (*ep)[len] == '=' ) {
		free(*ep);
		for(dp=ep; (dp[0] = dp[1]); dp++ )
		    ;
		break;
	    }
	return 0;
    }
    else { /* add this variable */
	char *newstr;
	len = se - string;

	if( !(newstr=strdup(string)) )
	    return -1;
	for(ep = environ_array; *ep ; ep++ )
	    if( !strncmp( *ep, string, len) && (*ep)[len] == '=' ) {
		free(*ep);
		*ep = newstr;
		return 0;
	    }
	/* mut put a new entry into the array */
	*ep++ = newstr;
	if( *ep ) { /* this is the marker for the end of the gap */
		    /* we must allocate a new array */
	    char **newenv;
	    int i;

	    i = ep - environ_array;
	    i++;
	    len = i + 10;
	    newenv = xmalloc( len * sizeof *newenv );
	    for(i=0,dp=environ_array; dp < ep ; dp++, i++ )
		newenv[i] = *dp;
	    for( ; i < len ; i++ )
		newenv[i] = NULL;
	    newenv[i-1] = "+++"; /* this marks the end of the gap */
	    free(environ_array);
	    environ_array = newenv;
	}
    }

    return 0;
}

#endif

/*** bottom of file ***/
