/* sfsv.h  - verification of a digital signature
 *	Copyright (C) 1999 Werner Koch (dd9jn).
 *
 * This file is part of SFSV.
 *
 * SFSV is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * SFSV is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef SFSV_H
#define SFSV_H

#include <stddef.h>

/****************
 * Return codes.
 */
enum {
    SFSV_GOOD_SIG = 0,
    SFSV_BAD_SIG  = 1,
    SFSV_NO_KEY   = 2,
    SFSV_NO_SIG   = 3,
    SFSV_BAD_ELF  = 4,
    SFSV_BAD_PGP  = 5
};

/****************************************
 **** verify an embedded signature  *****
 ****************************************/
int sfsv_verify_elf_signature( const unsigned char *image, size_t imagesize );

/****************************************
 **** locate an embedded signature  *****
 ****************************************/
int sfsv_locate_elf_signature( const unsigned char *image, size_t imagelen,
			       size_t *sigoff, size_t *siglen );



#endif /*SFSV_H*/
