/* misc.c
 *	Copyright (C) 1999 Werner Koch (dd9jn).
 *
 * This file is part of SFSV.
 *
 * SFSV is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * SFSV is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "config.h"
#include <stdlib.h>
#include "types.h"
#include "misc.h"

#ifdef INCLUDE_PRIMITIVES

size_t
strlen( const char *s )
{
    size_t n;

    for( n=0; *s; s++, n++ )
	;
    return n;
}

void *
memset( void *p, int c, size_t n )
{
    unsigned char *s;

    for(s=p; n ; s++, n-- )
	*s = c;
    return p;
}

void *
memcpy( void *dst, const void *src, size_t n )
{
    char *d;
    const char *s;

    for(s=src,d=dst; n; n-- )
	*d++ = *s++;

    return dst;
}


#endif /*INCLUDE_PRIMITIVES*/
