/* [wkrc_4.c wk 4.6.91] WKRC: Proc Resource DlgWin
 *	Copyright (c) 1991 by Werner Koch (dd9jn)
 * $Header: /usr/src/master/libs/wkswn/wkrc_4.c,v 1.4 1997/01/07 15:18:01 wk Exp $
 *
 * Resource: Dialog Window
 */

#include <wk/tailor.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <limits.h>
#include <string.h>
#include <wk/lib.h>
#include <wk/string.h>
#include <wk/cua.h>

#include "wkrc.h"

/******* constants *********/
#define TEXTTBL_SIZE  8192     /* max. Size of TextTable */
#define MAX_ITEMS     150      /* sollte reichen */
#define MAX_BUTTONS   8        /* max. numnber of radio Buttons of 1 item */

/****** types ******/
typedef struct {
	    short px,py;	/* Position in the Window */
	    ushort oText;	/* Offset into TextTable */
	} text_t;

typedef struct {
	byte	type;	    /* type of item ( DLG_... ) */
	union {
	    struct {
		short px,py;	    /* Position of Window */
		short sx,sy;	    /* Size of Window */
		byte col[16];
	    } window;		    /* kommt nur einmal vor !*/
	    text_t text;	    /* struct for DLG_TEXT */
	    struct {
		short px,py;	    /* Position in the Window */
		short sx,sy;	    /* Size of input field */
		ushort id;	    /* ID of this Item */
		ushort oText;	    /* Offset into TextTable for def. Value */
		ushort oHelp;	    /* offset of helpkey */
		ushort flags;	    /* oinfos abaut the Field */
		ushort oMin;	    /* Offset to string with max. Value */
		ushort oMax;	    /* Offset to string with max. Value */
	    } field;
	    struct {
		ushort id;	    /* id of Button */
		short nBtn;	    /* number of buttons */
		ushort val;	    /* Default Value of Button */
		ushort oHelp;	    /* Helpkey of Button */
		text_t btn[MAX_BUTTONS];
	    } button;
	    struct {
		short px,py;	    /* Position in the Window */
		short sx,sy;	    /* Size of box */
		ushort id;	    /* ID of this Item */
		ushort oHelp;	    /* offset of helpkey */
		ushort flag;
	    } lstbox;
	} x;
    } item_t;

/***** globals *****/
static char    *textTbl;    /* Ptr to textTable  */
static size_t  usedTbl;     /* # of bytes used in NameTbl */
static item_t  *itemTbl;
static int     usedItems;
static int inBlockFlag;     /* inside a begin End Block */
static int windowDataOkay;
static struct {
	int px, py;
	int sx, sy;
	int id;
	int oText;
	int oHelp;
	int flags;
	int oMin, oMax;
	int val;
	int col;
	int flg0;
	int flg1;
	int flg2;
	int flg3;
    } plausi;		    /* Processed Values, are marked true here */

/******* local protos ******/
static int ProcLine( const char *line );
static void WriteItems(void);
static int ProcSubField( const char *line, char *name, item_t *item );
static int ProcSubButton( const char *line, char *name, item_t *item );
static int ProcSubLstbox( const char *line, char *name, item_t *item );
static int WriteValues(item_t *);
static byte *Copy( void *d, const void *s, size_t size );
static const char *CopyWord( const char *line, char *name, int *err );
static const char *CopyMacro( const char *line, ushort *value, int *err );
static const char *GetXYVal( const char *line, short *xVal, short *yVal, int *err );
static const char *GetByteVal( const char *line, byte *val, int *err );
static const char *GetString( const char *line, ushort *value, int *err );
static int LineEmpty( const char *line );
/******** functions *********/

/*
 * Dies Funktion verarbeitet die Zeilen des Resourcetypes:
 *     DlgWin ( Dialog Window )
 * Mode = 0 : Initialisieren
 *	  1 : Zeile
 *	  2 : Endbehandlung
 * line = bei mode 1 : Sourceline
 *	  sonst      : ResourceName
 * Blanks am Anfang und am Ende einer Zeile sind bereits entfernt.
 * Returns: ErrorCode
 */

int ProcRcDlgWin( const char *line, int mode )
{
    int err ;

    if( mode == 1 )
	err = *line ? ProcLine( line ) : 0 /* skip empty lines */;
    else if( !mode  ) { /* init */
	itemTbl = xcalloc( MAX_ITEMS+1, sizeof *itemTbl );
	usedItems = 0;
	textTbl = xmalloc( TEXTTBL_SIZE+1 );
	*textTbl = '\0'; /* first entry must be an empty String */
	usedTbl = 1;
	inBlockFlag=0;
	windowDataOkay = 0;
	memset( &plausi, 0, sizeof plausi );
	/* (line contains resourcename) */
	printf("Processing DlgWin-Resource `%s'\n", line );
	memcpy( itemTbl[0].x.window.col,     /* default values */
			"\x03\x02\x03\x06\x02\x06\x03\x04"
			"\x01\x07\x00\x00\x00\x00\x00\x00" , 16 );
	err = 0;
    }
    else { /* exit */
	ushort uhlp;

	err = 0 ;
	if( itemTbl[usedItems].type || !windowDataOkay )
	    err = ERR_INCMPL;
	else {
	    StartTempFile( line ); /* contains resourcename */
	    uhlp = RC_DLGWIN;
	    WriteTempFile( &uhlp, sizeof uhlp );    /* Resource ID */
	    uhlp = usedItems;
	    WriteTempFile( &uhlp, sizeof uhlp );    /* # of Items */
	    uhlp = usedTbl;
	    WriteTempFile( &uhlp, sizeof uhlp );    /* bytes in NameTbl */
	    uhlp = usedTbl;
	    WriteTempFile( textTbl, uhlp );	    /* NameTbl */
	    WriteItems();
	}

	free( textTbl ) ;
	free( itemTbl ) ;
    }

    return err;
}


/*
 * Die ItemTable auf den Temp Stream schreiben
 */

static void WriteItems()
{
    int n, i;
    item_t *item;
    size_t nBytes;
    byte *buffer, *p;

    buffer = xmalloc( sizeof(item_t) + 10 );
    for( n=0, item = itemTbl; n < usedItems; n++, item++ ) {
	p = buffer+1;
	*p++ = item->type;
	switch( item->type ) {
	  case DLG_WINDOW:
	    p = Copy( p, &item->x.window.px, sizeof(short) );
	    p = Copy( p, &item->x.window.py, sizeof(short) );
	    p = Copy( p, &item->x.window.sx, sizeof(short) );
	    p = Copy( p, &item->x.window.sy, sizeof(short) );
	    p = Copy( p, item->x.window.col, 16    );
	    break;
	  case DLG_TEXT:
	    p = Copy( p, &item->x.text.px, sizeof(short) );
	    p = Copy( p, &item->x.text.py, sizeof(short) );
	    p = Copy( p, &item->x.text.oText, sizeof(ushort));
	    break;

	  case DLG_FIELD:
	    p = Copy( p, &item->x.field.px, sizeof(short) );
	    p = Copy( p, &item->x.field.py, sizeof(short) );
	    p = Copy( p, &item->x.field.sx, sizeof(short) );
	    p = Copy( p, &item->x.field.sy, sizeof(short) );
	    p = Copy( p, &item->x.field.id, sizeof(ushort) );
	    p = Copy( p, &item->x.field.oText, sizeof(ushort) );
	    p = Copy( p, &item->x.field.oHelp, sizeof(ushort) );
	    p = Copy( p, &item->x.field.flags, sizeof(ushort) );
	    if( item->x.field.oMin || item->x.field.oMax ) {
		p = Copy( p, &item->x.field.oMin, sizeof(ushort) );
		p = Copy( p, &item->x.field.oMax, sizeof(ushort) );
	    }
	    break;

	  case DLG_BUTTON:
	    p = Copy( p, &item->x.button.id   , sizeof(ushort) );
	    p = Copy( p, &item->x.button.nBtn , sizeof(ushort) );
	    p = Copy( p, &item->x.button.val  , sizeof(ushort) );
	    p = Copy( p, &item->x.button.oHelp, sizeof(ushort) );
	    for(i=0; i < item->x.button.nBtn; i++) {
		p = Copy( p, &item->x.button.btn[i].px, sizeof(short) );
		p = Copy( p, &item->x.button.btn[i].py, sizeof(short) );
		p = Copy( p, &item->x.button.btn[i].oText, sizeof(ushort) );
	    }
	    break;

	  case DLG_LSTBOX:
	    p = Copy( p, &item->x.lstbox.px, sizeof(short) );
	    p = Copy( p, &item->x.lstbox.py, sizeof(short) );
	    p = Copy( p, &item->x.lstbox.sx, sizeof(short) );
	    p = Copy( p, &item->x.lstbox.sy, sizeof(short) );
	    p = Copy( p, &item->x.lstbox.id, sizeof(ushort) );
	    p = Copy( p, &item->x.lstbox.oHelp, sizeof(ushort) );
	    p = Copy( p, &item->x.lstbox.flag, sizeof(ushort) );
	    break;

	  default: Bug("Invalid itemType %d in WriteItems", item->type );
	}
	nBytes = p - buffer;
	*buffer = (byte)(nBytes-2);
	WriteTempFile( buffer, nBytes );
    }
    free(buffer);
}


/*
 * Diese Funktion ist wie memcpy, aber es wird ein
 * ein Pointer auf das nachletze element in d zurckgegeben
 */

static byte *Copy( void *d, const void *s, size_t size )
{
    register char *a;
    register const char *b;
    a = d; b = s;
    while( size-- )
	*a++ = *b++;
    return (byte *)a;
}


/*
 * Eine Zeile verarbeiten, die Zeile kann Format elemente der folgenden
 * Format ist in rc.doc beschrieben
 * Returns: ErrorCode
 */

static int ProcLine( const char *line )
{
    int err, i;
    char name[MAX_NAMELEN+1]; /*  temp. Buffer */
    item_t *item=NULL; /* controlled by err */
    ushort value;
    short xVal, yVal;
    byte bVal;


    err = 0;
    if( usedItems < MAX_ITEMS )
	item = itemTbl + usedItems;
    else
	err = ERR_R2MANY;   /* too many items */

    /* first item of eauch line will be a keyword */
    line = CopyWord( line, name, &err );

    if( err )
	;
    else if( !inBlockFlag ) { /* outside of an Block */
	if( !strcmp( name, "Pos") ) {
	    if( item->type && item->type != DLG_WINDOW )
		err = ERR_SYNTAX;
	    else if( plausi.px || windowDataOkay )
		err = ERR_ALDEF;    /* already defined */
	    else {
		item->type = DLG_WINDOW;
		line = GetXYVal( line, &xVal, &yVal, &err );
		if( !err ) {
		    if( !LineEmpty(line) )
			err = ERR_SYNTAX;
		    else {
			item->x.window.px = xVal;
			item->x.window.py = yVal;
			plausi.px = plausi.py = 1;
		    }
		}
	    }
	}
	else if( !strcmp( name, "Size") ) {
	    if( item->type && item->type != DLG_WINDOW )
		err = ERR_SYNTAX;
	    else if( plausi.sx || windowDataOkay )
		err = ERR_ALDEF;    /* already defined */
	    else {
		item->type = DLG_WINDOW;
		line = GetXYVal( line, &xVal, &yVal, &err );
		if( !err ) {
		    if( !LineEmpty(line) )
			err = ERR_SYNTAX;
		    else {
			item->x.window.sx = xVal;
			item->x.window.sy = yVal;
			plausi.sx = plausi.sy = 1;
		    }
		}
	    }
	}
	else if( !strcmp( name, "Color") ) {
	    if( item->type && item->type != DLG_WINDOW )
		err = ERR_SYNTAX;
	    else if( windowDataOkay )
		err = ERR_ALDEF;    /* already defined */
	    else {
		item->type = DLG_WINDOW;
		i = 0;
		while( *(line = GetByteVal( line, &bVal, &err )) ) {
		    if( err ) {
			if( *line == '.' ) {  /* use defualt value */
			    err = 0;
			    line++;
			}
			else
			    break;
		    }
		    else
			item->x.window.col[i] = bVal;
		    i++ ;
		    if( i > 15 ) {
			if( !LineEmpty(line) )
			    err = ERR_SYNTAX ;
			break;
		    }
		}
		if( err == ERR_SYNTAX && !*line )
		    err = 0;

		if( !err )
		    plausi.col++;
	    }
	}
	else if( !strcmp( name, "Text") ) {
	    if( !windowDataOkay ) {
		err = WriteValues(item);
		if( usedItems < MAX_ITEMS )
		    item = itemTbl + usedItems;
		else
		    err = ERR_R2MANY;	/* too many items */
	    }
	    if( err )
		;
	    else if( item->type )
		err = ERR_SYNTAX;
	    else {
		item->type = DLG_TEXT;
		line = GetXYVal( line, &xVal, &yVal, &err );
		if( !err ) {
		    item->x.text.px = xVal;
		    item->x.text.py = yVal;
		    plausi.px = plausi.py = 1;
		    line = GetString( line, &value, &err );
		    if( !err ) {
			item->x.text.oText = value;
			plausi.oText = 1;
			err = WriteValues(item);
		    }
		}
	    }
	}
	else if( !strcmp( name, "Begin") ) {
	    if( !windowDataOkay ) {
		err = WriteValues(item);
		if( usedItems < MAX_ITEMS )
		    item = itemTbl + usedItems;
		else
		    err = ERR_R2MANY;	/* too many items */
	    }
	    if( err )
		;
	    if( item->type )
		err = ERR_SYNTAX;
	    else
		line = CopyWord( line, name, &err );
	    if( !err ) {
		inBlockFlag = 1;
		if( !strcmp( name, "Field") ) {
		    item->type = DLG_FIELD;
		    line = CopyMacro( line, &value, &err );
		    if( !err ) {
			if( !LineEmpty(line) )
			    err = ERR_SYNTAX;
			else {
			    item->x.field.id = value;
			    plausi.id = 1 ;
			}
		    }
		}
		else if( !strcmp( name, "Button") ) {
		    item->type = DLG_BUTTON;
		    line = CopyMacro( line, &value, &err );
		    if( !err ) {
			if( !LineEmpty(line) )
			    err = ERR_SYNTAX;
			else {
			    item->x.button.id = value;
			    plausi.id = 1 ;
			}
		    }
		}
		else if( !strcmp( name, "ListBox") ) {
		    item->type = DLG_LSTBOX;
		    line = CopyMacro( line, &value, &err );
		    if( !err ) {
			if( !LineEmpty(line) )
			    err = ERR_SYNTAX;
			else {
			    item->x.lstbox.id = value;
			    plausi.id = 1 ;
			}
		    }
		}
		else
		    err = ERR_UKWKWD;
	    }
	}
    }
    else {  /* inside of an Block */
	if( !strcmp( name, "End") ) {
	    if( !LineEmpty(line) )
		err = ERR_SYNTAX;
	    else if( !(err = WriteValues(item)) )
		inBlockFlag = 0;
	}
	else if( !strcmp( name, "Begin") )
	    err = ERR_UBNEST;
	else switch( item->type ) {
	  case DLG_FIELD:
	    err = ProcSubField( line, name , item );
	    break ;

	  case DLG_BUTTON:
	    err = ProcSubButton( line, name , item );
	    break ;

	  case DLG_LSTBOX:
	    err = ProcSubLstbox( line, name , item );
	    break ;

	  default: Bug("invalid itemType %d inside a Block", item->type );
	}
    }

    return err ;
}



/*
 * Eine Sub Entry vom typ Field verarbeiten
 */

static int ProcSubField( const char *line, char *name, item_t *item )
{
    int err;
    ushort value;
    short xVal, yVal;

    err = 0;
    if( !strcmp( name, "Pos") ) {
	if( plausi.px )
	    err = ERR_ALDEF;
	else {
	    line = GetXYVal( line, &xVal, &yVal, &err );
	    if( !err ) {
		if( !LineEmpty(line) )
		    err = ERR_SYNTAX;
		else {
		    item->x.field.px = xVal;
		    item->x.field.py = yVal;
		    plausi.px = plausi.py = 1;
		}
	    }
	}
    }
    else if( !strcmp( name, "Size") ) {
	if( plausi.sx )
	    err = ERR_ALDEF;
	else {
	    line = GetXYVal( line, &xVal, &yVal, &err );
	    if( !err ) {
		if( !LineEmpty(line) )
		    err = ERR_SYNTAX;
		else {
		    item->x.field.sx = xVal;
		    item->x.field.sy = yVal;
		    plausi.sx = plausi.sy = 1;
		}
	    }
	}
    }
    else if( !strcmp( name, "Help") ) {
	if( plausi.oHelp )
	    err = ERR_ALDEF;
	else {
	    line = GetString( line, &value, &err );
	    if( !err ) {
		if( !LineEmpty(line) )
		    err = ERR_SYNTAX;
		else {
		    item->x.field.oHelp = value;
		    plausi.oHelp=1;
		}
	    }
	}
    }
    else if( !strcmp( name, "Text") ) {
	if( plausi.oText )
	    err = ERR_ALDEF;
	else {
	    line = GetString( line, &value, &err );
	    if( !err ) {
		if( !LineEmpty(line) )
		    err = ERR_SYNTAX;
		else {
		    item->x.field.oText = value;
		    plausi.oText=1;
		}
	    }
	}
    }
    else if( !strcmp( name, "Range") ) {
	if( plausi.oMin )
	    err = ERR_ALDEF;
	else {
	    line = GetString( line, &value, &err );
	    if( !err ) {
		item->x.field.oMin = value;
		line = GetString( line, &value, &err );
		if( !err ) {
		    if( !LineEmpty(line) )
			err = ERR_SYNTAX;
		    else {
			item->x.field.oMax = value;
			plausi.oMin=plausi.oMax=1;
		    }
		}
	    }
	}
    }
    else if( !strcmp( name, "Type") ) {
	if( plausi.flags )
	    err = ERR_ALDEF;
	else {
	    int type=0; /* controlled by err */

	    line = CopyWord( line, name, &err );
	    if( !err ) {
		if( !strcmp( name, "Alfa" ) ) {
		    type = item->x.field.flags = DLG_FIELD_ALFA;
		    plausi.flags = 1;
		}
		else if( !strcmp( name, "Fix" ) ) {
		    type = item->x.field.flags = DLG_FIELD_FIX;
		    plausi.flags = 1;
		}
		else if( !strcmp( name, "Float" ) ) {
		    type = item->x.field.flags = DLG_FIELD_FLOAT;
		    plausi.flags = 1;
		}
		else
		    err = ERR_INVKWD;

		while( !LineEmpty( line ) && !err ) {
		    line = CopyWord( line, name, &err );
		    if( !err ) {
			if( !strcmp( name, "CapsLock" ) &&
					    type == DLG_FIELD_ALFA )
			    item->x.field.flags |= 1 << 4;
			else if( !strcmp( name, "Auto" ) )
			    item->x.field.flags |= 1 << 8;
			else if( !strcmp( name, "NoEdit" ) )
			    item->x.field.flags |= 1 << 9;
			else if( !strcmp( name, "Points" ) &&
					    type == DLG_FIELD_FIX ) {
			    line += strspn( line, "\t " );
			    if( *line >= '0' && *line <= '9' ) {
				xVal = *line - '0' ;
				item->x.field.flags |= xVal << 4;
				line++;
			    }
			    else
				err = ERR_RANGE;
			}
			else
			    err = ERR_UKWKWD;
		    }
		}

	    }
	}
    }
    else
	err = ERR_INVKWD;
    return err ;
}


/*
 * Eine Sub Entry vom Typ Button verarbeiten
 */

static int ProcSubButton( const char *line, char *name, item_t *item )
{
    int err;
    ushort value;
    short xVal, yVal;
    int nBtn;

    err = 0;
    nBtn = item->x.button.nBtn;
    if( nBtn >= MAX_BUTTONS )
	err = ERR_2MBTNS;   /* too many buttons */

    if( err )
	;
    else if( !strcmp( name, "Pos") ) {
	line = GetXYVal( line, &xVal, &yVal, &err );
	if( !err ) {
	    item->x.button.btn[nBtn].px = xVal;
	    item->x.button.btn[nBtn].py = yVal;
	    plausi.px = plausi.py = 1;
	    if( !LineEmpty(line) ) {
		line = GetString( line, &value, &err );
		if( !err ) {  /* String vorhanden, take it */
		    item->x.button.btn[nBtn].oText = value;
		    plausi.oText = 1 ;
		}
		err = 0;
		if( !LineEmpty(line) ) {
		    line = CopyWord( line, name, &err );
		    if( !err ) {
			if( !strcmp( name, "On" ) ) {
			    if( plausi.val )
				err = ERR_ALDEF;
			    else {
				item->x.button.val = nBtn;
				plausi.val++;
			    }
			}
			else
			    err = ERR_SYNTAX;
		    }
		}
	    }
	    if( !err )
		nBtn++;
	}
    }
    else if( !strcmp( name, "Help") ) {
	if( plausi.oHelp )
	    err = ERR_ALDEF;
	else {
	    line = GetString( line, &value, &err );
	    if( !err ) {
		if( !LineEmpty(line) )
		    err = ERR_SYNTAX;
		else {
		    item->x.button.oHelp = value;
		    plausi.oHelp=1;
		}
	    }
	}
    }
    else
	err = ERR_INVKWD;

    item->x.button.nBtn = nBtn;
    return err ;
}



/*
 * Eine Sub Entry vom typ ListBox verarbeiten
 */

static int ProcSubLstbox( const char *line, char *name, item_t *item )
{
    int err;
    ushort value;
    short xVal, yVal;

    err = 0;
    if( !strcmp( name, "Pos") ) {
	if( plausi.px )
	    err = ERR_ALDEF;
	else {
	    line = GetXYVal( line, &xVal, &yVal, &err );
	    if( !err ) {
		if( !LineEmpty(line) )
		    err = ERR_SYNTAX;
		else {
		    item->x.lstbox.px = xVal;
		    item->x.lstbox.py = yVal;
		    plausi.px = plausi.py = 1;
		}
	    }
	}
    }
    else if( !strcmp( name, "Size") ) {
	if( plausi.sx )
	    err = ERR_ALDEF;
	else {
	    line = GetXYVal( line, &xVal, &yVal, &err );
	    if( !err ) {
		if( !LineEmpty(line) )
		    err = ERR_SYNTAX;
		else {
		    item->x.lstbox.sx = xVal;
		    item->x.lstbox.sy = yVal;
		    plausi.sx = plausi.sy = 1;
		}
	    }
	}
    }
    else if( !strcmp( name, "Help") ) {
	if( plausi.oHelp )
	    err = ERR_ALDEF;
	else {
	    line = GetString( line, &value, &err );
	    if( !err ) {
		if( !LineEmpty(line) )
		    err = ERR_SYNTAX;
		else {
		    item->x.lstbox.oHelp = value;
		    plausi.oHelp=1;
		}
	    }
	}
    }
    else if( !strcmp( name, "NoFrame") ) {
	if( plausi.flg0 )
	    err = ERR_ALDEF;
	else {
	    item->x.lstbox.flag |= 1;
	    plausi.flg0=1;
	}
    }
    else if( !strcmp( name, "SelectColumn") ) {
	if( plausi.flg1 )
	    err = ERR_ALDEF;
	else {
	    item->x.lstbox.flag |= 2;
	    plausi.flg1=1;
	}
    }
    else
	err = ERR_INVKWD;
    return err ;
}




/*
 * Die Werte berprfen und in die Tabelle schreiben.
 * ( auch fr Text und Window )
 * Returns err;
 */

static int WriteValues( item_t *item )
{
    int err;

    err = ERR_INCMPL;
    if( windowDataOkay || item->type == DLG_WINDOW ) {
	switch( item->type ) {
	  case DLG_WINDOW:
	    if( windowDataOkay )
		err = ERR_ALDEF;
	    else if( plausi.px && plausi.py && plausi.sx && plausi.sy ) {
		windowDataOkay = 1;
		err = 0;
	    }
	    break;

	  case DLG_TEXT:
	    if( plausi.px && plausi.py && plausi.oText )
		err = 0;
	    break;

	  case DLG_FIELD:
	    if( plausi.px && plausi.py && plausi.sx && plausi.sy &&
		plausi.id && plausi.flags )
		err = 0;
	    break;

	  case DLG_BUTTON:
	    if( plausi.id && plausi.px && plausi.py && item->x.button.nBtn ) {
		if( item->x.button.nBtn == 1 )	/* Check Button */
		    item->x.button.val = plausi.val ? 1 : 0;
		err = 0;
	    }
	    break;

	  case DLG_LSTBOX:
	    if( plausi.px && plausi.py && plausi.sx && plausi.sy &&
		plausi.id )
		err = 0;
	    break;

	  default: Bug("Invalid Itemtype %d in WriteValues", item->type );
	}
    }


    if( !err ) {
	usedItems++;
	memset(&plausi, 0, sizeof plausi );
    }

    return err;
}




/*
 * Funktion holt das nchste Wort aus dem String heraus und kopiert
 * es in name, bei einem Fehler wird err gesetzt.
 * Returns: Pointer to next Character behind the Word
 */

static const char *CopyWord( const char *line, char *name, int *err )
{
    size_t len ;

    line += strspn( line, "\t " ); /* skip Blanks */
    if( *line == '\"' || !*line )
	*err = ERR_SYNTAX;
    else {
	len = strcspn( line, "\t " );  /* get length of word */
	if( len > MAX_NAMELEN || !len )
	    *err = ERR_SYNTAX;
	else {
	    strncpy( name, line, len );
	    name[len] = '\0';
	    line += len;
	}
    }
    return line;
}



/*
 * Funktion holt den nchsten Wert, dabei kann es sich um eine
 * Zahl handeln oder aber um ein Macro; bei einem Fehler wird err
 * gesetzt;
 * Returns: Pointer to next Character behind the Macro or Value
 */

static const char *CopyMacro( const char *line, ushort *value, int *err )
{
    char name[MAX_NAMELEN+1]; /*  temp. Buffer */
    long hl;

    line = CopyWord( line, name, err );
    if( *err )
	;
    else if( isdigit(*name) ) { /* value */
	hl = strtol( name, NULL, 0 );
	if( hl < 0L || hl > 0x0ffff )
	    *err = ERR_RANGE;
	else
	    *value = (ushort)hl;
    }
    else
	*err = GetMacro(name, value);
    return line;
}

/*
 * Die Funktion nimmt die nchsten beiden Werte als x und y Werte und gibt
 * diese zurck, sind diese Werte in der zeile niocht vorhanden, so
 * wird err gesetzt ( *err wird nicht auf 0 gesetzt ! )
 * Returns: Pointer to character behind yVal-String ( may be '\0' )
 */

static const char *GetXYVal( const char *line,
			     short *xVal, short *yVal, int *err )
{
    long hl;
    const char *endp;
    char *pp;

    line += strspn( line, "\t " ); /* skip Blanks */
    hl = strtol( line, &pp, 0 );
    endp = pp;
    line = endp;
    if( !isspace( *line ) )
	*err = ERR_SYNTAX ;
    else if( hl < SHRT_MIN || hl > SHRT_MAX )
	*err = ERR_RANGE;
    else {
	*xVal = (short)hl;
	line += strspn( line, "\t " ); /* skip Blanks */
	hl = strtol( line, &pp, 0 );
	endp = pp;
	line = endp;
	if( !isspace( *line ) && *line )
	    *err = ERR_SYNTAX ;
	else if( hl < SHRT_MIN || hl > SHRT_MAX )
	    *err = ERR_RANGE;
	else
	    *yVal = (short)hl;
    }
    return line;
}

/*
 * Die funktion nimmt den nchsten wert als byte Value
 */

static const char *GetByteVal( const char *line, byte *val, int *err )
{
    long hl;
    const char *endp;
    char *pp;

    line += strspn( line, "\t " ); /* skip Blanks */
    hl = strtol( line, &pp, 0 );
    endp = pp;
    line = endp;
    if( !isspace( *line ) )
	*err = ERR_SYNTAX ;
    else if( hl < 0 || hl > 255 )
	*err = ERR_RANGE;
    else {
	*val = (short)hl;
    }
    return line;
}


/*
 * Die Funktion holt den nchsten String aus der Zeile und schreibt Ihn
 * in die TextTabelle, in value der der Offset zur texttabelle
 * zurckgegeben; bei einem Fehler wird err gesetzt.
 * Returns: Pointer zum Zeichen hinter dem String
 */

static const char *GetString( const char *line, ushort *value, int *err )
{
    ushort off;
    size_t copied;

    line += strspn( line, "\t " ); /* skip Blanks */
    if( *line != '\"' )
	*err = ERR_SYNTAX;
    else {
	off = usedTbl;
	line = ProcStrg( textTbl+off, line, TEXTTBL_SIZE-usedTbl, &copied );
	if( !line )
	    *err = ERR_INVSTR;
	else if( usedTbl + copied + 1+1 >= TEXTTBL_SIZE )
	    *err = ERR_R2BIG;
	else {
	    usedTbl += copied;
	    textTbl[usedTbl++] = '\0' ; /* append String terminator */
	    *value = off;
	}
    }

    return line;
}



/*
 * Untersuchen ob die Zeile leer ist
 * Returns: True = Line Is empty
 *	    false = es sind noch Zeichen vorhanden
 */

static int LineEmpty( const char *line )
{
    for( ; *line; line++ )
	if( !isspace( *line ) )
	    return 0;
    return 1;
}

/**** end of file ****/

