/* [wkrc_3.c wk 3.6.91] WKRC: Proc Resource PDMenu
 *	Copyright (c) 1991 by Werner Koch (dd9jn)
 *
 * Resource: Pull Down Menu ( for menu?.c )
 * History:
 * 05.07.93 wk	Flags jetzt direkt bitwesie codiert
 */

#include <wk/tailor.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <wk/lib.h>
#include <wk/string.h>

#include "wkrc.h"

/******* constants *********/
#define NAMETBL_SIZE  8192     /* max. Size of nameTable */
#define MAX_ITEMS     300      /* sollte reichen */

/****** types ******/
typedef struct {
	ushort oName;	    /* Offset into NameTable */
	ushort id;
	struct {
	    unsigned level:4;
	    int special:1;
	    int enabled:1;
	    int toggle:1;
	    int togStat:1;
	    int reserved:3; /* force compiler to use 2 Bytes */
	} flag;
    } minfo_t;


/***** globals *****/
static char    *nameTbl;    /* Ptr to NameTable  */
static size_t  usedTbl;     /* # of bytes used in NameTbl */
static minfo_t *itemTbl;
static int     usedItems;
static int     menuLevel;

/******* local protos ******/
static int ProcLine( const char *line );
static int LineEmpty( const char *line );
/******** functions *********/

/*
 * Dies Funktion verarbeitet die Zeilen des Resourcetypes:
 *     PDMenu ( Pull Down Menu )
 * Mode = 0 : Initialisieren
 *	  1 : Zeile
 *	  2 : Endbehandlung
 * line = bei mode 1 : Sourceline
 *	  sonst      : ResourceName
 * Blanks am Anfang und am Ende einer Zeile sind bereits entfernt.
 * Returns: ErrorCode
 */

int ProcRcPDMenu( const char *line, int mode )
{
    int err, i;

    if( mode == 1 )
	err = *line ? ProcLine( line ) : 0 /* skip empty lines */;
    else if( !mode  ) { /* init */
	itemTbl = xcalloc( MAX_ITEMS+1, sizeof *itemTbl );
	usedItems = 0;
	nameTbl = xmalloc( NAMETBL_SIZE+1 );
	*nameTbl = '\0'; /* first entry must be an empty String */
	usedTbl = 1;
	menuLevel = 0; /* Start with TopMenu */
	/* (line contains resourcename) */
	printf("Processing PDMenu-Resource `%s'\n", line );
	err = 0;
    }
    else { /* exit */
	ushort uhlp;

	if( menuLevel )
	    err = ERR_UBNEST;
	else {
	    StartTempFile( line ); /* contains resourcename */
	    uhlp = RC_PDMENU;
	    WriteTempFile( &uhlp, sizeof uhlp );    /* Resource ID */
	    uhlp = usedItems;
	    WriteTempFile( &uhlp, sizeof uhlp );    /* # of Items */
	    uhlp = usedTbl;
	    WriteTempFile( &uhlp, sizeof uhlp );    /* bytes in NameTbl */
	    uhlp = usedTbl;
	    WriteTempFile( nameTbl, uhlp );	    /* NameTbl */
	    for(i=0; i < usedItems; i++ ) {
		uhlp = itemTbl[i].oName;
		WriteTempFile( &uhlp, sizeof uhlp );
		uhlp = itemTbl[i].id;
		WriteTempFile( &uhlp, sizeof uhlp );
		uhlp = itemTbl[i].flag.level;
		uhlp |= itemTbl[i].flag.special << 4;
		uhlp |= itemTbl[i].flag.enabled << 5;
		uhlp |= itemTbl[i].flag.toggle	<< 6;
		uhlp |= itemTbl[i].flag.togStat << 7;
		WriteTempFile( &uhlp, sizeof uhlp );
	    }
	    err = 0 ;
	}

	free( nameTbl ) ;
	free( itemTbl ) ;
    }

    return err;
}



/*
 * Eine Zeile verarbeiten, die Zeile kann Format elemente der folgenden
 * Format ist in rc.doc beschrieben
 * Returns: ErrorCode
 */

static int ProcLine( const char *line )
{
    int err;
    char name[MAX_NAMELEN+1]; /*  temp. Buffer */
    size_t len;
    minfo_t *item=NULL; /* controlled by err */
    long hl;
    ushort offName;
    ushort value;


    err = 0;
    if( usedItems < MAX_ITEMS )
	item = itemTbl + usedItems;
    else
	err = ERR_R2MANY;   /* too many items */

    if( err )
	;
    else if( *line == '\"' ) { /* String */
	offName = usedTbl;
	line = ProcStrg( nameTbl+offName, line, NAMETBL_SIZE-usedTbl, &len );
	if( !line )
	    err = ERR_INVSTR;
	else {
	    usedTbl += len;
	    nameTbl[usedTbl++] = '\0' ; /* append String terminator */
	    line += strspn( line, "\t " ); /* skip Blanks */
	    mem2str( name, line, DIM(name) );
	    len = strcspn( line, "\t " );
	    if( len < strlen(name) )
		name[len] = '\0';
	    line += len;

	    if( !len ) { /* that must be a simple text */
		item->oName = offName; /* offset in nameTbl */
		item->id = 1 ; /* insert plain text */
		item->flag.level = menuLevel;
		item->flag.special = 1;
		usedItems++;
	    }
	    else {
		if( isdigit(*name) ) { /* value */
		    hl = strtol( name, NULL, 0 );
		    if( hl < 0L || hl > 0x0ffff )
			err = ERR_RANGE;
		    else
			value = (ushort)hl;
		}
		else
		    err = GetMacro(name, &value);
		if( !err ) {
		    int ena, dis, tg, tgon;

		    ena = dis = tg = tgon = 0;
		    /* look for more keywords */
		    while( *line && !err ) {
			line += strspn( line, "\t " ); /* skip Blanks */
			mem2str( name, line, DIM(name) );
			len = strcspn( line, "\t " );
			if( len < strlen(name) )
			    name[len] = '\0';
			line += len ;
			if( !*name )
			    ;	/* end of line */
			else if( !strcmp( name, "Enabled" ) && !dis )
			    ena = 1;
			else if( !strcmp( name, "Disabled" ) && !ena && !dis )
			    dis = 1;
			else if( !strcmp( name, "Toggle" ) && !tg && !tgon )
			    tg = 1;
			else if( !strcmp( name, "ToggleOn" ) && !tg && !tgon )
			    tgon = tg = 1;
			else
			    err = ERR_UKWKWD;
		    }
		    if( !err ) {
			item->oName = offName; /* offset in nameTbl */
			item->id = value ;
			item->flag.level = menuLevel;
			item->flag.special = 0;
			item->flag.enabled = dis ? 0 : 1;
			item->flag.toggle  = tg;
			item->flag.togStat = tgon;
			usedItems++;
		    }

		}
	    }
	}
    }
    else {  /* special */
	len = strcspn( line, "\t " );
	if( len > MAX_NAMELEN || !len )
	    err = ERR_SYNTAX;
	else {
	    strncpy( name, line, len );
	    name[len] = '\0';
	    line += len;
	    if( !strcmp( name, "Sub") ) {
		if( !LineEmpty(line) )
		    err = ERR_SYNTAX;
		else
		    menuLevel++;
	    }
	    else if( !strcmp( name, "End") ) {
		if( !LineEmpty(line) )
		    err = ERR_SYNTAX;
		else if( !menuLevel )
		    err = ERR_UBNEST;	/* too many Ends */
		else
		    menuLevel--;
	    }
	    else if( !strcmp( name, "Separator") ) {
		if( !LineEmpty(line) )
		    err = ERR_SYNTAX;
		else {
		    item->oName = 1 ; /* unused, but don't use 0 */
		    item->id = 4 ; /* insert separator bar */
		    item->flag.level = menuLevel;
		    item->flag.special = 1;
		    usedItems++;
		}
	    }
	    else if( !strcmp( name, "Blank") ) {
		if( !LineEmpty(line) )
		    err = ERR_SYNTAX;
		else {
		    item->oName = 1 ; /* unused, but don't use 0 */
		    item->id = 3 ; /* insert blanks as separator */
		    item->flag.level = menuLevel;
		    item->flag.special = 1;
		    usedItems++;
		}
	    }
	    else if( !strcmp( name, "LocRight") ) {
		if( !LineEmpty(line) )
		    err = ERR_SYNTAX;
		else
		    ;	/* only syntacticaly implemented */
	    }
	    else
		err = ERR_UKWKWD;
	}
    }

    return err ;
}


/*
 * Untersuchen ob die Zeile leer ist
 * Returns: True = Line Is empty
 *	    false = es sind noch Zeichen vorhanden
 */

static int LineEmpty( const char *line )
{
    for( ; *line; line++ )
	if( !isspace( *line ) )
	    return 0;
    return 1;
}

/**** end of file ****/

