/* [wkrc_1.c wk 1.6.91] WKRC: Proc Resource StringBlock
 *	Copyright (c) 1991 by Werner Koch (dd9jn)
 * $Header: /usr/src/master/libs/wkswn/wkrc_1.c,v 1.2 1996/09/10 12:24:48 wk Exp $
 */

#include <wk/tailor.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <wk/lib.h>
#include <wk/string.h>

#include "wkrc.h"

/******* constants *********/
#define MAX_BLOCKSIZE  16384	/* we can allocate this in every memory model*/
#define MAX_ENTRIES  (MAX_BLOCKSIZE/4) /* 4 is the sizeof entry_t */

/****** types ******/
typedef struct {
	ushort value;
	ushort offset;
    } entry_t;

/***** globals *****/
static int     msgTypeFlag; /* process an STringMsg Resource */
static entry_t *entryTable; /* Table for entry descriptor */
static size_t  usedEntries; /* # of used entries in table */
static char    *memBlock;   /* Ptr to memory Block for Strings */
static size_t  usedMem;     /* # of bytes used in memBlock */

/******* local protos ******/
static int Initialize(const char*);
static int Terminate(const char*);
static int CompareEntry( const void *, const void *);
static int Process(const char*);
/******** functions *********/

/*
 * Dies Funktion verarbeitet die Zeilen des Resourcetypes:
 *     StringBlock
 * Mode = 0 : Initialisieren (line gibt dann den Resourcenamen an )
 *	  1 : Zeile
 *	  2 : Endbehandlung  (line gibt dann den Resourcenamen an )
 *	  3 : Init, aber fr Type StringMsg
 * Blanks am Anfang und am Ende sind bereits entfernt.
 * Returns: ErrorCode
 */

int ProcRcStrBlk( const char *line, int mode )
{
    int err ;

    if( mode == 1 )
	err = Process( line );
    else if( mode == 2 ) {
	err = Terminate( line );
    }
    else { /* init */
	msgTypeFlag = mode;
	err = Initialize( line ); /* line contains resourcename */
    }

    return err;
}


/*
 * Die Datenstrukturen fr diesen ResourceTyp initialisieren
 */

static int Initialize( const char *resourceName )
{
    entryTable = xcalloc( MAX_ENTRIES, sizeof *entryTable );
    usedEntries = 0;
    memBlock = xmalloc( MAX_BLOCKSIZE );
    usedMem = 0;
    printf("Processing %s-Resource `%s'\n",
                msgTypeFlag ? "StrMsg" : "StrBlk", resourceName );
    return 0;
}


/*
 * Die Endbehandlungen durchfhren
 */

static int Terminate( const char *resourceName )
{
    int err;
    ushort n, k, eCnt, largest, lh;
    char *p;
    ushort uhlp;

    err = 0;
    /*
     * Here is what we will have to do later:
     *	- Check for duplicated values
     *	- Write the Entry Table to the Library
     *	- Write the used memory to the Library
     *	- Update the Library index
     */

    if( usedEntries )
	largest = strlen( memBlock + entryTable[0].offset ) ;
    else
	largest = 0 ;
    if( usedEntries > 1 ) {
	/* sort table for ascending values */
	qsort( entryTable, usedEntries, sizeof *entryTable, CompareEntry );
	eCnt = 0;
	for(n=1; n < usedEntries; n++ ) {
	    if( msgTypeFlag )
		if( (lh = strlen( memBlock+entryTable[n].offset )) > largest )
		    largest = lh;
	    if( entryTable[n-1].value == entryTable[n].value ) {
                printf("ResourceValue %u already used\n", entryTable[n].value);
		eCnt++;
	    }
	}
	if( eCnt )
	    err = ERR_VALUE;
    }

    if( !err ) {
	StartTempFile( resourceName );
	if( msgTypeFlag ) {
	    uhlp = RC_STRMSG;
	    WriteTempFile( &uhlp, sizeof uhlp );    /* Resource ID */
	    /* calc number of entries == highest Number + 1 */
	    if( usedEntries )
		usedEntries = entryTable[usedEntries-1].value + 1;
	    uhlp = usedEntries;
	    WriteTempFile( &uhlp, sizeof uhlp );    /* # of entries */
	    uhlp = largest ;
	    WriteTempFile( &uhlp, sizeof uhlp );    /* len of largest string */
	    for(n=k=0; n < usedEntries; n++, k++ ) {
		for( ; n < entryTable[k].value; n++ )
                    WriteTempFile( "", 1 ); /* string terminator */
		p = memBlock + entryTable[k].offset;
		WriteTempFile( p, strlen(p)+1 );
	    }
	}
	else { /* String Block */
	    uhlp = RC_STRBLK;
	    WriteTempFile( &uhlp, sizeof uhlp );    /* Resource ID */
	    xassert( sizeof( entry_t ) == 4 );
	    uhlp = usedEntries * sizeof( entry_t );
	    WriteTempFile( &uhlp, sizeof uhlp );	/* size of entryTable */
	    WriteTempFile( &usedMem, sizeof usedMem );	/* size fo dataArea */
	    WriteTempFile( entryTable, sizeof(entry_t) * usedEntries ); /* table */
	    WriteTempFile( memBlock, usedMem ); 	/* data Area */
	}


      #if 0
        puts("------- Resource Block ---------");
	for( i=0; i < usedEntries ; i++ )
            printf( "%05u - `%s'\n", entryTable[i].value,
			    memBlock+entryTable[i].offset );
        puts("--------------------------------");
        printf( "# of entries = %u; size of memoryBlock = %u\n",
		 usedEntries, usedMem );
      #endif /* DEBUG */

    }

    free( memBlock );
    free( entryTable );

    return err;
}


/*
 * Compare function for qsort()
 */

static int CompareEntry( const void *a, const void *b )
{
    if( ((entry_t*)a)->value < ((entry_t*)b)->value )
	return -1 ;
    else if( ((entry_t*)a)->value > ((entry_t*)b)->value )
	return 1 ;
    else
	return 0 ;
}



/*
 * Eine Zeile verarbeiten
 * Format of line must be:
 *  macro | number '=' c-style-string
 *  or an empty line
 */

static int Process( const char *line )
{
    int err , catFlag;
    size_t len, stringLen, unused;
    char macroName[MAX_NAMELEN+1];
    ushort value;
    long hl;

    catFlag = err = 0;
    if( *line ) {
	mem2str( macroName, line, DIM(macroName) );
        len = strcspn( line, "\t " );
	if( len < strlen(macroName) )
            macroName[len] = '\0';

	if( isdigit(*macroName) ) {
	    hl = strtol( macroName, NULL, 0 );
	    if( hl < 0L || hl > 0x0ffff )
		err = ERR_RANGE;
	    else
		value = (ushort)hl;
	}
        else if( *macroName == '\"' ) {  /* no macro */
	    if( usedEntries )
		catFlag++ ;
	    else
		err = ERR_SYNTAX; /* nothing to concatenate */
	}
        else if( *macroName == '=' )
	    err = ERR_SYNTAX;
	else
	    err = GetMacro(macroName, &value);

	if( !err ) {
	    if( !catFlag ) {
		line += len;
                line += strspn( line, "\t " );
                if( *line != '=' )
		    err = ERR_SYNTAX ;
		else
		    line++;
	    }
	    if( !err ) {
		if( catFlag )
		    usedMem--;	/* remove string terminator */
		/* now get the String */
		unused = MAX_BLOCKSIZE - usedMem ;
		if( unused < strlen(line)+1 )
		    err = ERR_R2BIG;
		else if( usedEntries >= MAX_ENTRIES && !catFlag )
		    err = ERR_R2MANY;
		else {
		    if( !ProcStrg( memBlock+usedMem,
				  (char*)line, unused, &stringLen ) )
			err = ERR_INVSTR;
		    else {
			if( !catFlag ) {
			    entryTable[usedEntries].value = value ;
			    entryTable[usedEntries].offset= usedMem ;
			    usedEntries++;
			}
			usedMem += stringLen;
                        memBlock[usedMem++] = '\0' ; /* copy String terminator */
		    }
		}

	    }
	}

    }

    return err;
}


/**** end of file ****/

