/* [wkrc4.c wk 1.6.91] WKRC: Einen Resourceentry verarbeiten
 *	Copyright (c) 1991 by Werner Koch (dd9jn)
 * $Header: /usr/src/master/libs/wkswn/wkrc4.c,v 1.3 1997/01/07 14:47:13 wk Exp $
 */

#include <wk/tailor.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <wk/lib.h>
#include <wk/string.h>

#include "wkrc.h"

/******* constants *********/
/****** types ******/
/***** globals *****/
/******* local protos ******/
static int ProcLine( const char *, int *, int *, char *);
static const char *GetString( const char *line );
/******** functions *********/

/*
 * Diese Funktion sucht in einem geffnetet Stream
 * nach dem Anfang einer Resourcedefinition
 * Listed den Resource Header ein, berprft diesen,
 * Wartet auf den Blockanfang, gibt die Zeichen innerhalb des Blocks
 * an eine Funktion weiter, die die entsprechende Verarbeitung
 * dieses Resourcetyps bernimmt; dies alles solange bis
 * das Ende des Blocks erreicht ist. Dannach wird die Funktion beendet.
 * Include Files werden von dieser Funktion ebenfalls erkannt und
 * verarbeitet ( durch ReadIncludeFile() ).
 * es wird davon ausgegangen, da der Stream auf einen Zeilenanfang
 * ausserhalb eines Kommentars und eines Strings positioniert ist.
 * Returns: ErrorCode
 */

int ProcNextResource( FILE *st, long *argLineNumber,
		      const char *fileName, int *helper )
{
    int  err, c , lineInd;
    char *line;
    long lineNumber;
    char rcName[MAX_NAMELEN+1];
    int  rcType;
    int  inBlockFlag, inHeaderFlag;

    line = xmalloc( MAX_LINELEN+1 ) ;
    err = 0;
    lineInd = 0;
    lineNumber = *argLineNumber;
    inBlockFlag = 0;
    inHeaderFlag = 1;
    while( (inHeaderFlag || inBlockFlag) && !err ) {
	c = RemoveComment(c=getc(st), helper );
	if( c == EOF )
	    inHeaderFlag = 0;
	else if( c == '\n' ) {
	    /* proc Line */
	    line[lineInd] = '\0';
	    StripWSpaces(line);
	    if( err = ProcLine(line, &inBlockFlag, &rcType, rcName ) )
		PrintError(line, fileName, lineNumber, err );
	    else if( inBlockFlag ) {
		if( inHeaderFlag ) {
		    inHeaderFlag = 0;  /* dann sind wird nicht mehr im header*/
		    switch( rcType ) {
		      case RC_STRBLK:
			err = ProcRcStrBlk( rcName, 0 ); /* init */
			break;
		      case RC_STRMSG:
			err = ProcRcStrBlk( rcName, 3 ); /*init 3=special*/
			break;
		      case RC_PLAIN:
			err = ProcRcPlain( rcName, 0 ); /* init */
			break;
		      case RC_PDMENU:
			err = ProcRcPDMenu( rcName, 0 ); /* init */
			break;
		      case RC_DLGWIN:
			err = ProcRcDlgWin( rcName, 0 ); /* init */
			break;
		      default: BUG();
		    }
		    if( err )
			PrintError(line, fileName, lineNumber, err );
		}
		else {
		    switch( rcType ) {
		      case RC_STRBLK:
		      case RC_STRMSG:
			err = ProcRcStrBlk( line, 1 );
			break;
		      case RC_PLAIN:
			err = ProcRcPlain( line, 1 );
			break;
		      case RC_PDMENU:
			err = ProcRcPDMenu( line, 1 );
			break;
		      case RC_DLGWIN:
			err = ProcRcDlgWin( line, 1 );
			break;
		      default: BUG();
		    }
		    if( err )
			PrintError(line, fileName, lineNumber, err );
		}
	    }
	    else if( !inHeaderFlag ) {
		/* fertig: Endbehandlung durchfhren */
		switch( rcType ) {
		  case RC_STRBLK:
		  case RC_STRMSG:
		    err = ProcRcStrBlk( rcName, 2 ); /* exit */
		    break;
		  case RC_PLAIN:
		    err = ProcRcPlain( rcName, 2 ); /* exit */
		    break;
		  case RC_PDMENU:
		    err = ProcRcPDMenu( rcName, 2 ); /* exit */
		    break;
		  case RC_DLGWIN:
		    err = ProcRcDlgWin( rcName, 2 ); /* exit */
		    break;
		  default: BUG();
		}
		if( err )
		    PrintError(line, fileName, lineNumber, err );
	    }
	    lineInd = 0;
	    lineNumber++;
	}
	else {
	    line[lineInd] = c ;
	    if( ++lineInd > MAX_LINELEN ) {
		printf("File `%s': line %ld too long\n",
			    fileName, lineNumber );
		err = ERR_FATAL;
	    }
	}
    }


    /*
     * Bei einem Fehler sollten hier noch die Resource Proc Module
     * aufgerumt werden.
     */

    *argLineNumber = lineNumber;
    free( line );
    return err;
}



/*
 * Die Funktion untersucht eine Zeile unf fhrt die entsprechenden
 * Aktionen durch.
 * Spaces am Anfag und am Ende der bergebenen Zeile  sind bereits entfernt.
 * - inBlock zeigt auf eine Variable, die angibt, ob die Verarbeitung sich
 *   innerhalb des Blocks befindet. Wird durch .EndRc
 *   zurckgesetzt.
 * - rcType zeigt auf eine Variable die den Resource Type enthlt.
 * - rsName ist ein Buffer der Lnge MAX_NAMELEN+1
 *   der den Namen der Resource enthlt.
 * Returns: ErrorCode
 */

static int ProcLine( const char *line,
		     int *inBlock, int *rcType, char *rcName )
{
    int err , i;
    size_t len;
    const char *string;
    static char *keyWords[] = {
		"Include",
		"BeginRc",
		"EndRc",
		NULL
	    } ;

    err = 0;
    if( *line == '.' ) { /* may be a keyword */
	line++ ;
	len = strspn( line, "\t " );
	if( len < strlen( line ) ) {
	    line += len ;
	    len = strcspn( line, "\t " );
	    /* scan for the keywords */
	    for(i=0; keyWords[i]; i++ )
		if( strlen( keyWords[i] ) == len  )
		    if( !memcmp( line, keyWords[i], len ) )
			break;
	    line += len;
	    switch(i) {
	      case 0:	/* Include */
		err = ReadIncludeFile( GetString(line) );
		break;
	      case 1:	/* StartOfResource */
		if( *inBlock )
		    err = ERR_SYNTAX;
		else {
		    string = GetString(line);
		    if( !string )
			err = ERR_SYNTAX;   /* type missing */
		    else {
			len = strcspn( string, "\t " );
			line = string + len ;
			if( len > MAX_NAMELEN || !len )
			    err = ERR_INVTYP;
			else {
			    /* temp. use of rcName */
			    strncpy( rcName, string, len );
			    rcName[len] = '\0';
			    if( !strcmp( rcName, "StrBlk") )
				*rcType = RC_STRBLK;
			    else if( !strcmp( rcName, "StrMsg") )
				*rcType = RC_STRMSG;
			    else if( !strcmp( rcName, "Plain") )
				*rcType = RC_PLAIN;
			    else if( !strcmp( rcName, "PDMenu") )
				*rcType = RC_PDMENU;
			    else if( !strcmp( rcName, "DlgWin") )
				*rcType = RC_DLGWIN;
			    else
				err = ERR_INVTYP ;
			}
		    }
		    if( !err ) {
			string = GetString(line);
			if( !string )
			    err = ERR_SYNTAX;	/* type missing */
			else {
			    len = strcspn( string, "\t " );
			    if( len > MAX_NAMELEN || !len )
				err = ERR_SYNTAX;   /* name too long */
			    else {
				strncpy( rcName, string, len );
				rcName[len] = '\0';
				++*inBlock;
			    }
			}
		    }
		}
		break;
	      case 2:	/* EndOfResource */
		if( !*inBlock )
		    err = ERR_SYNTAX;
		else
		    *inBlock = 0; /* End Of Block reached */
		break;
	      default:
		err = ERR_UKWKWD;   /* unkown keyword */
		break;
	    }
	}
	else
	    err = ERR_INVKWD;	/* invalid keyword */
    }
    else if( *inBlock )
	;   /* within the Block all Chars are valid */
    else if( *line )	/* all other characters are forbidden */
	err = ERR_SYNTAX;

    return err;
}



/*
 * Aus einer Zeile wird ein String herausgelst.
 * Dies kann z.B. ein Pfadname oder etwas anderes sein
 * z.Z. primitiv, da ein String nicht durch "" oder <>
 * begrenzt ist.
 * White Spaces werden bersprungen
 * Am Stringende wird nichts gemacht.
 * Returns: Pointer to String
 */

static const char *GetString( const char *line )
{
    line += strspn( line, "\t " );
    return line;
}


/**** end of file ****/

