/* [wkrc3.c wk 1.6.91] WKRC: Includefile einlesen
 *	Copyright (c) 1991 by Werner Koch (dd9jn)
 * $Header: /usr/src/master/libs/wkswn/wkrc3.c,v 1.2 1996/09/10 12:24:48 wk Exp $
 */

#include <wk/tailor.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <wk/lib.h>
#include <wk/string.h>
#include <wk/file.h>

#include "wkrc.h"

/*** constants *****/
/****** types ******/
/***** globals *****/
/******* local protos ******/
static int ProcLine( const char *line );
/******** functions *********/


/*
 * Die Funktion liest einen Includefile
 * und speichert die Macros ab
 * Return: 0 = okay
 */

int ReadIncludeFile( const char *fileName )
{
    FILE *st;
    int helper, err, c , lineInd;
    char *line;
    long lineNumber;


    line = xmalloc( MAX_LINELEN+1 ) ;
    err = 0;
    if( !(st = fsopen(fileName, "r")) )
	err = ERR_FILENF;
    else {
	helper = 0;
	lineInd = 0;
	lineNumber = 1L;
	while( (c = RemoveComment(c=getc(st), &helper )) != EOF ) {
            if( c == '\n' ) {
		/* proc Line */
                line[lineInd] = '\0';
		StripWSpaces(line);
		if( err = ProcLine(line) ) {
		    PrintError( line, fileName, lineNumber, err );
		    break; /* While loop */
		}
		lineInd = 0;
		lineNumber++;
	    }
	    else {
		line[lineInd] = c ;
		if( ++lineInd > MAX_LINELEN ) {
                    printf("File `%s': line %ld too long\n",
				fileName, lineNumber );
		    err = ERR_FATAL;
		}
	    }
	}
	if( lineInd && !err ) {
            printf("File `%s': last line is incomplete\n", fileName);
	    err = ERR_FATAL;
	}

	fclose(st);
    }

    free( line );
    return err;
}


/*
 * Die Funktion untersuch eine Zeile auf das Auftrete von
 * Macrodefinitionen und specihert das Macro
 * Balnks am Anfang un ende der Zeile mssen bereits entfernt sein.
 * Return ErrorCode
 */

static int ProcLine( const char *line )
{
    int err ;
    size_t off;

    err = 0;
    if( *line == '#' ) { /* may be a define */
	line++ ;
        off = strspn( line, "\t " );
	if( off < strlen( line ) ) {
	    line += off ;
            off = strcspn( line, "\t " );
            if( !memcmp( line, "define", off ) ) {
		line += off;
                off = strspn( line, "\t " );
		err = StoreMacro(line+off );
	    }
	}
    }

    return err;
}


#ifdef TEST
/*************** main function for Module Test ***************/

int main( int argc, char **argv )
{
    char *fileName ;
    FILE *stream;
    int helper, c ;
    long lineCount;
    int newLine, err;

    if( argc != 2 ) {
        fprintf(stderr,"parameters: Filename");
	exit(3);
    }

    fileName = argv[1];
    printf("Processing file: `%s'\n", fileName);

    if( err = ReadIncludeFile( fileName ) )
        printf("Returns ErrorCode %d\n", err );
    PrintAllMacros();

    return 0;
}

#endif /* TEST */


/**** end of file ****/
